/*
 * Decompiled with CFR 0.152.
 */
package fiji;

import fiji.GraphicalMediaWikiClient;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class Upload_Image_To_Wiki
implements PlugInFilter {
    String url = "http://fiji.sc/wiki/index.php";
    int jpegQuality = 75;
    String title;

    public int setup(String arg, ImagePlus image) {
        this.title = image == null ? null : image.getTitle();
        return 159;
    }

    public void run(ImageProcessor ip) {
        boolean usePNG;
        BufferedImage image = this.getBufferedImage(ip);
        byte[] jpeg = null;
        byte[] png = null;
        try {
            jpeg = this.getBytes(image, "jpeg");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            png = this.getBytes(image, "png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (jpeg == null && png == null) {
            IJ.error((String)"Could not construct JPEG nor PNG");
            return;
        }
        boolean bl = usePNG = jpeg == null || jpeg.length > png.length;
        if (this.title == null) {
            this.title = "<name>";
        } else {
            String[] extensions;
            for (String extension : extensions = new String[]{".jpg", ".jpeg", ".JPG", ".JPEG", ".png", ".PNG"}) {
                if (!this.title.endsWith(extension)) continue;
                this.title = this.title.substring(0, this.title.length() - extension.length());
            }
        }
        this.title = this.title + (usePNG ? ".png" : ".jpg");
        GenericDialog gd = new GenericDialog("Upload " + (usePNG ? "PNG" : "JPEG"));
        gd.addStringField("name", this.title, 30);
        gd.addStringField("summary", this.title, 30);
        gd.addCheckbox("copy [[Image:<name>]] to clipboard", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.title = gd.getNextString();
        String summary = gd.getNextString();
        boolean copyToClipboard = gd.getNextBoolean();
        GraphicalMediaWikiClient client = new GraphicalMediaWikiClient(this.url);
        if (!client.login()) {
            return;
        }
        if (!client.uploadFile(this.title, summary, usePNG ? png : jpeg)) {
            IJ.error((String)("Failed to upload " + this.title));
        }
        client.logOut();
        if (copyToClipboard) {
            this.copyToClipboard();
        }
    }

    BufferedImage getBufferedImage(ImageProcessor ip) {
        BufferedImage image = ip.getBufferedImage();
        if (!ip.isDefaultLut()) {
            return image;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        BufferedImage gray = new BufferedImage(width, height, 10);
        Graphics2D g = gray.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return gray;
    }

    byte[] getBytes(BufferedImage image, String format) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format);
        ImageWriter writer = iter.next();
        if (writer == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(bytes);
        writer.setOutput(ios);
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (format.equals("jpeg")) {
            param.setCompressionMode(2);
            param.setCompressionQuality((float)this.jpegQuality / 100.0f);
            if (this.jpegQuality == 100) {
                param.setSourceSubsampling(1, 1, 0, 0);
            }
        }
        IIOImage iioImage = new IIOImage(image, null, null);
        writer.write(null, iioImage, param);
        ios.close();
        writer.dispose();
        return bytes.toByteArray();
    }

    void copyToClipboard() {
        StringSelection selection = new StringSelection("[[Image:" + this.title + "]]");
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Toolkit.getDefaultToolkit().getSystemSelection().setContents(selection, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

