/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox;

import ij.IJ;
import ij.ImagePlus;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.Reader;
import org.imagearchive.lsm.toolbox.info.CZLSMInfoExtended;
import org.imagearchive.lsm.toolbox.info.EventList;
import org.imagearchive.lsm.toolbox.info.scaninfo.Recording;

public class StampUtils {
    public static String getTStamps(Reader reader, ImagePlus imp) {
        reader.updateMetadata(imp);
        LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
        int n = new Long(cz.timeStamps.NumberTimeStamps).intValue();
        String[] stamps = new String[n];
        for (int k = 0; k < n; ++k) {
            stamps[k] = Double.toString(cz.timeStamps.TimeStamps[k]);
        }
        return StampUtils.implode(stamps);
    }

    public static String getZStamps(Reader reader, ImagePlus imp) {
        reader.updateMetadata(imp);
        LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
        Recording r = cz.scanInfo.recordings.get(0);
        double planeSpacing = (Double)r.records.get("PLANE_SPACING");
        double ps = 0.0;
        String[] stamps = new String[(int)cz.DimensionZ];
        int k = 0;
        while ((long)k < cz.DimensionZ) {
            stamps[k] = IJ.d2s((double)ps, (int)2) + " " + MasterModel.micrometer;
            ps += planeSpacing;
            ++k;
        }
        return StampUtils.implode(stamps);
    }

    public static String getLStamps(Reader reader, ImagePlus imp) {
        reader.updateMetadata(imp);
        LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
        if (cz.SpectralScan != 1) {
            IJ.error((String)"Image not issued from spectral scan. Lambda stamp obsolete!");
            return null;
        }
        String[] stamps = new String[(int)cz.channelWavelength.Channels];
        int k = 0;
        while ((long)k < cz.channelWavelength.Channels) {
            stamps[k] = IJ.d2s((double)cz.channelWavelength.LambdaStamps[k], (int)2);
            ++k;
        }
        return StampUtils.implode(stamps);
    }

    public static String getEvents(Reader reader, ImagePlus imp) {
        reader.updateMetadata(imp);
        LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
        EventList events = cz.eventList;
        StringBuffer buffer = new StringBuffer();
        if (events != null) {
            buffer.append("Time (sec) \tEvent Type \tEvent Description");
            buffer.append(events.Description);
        }
        return buffer.toString();
    }

    private static String implode(String[] input) {
        String result;
        if (input.length == 0) {
            result = "";
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(input[0]);
            for (int i = 1; i < input.length; ++i) {
                sb.append(",");
                sb.append(input[i]);
            }
            result = sb.toString();
        }
        return result;
    }
}

