/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.table.AbstractTableModel;

class TreeTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Tag", "Property"};
    private LinkedHashMap<String, Object> dataMap = null;
    private Object[][] data = null;
    private boolean filtered = false;

    public TreeTableModel(LinkedHashMap<String, Object> dataMap) {
        this.dataMap = dataMap;
        this.setData(dataMap);
    }

    public TreeTableModel() {
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public void setData(LinkedHashMap<String, Object> dataMap) {
        if (dataMap != null) {
            if (this.filtered) {
                dataMap = this.getFilteredMap(dataMap);
            }
            Iterator<String> iterator = dataMap.keySet().iterator();
            this.data = new Object[dataMap.size()][2];
            int i = 0;
            while (iterator.hasNext()) {
                String tag = iterator.next();
                this.data[i][0] = tag;
                this.data[i][1] = dataMap.get(tag);
                ++i;
            }
        } else {
            this.data = null;
        }
        this.fireTableDataChanged();
    }

    public LinkedHashMap<String, Object> getFilteredMap(LinkedHashMap<String, Object> dataMap) {
        LinkedHashMap<String, Object> filteredMap = new LinkedHashMap<String, Object>();
        Iterator<String> iterator = dataMap.keySet().iterator();
        this.data = new Object[dataMap.size()][2];
        int i = 0;
        while (iterator.hasNext()) {
            String tag = iterator.next();
            if (tag.indexOf("<UNKNOWN@") == -1) {
                filteredMap.put(tag, dataMap.get(tag));
            }
            ++i;
        }
        return filteredMap;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean getFiltered() {
        return this.filtered;
    }
}

