/*
 * Decompiled with CFR 0.152.
 */
package volumeCalculator;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.Image3DUniverse;
import ij3d.behaviors.InteractiveBehavior;
import ij3d.behaviors.InteractiveViewPlatformTransformer;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.utils.picking.PickCanvas;
import org.jogamp.java3d.utils.picking.PickResult;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3i;
import sc.fiji.analyzeSkeleton.Edge;
import sc.fiji.analyzeSkeleton.Graph;
import sc.fiji.analyzeSkeleton.Point;
import volumeCalculator.AnalyzedGraph;
import volumeCalculator.UserData;
import volumeCalculator.Volumes;
import volumeCalculator.VolumesPanel;

public class CustomVolumeBehavior2
extends InteractiveBehavior {
    private static int BRANCH_NODE_INDEX = 3;
    private static final String NO_PATH_MSG = "No path between those two points.";
    private final PickCanvas pickCanvas;
    private PickSegment pickSegment = new PickSegment();
    private boolean firstPickPicked;
    private SceneGraphPath firstClickSGP;
    private SceneGraphPath secondClickSGP;
    private Volumes volumes;
    private VolumesPanel volumesPanel;
    private InteractiveViewPlatformTransformer viewTransformer;
    private final ImagePlus originalImage;
    private final int imageHeight;
    private final int imageWidth;
    private final int imageDepth;
    HashMap<Edge, CopyOnWriteArrayList<Blob>> edgeBlobs = new HashMap();
    List<List<Blob>> nSliceBlobs;
    int grandVoxelCount = 0;
    double grandVoxelCountD = 0.0;

    public CustomVolumeBehavior2(Image3DUniverse universe, Content content, Volumes volumes, VolumesPanel volumesPanel, ImagePlus imagePlus, ImagePlus originalImage) {
        super((DefaultUniverse)universe);
        this.viewTransformer = universe.getViewPlatformTransformer();
        this.volumes = volumes;
        this.volumesPanel = volumesPanel;
        this.originalImage = originalImage;
        this.imageHeight = originalImage.getHeight();
        this.imageWidth = originalImage.getWidth();
        this.imageDepth = originalImage.getNSlices();
        this.pickCanvas = new PickCanvas(universe.getCanvas(), (BranchGroup)content);
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setShape((PickShape)this.pickSegment, new Point3d(2.0, 2.0, 2.0));
        this.createBlobLists((AnalyzedGraph)content.getUserData());
    }

    public void doProcess(MouseEvent e) {
        int iD = e.getID();
        if (iD == 500) {
            this.pickCanvas.setShapeLocation(e.getX(), e.getY());
            PickResult pickResult = this.pickCanvas.pickClosest();
            if (pickResult != null) {
                if (this.firstPickPicked) {
                    int commonCount;
                    this.volumesPanel.showStatus("Second Click");
                    this.secondClickSGP = pickResult.getSceneGraphPath();
                    if (this.firstClickSGP.getNode(BRANCH_NODE_INDEX) != this.secondClickSGP.getNode(BRANCH_NODE_INDEX)) {
                        IJ.showMessage((String)NO_PATH_MSG);
                        this.firstPickPicked = false;
                        this.volumesPanel.showStatus("");
                        return;
                    }
                    int lenSGP1 = this.firstClickSGP.nodeCount();
                    int lenSGP2 = this.secondClickSGP.nodeCount();
                    for (commonCount = 0; commonCount < lenSGP1 && commonCount < lenSGP2 && this.firstClickSGP.getNode(commonCount) == this.secondClickSGP.getNode(commonCount); ++commonCount) {
                    }
                    if (commonCount > 0) {
                        Node childNode;
                        int n;
                        Node node;
                        int c;
                        boolean oneBranchOnly = this.firstClickSGP.equals(this.secondClickSGP);
                        if (lenSGP1 > commonCount) {
                            for (c = commonCount; c < lenSGP1; ++c) {
                                node = this.firstClickSGP.getNode(c);
                                if (!(node instanceof Group)) continue;
                                for (n = 0; n < ((Group)node).numChildren(); ++n) {
                                    childNode = ((Group)node).getChild(n);
                                    if (!(childNode instanceof Shape3D)) continue;
                                    this.computeAndDisplayEdgeVolume((Shape3D)childNode);
                                    this.highlightEdge((Shape3D)childNode);
                                }
                            }
                        } else {
                            c = commonCount - 1;
                            node = this.firstClickSGP.getNode(c);
                            if (node instanceof Group) {
                                for (n = 0; n < ((Group)node).numChildren(); ++n) {
                                    childNode = ((Group)node).getChild(n);
                                    if (!(childNode instanceof Shape3D)) continue;
                                    this.computeAndDisplayEdgeVolume((Shape3D)childNode);
                                    this.highlightEdge((Shape3D)childNode);
                                }
                            }
                        }
                        if (!oneBranchOnly) {
                            if (lenSGP2 > commonCount) {
                                for (c = commonCount; c < lenSGP2; ++c) {
                                    node = this.secondClickSGP.getNode(c);
                                    if (!(node instanceof Group)) continue;
                                    for (n = 0; n < ((Group)node).numChildren(); ++n) {
                                        childNode = ((Group)node).getChild(n);
                                        if (!(childNode instanceof Shape3D)) continue;
                                        this.computeAndDisplayEdgeVolume((Shape3D)childNode);
                                        this.highlightEdge((Shape3D)childNode);
                                    }
                                }
                            } else {
                                c = commonCount - 1;
                                node = this.secondClickSGP.getNode(c);
                                if (node instanceof Group) {
                                    for (n = 0; n < ((Group)node).numChildren(); ++n) {
                                        childNode = ((Group)node).getChild(n);
                                        if (!(childNode instanceof Shape3D)) continue;
                                        this.computeAndDisplayEdgeVolume((Shape3D)childNode);
                                        this.highlightEdge((Shape3D)childNode);
                                    }
                                }
                            }
                        }
                    }
                    this.firstPickPicked = false;
                    this.volumesPanel.showStatus("           ");
                } else {
                    this.firstPickPicked = true;
                    this.firstClickSGP = pickResult.getSceneGraphPath();
                    this.volumesPanel.showStatus("First Click");
                }
            } else {
                this.firstPickPicked = false;
            }
        } else if (!this.volumesPanel.getKeyNavigationCheckBoxState()) {
            super.doProcess(e);
        }
    }

    protected void doProcess(KeyEvent ke) {
        if (ke.isAltDown()) {
            int code = ke.getKeyCode();
            switch (code) {
                case 38: {
                    this.viewTransformer.zoomTo(0.9);
                    return;
                }
                case 40: {
                    this.viewTransformer.zoomTo(1.1);
                    return;
                }
            }
        } else {
            super.doProcess(ke);
        }
    }

    void highlightEdge(Shape3D shape) {
        Color3f highlightColor = this.volumes.getSelectedColor();
        if (shape.getGeometry() instanceof LineArray) {
            Appearance appearance = shape.getAppearance();
            ColoringAttributes ca = appearance.getColoringAttributes();
            Color3f before = new Color3f();
            appearance.setColoringAttributes(ca);
            ca.getColor(before);
            ca.setColor(highlightColor);
        }
    }

    private void computeAndDisplayEdgeVolume(Shape3D shape) {
        if (!(shape.getGeometry() instanceof LineArray)) {
            return;
        }
        UserData userData = (UserData)shape.getUserData();
        Object graphData = userData.getGraphInfo();
        if (!(graphData instanceof Edge)) {
            return;
        }
        int voxelCount = this.reconstructEdge((Edge)graphData);
        int oldColorIndex = userData.getColorIndex();
        int currentColorIndex = this.volumes.getCurrentColorIndex();
        this.volumes.updateVoxelCount(oldColorIndex, -voxelCount);
        this.volumes.updateVoxelCount(currentColorIndex, voxelCount);
        this.volumesPanel.updateVoxelCount(oldColorIndex);
        this.volumesPanel.updateVoxelCount(currentColorIndex);
        userData.setColorIndex(currentColorIndex);
    }

    public int computeAllEdgesVolume() {
        int voxelCount = 0;
        int edgeCount = 0;
        for (Edge edge : this.edgeBlobs.keySet()) {
            voxelCount += this.reconstructEdge(edge);
            ++edgeCount;
        }
        return voxelCount;
    }

    private Blob checkForBlob(Point checkPoint, Edge edge, boolean eroded) {
        Iterator<Point3i> iterator;
        Blob newBlob = null;
        Point3i point3i = new Point3i(checkPoint.x, checkPoint.y, checkPoint.z);
        Set<Point3i> neighbors = this.neighbors(point3i, 255);
        if (!neighbors.isEmpty() && (iterator = neighbors.iterator()).hasNext()) {
            Point3i nPoint3i = iterator.next();
            Point nPoint = new Point(nPoint3i.x, nPoint3i.y, nPoint3i.z);
            newBlob = this.getBlobAtPoint(nPoint, eroded);
            if (newBlob == null) {
                return null;
            }
            if (!newBlob.eroded) {
                return null;
            }
            newBlob.edges.add(edge);
            return newBlob;
        }
        return newBlob;
    }

    private void createBlobLists(AnalyzedGraph graph) {
        Blob v1Blob = new Blob();
        Blob v2Blob = new Blob();
        this.nSliceBlobs = new ArrayList<Object>(Collections.nCopies(this.imageDepth, null));
        Graph[] forest = graph.getSkeletonResult().getGraph();
        int treecount = 0;
        for (Graph tree : forest) {
            if (tree.getEdges().size() < 1) continue;
            ++treecount;
            boolean edgecount = false;
            for (Edge edge : tree.getEdges()) {
                if (edge.getType() == -1) continue;
                for (Point v1Point : edge.getV1().getPoints()) {
                    v1Blob = this.getBlobAtPoint(v1Point, false);
                    if (v1Blob == null) continue;
                    v1Blob.edges.add(edge);
                    this.putBlobAtEdge(v1Blob, edge, false);
                }
                for (Point v2Point : edge.getV2().getPoints()) {
                    v2Blob = this.getBlobAtPoint(v2Point, false);
                    if (v2Blob == null) continue;
                    v2Blob.edges.add(edge);
                    this.putBlobAtEdge(v2Blob, edge, false);
                }
                for (Point slabPoint : edge.getSlabs()) {
                    Blob slabBlob = this.getBlobAtPoint(slabPoint, false);
                    if (slabBlob == null) continue;
                    slabBlob.edges.add(edge);
                    this.putBlobAtEdge(slabBlob, edge, false);
                }
            }
        }
    }

    void recoverErodedBlobs(Edge edge) {
        LinkedList<Blob> newBlobList = new LinkedList<Blob>();
        List blobList = this.edgeBlobs.get(edge);
        if (null == blobList) {
            return;
        }
        do {
            newBlobList.clear();
            ListIterator listIter = blobList.listIterator();
            while (listIter.hasNext()) {
                Blob vBlob = (Blob)listIter.next();
                for (Point3i point3i : vBlob.points) {
                    Blob checkBlob;
                    Point checkPoint = new Point(point3i.x, point3i.y, point3i.z);
                    do {
                        ++checkPoint.z;
                        checkBlob = this.checkForBlob(checkPoint, edge, true);
                        if (checkBlob == null || !checkBlob.eroded) continue;
                        checkBlob.eroded = false;
                        checkBlob.edges.add(edge);
                        this.putBlobAtEdge(checkBlob, edge, false);
                        newBlobList.add(checkBlob);
                    } while (checkBlob != null);
                    checkPoint = new Point(point3i.x, point3i.y, point3i.z);
                    do {
                        --checkPoint.z;
                        checkBlob = this.checkForBlob(checkPoint, edge, true);
                        if (checkBlob == null || !checkBlob.eroded) continue;
                        checkBlob.eroded = false;
                        checkBlob.edges.add(edge);
                        this.putBlobAtEdge(checkBlob, edge, false);
                        newBlobList.add(checkBlob);
                    } while (checkBlob != null);
                }
            }
        } while (!newBlobList.isEmpty());
    }

    Blob getBlobAtPoint(Point point, boolean eroded) {
        Point3i point3i = new Point3i(point.x, point.y, point.z);
        List<Blob> blobList = this.nSliceBlobs.get(point.z);
        if (blobList == null) {
            blobList = new CopyOnWriteArrayList<Blob>();
            this.nSliceBlobs.set(point.z, blobList);
        }
        for (Blob blob : blobList) {
            if (!blob.points.contains(point3i)) continue;
            return blob;
        }
        Set<Point3i> points = this.slabNeighbors(point3i);
        if (points.isEmpty()) {
            return null;
        }
        Blob newBlob = new Blob(points);
        newBlob.eroded = eroded;
        blobList.add(newBlob);
        return newBlob;
    }

    void putBlobAtEdge(Blob blob, Edge edge, boolean eroded) {
        CopyOnWriteArrayList<Blob> blobList = this.edgeBlobs.get(edge);
        if (blobList == null) {
            blobList = new CopyOnWriteArrayList();
            this.edgeBlobs.put(edge, blobList);
        }
        for (Blob blob2 : blobList) {
            if (!blob2.points.equals(blob.points) || blob2.eroded != eroded) continue;
            blob2.edges.add(edge);
            return;
        }
        blob.edges.add(edge);
        blobList.add(blob);
    }

    private int reconstructEdge(Edge edge) {
        int voxelCount = 0;
        double voxelCountD = 0.0;
        this.recoverErodedBlobs(edge);
        for (Object branch : edge.getV1().getBranches()) {
            this.recoverErodedBlobs((Edge)branch);
        }
        for (Object branch : edge.getV2().getBranches()) {
            this.recoverErodedBlobs((Edge)branch);
        }
        List blobList = this.edgeBlobs.get(edge);
        if (blobList == null) {
            return voxelCount;
        }
        for (Blob blob : blobList) {
            double size = blob.points.size();
            voxelCountD += size / (double)blob.edges.size();
            voxelCount += blob.points.size() / blob.edges.size();
        }
        boolean v = false;
        this.grandVoxelCount += voxelCount;
        this.grandVoxelCountD += voxelCountD;
        return voxelCount;
    }

    private Set<Point3i> neighbors(Point3i homePoint, int targetPixel) {
        HashSet<Point3i> neighborPointSet = new HashSet<Point3i>();
        if (homePoint.z >= this.originalImage.getStackSize() || homePoint.z < 0) {
            return neighborPointSet;
        }
        ImageProcessor sliceProcessor = this.originalImage.getStack().getProcessor(homePoint.z + 1);
        if (sliceProcessor.getPixel(homePoint.x, homePoint.y) == targetPixel) {
            neighborPointSet.add(homePoint);
        }
        int x = homePoint.x;
        int y = homePoint.y;
        if (y - 1 >= 0) {
            if (x + 1 < this.imageWidth && sliceProcessor.getPixel(x + 1, y - 1) == targetPixel) {
                neighborPointSet.add(new Point3i(x + 1, y - 1, homePoint.z));
            }
            if (x - 1 >= 0 && sliceProcessor.getPixel(x - 1, y - 1) == targetPixel) {
                neighborPointSet.add(new Point3i(x - 1, y - 1, homePoint.z));
            }
            if (sliceProcessor.getPixel(x, y - 1) == targetPixel) {
                neighborPointSet.add(new Point3i(x, y - 1, homePoint.z));
            }
        }
        if (x > 0 && sliceProcessor.getPixel(x - 1, y) == targetPixel) {
            neighborPointSet.add(new Point3i(x - 1, y, homePoint.z));
        }
        if (x + 1 < this.imageWidth && sliceProcessor.getPixel(x + 1, y) == targetPixel) {
            neighborPointSet.add(new Point3i(x + 1, y, homePoint.z));
        }
        if (y + 1 < this.imageHeight) {
            if (x + 1 < this.imageWidth && sliceProcessor.getPixel(x + 1, y + 1) == targetPixel) {
                neighborPointSet.add(new Point3i(x + 1, y + 1, homePoint.z));
            }
            if (x - 1 >= 0 && sliceProcessor.getPixel(x - 1, y + 1) == targetPixel) {
                neighborPointSet.add(new Point3i(x - 1, y + 1, homePoint.z));
            }
            if (sliceProcessor.getPixel(x, y + 1) == targetPixel) {
                neighborPointSet.add(new Point3i(x, y + 1, homePoint.z));
            }
        }
        return neighborPointSet;
    }

    Set<Point3i> slabNeighbors(Point3i startPoint) {
        HashSet<Point3i> slabPoints = new HashSet<Point3i>();
        LinkedList<Point3i> pointQueue = new LinkedList<Point3i>();
        Point3i checkPoint = new Point3i(startPoint.x, startPoint.y, startPoint.z);
        while (null != checkPoint) {
            Set<Point3i> slabNeighbors = this.neighbors(checkPoint, 255);
            for (Point3i slabPoint : slabNeighbors) {
                if (!slabPoints.add(slabPoint)) continue;
                pointQueue.add(slabPoint);
            }
            checkPoint = (Point3i)pointQueue.poll();
        }
        return slabPoints;
    }

    private class Blob {
        Set<Point3i> points = new HashSet<Point3i>();
        Set<Edge> edges = new HashSet<Edge>();
        boolean eroded = false;

        Blob() {
            this.points = new HashSet<Point3i>();
            this.edges = new HashSet<Edge>();
        }

        Blob(Set<Point3i> points) {
            this.points = points;
            this.edges = new HashSet<Edge>();
        }

        int getDivisor() {
            return this.edges.size();
        }

        public String toString() {
            return "(" + this.points.size() + " / " + this.edges.size() + "/" + this.eroded + ")";
        }
    }
}

