/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5BooleanWriter;
import ch.systemsx.cisd.hdf5.HDF5ByteWriter;
import ch.systemsx.cisd.hdf5.HDF5CompoundWriter;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DateTimeWriter;
import ch.systemsx.cisd.hdf5.HDF5DoubleWriter;
import ch.systemsx.cisd.hdf5.HDF5EnumWriter;
import ch.systemsx.cisd.hdf5.HDF5FileLevelReadWriteHandler;
import ch.systemsx.cisd.hdf5.HDF5FloatWriter;
import ch.systemsx.cisd.hdf5.HDF5IntWriter;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5LongWriter;
import ch.systemsx.cisd.hdf5.HDF5ObjectReadWriteInfoProviderHandler;
import ch.systemsx.cisd.hdf5.HDF5OpaqueWriter;
import ch.systemsx.cisd.hdf5.HDF5Reader;
import ch.systemsx.cisd.hdf5.HDF5ReferenceWriter;
import ch.systemsx.cisd.hdf5.HDF5ShortWriter;
import ch.systemsx.cisd.hdf5.HDF5StringWriter;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationWriter;
import ch.systemsx.cisd.hdf5.HDF5UnsignedByteWriter;
import ch.systemsx.cisd.hdf5.HDF5UnsignedIntWriter;
import ch.systemsx.cisd.hdf5.HDF5UnsignedLongWriter;
import ch.systemsx.cisd.hdf5.HDF5UnsignedShortWriter;
import ch.systemsx.cisd.hdf5.IHDF5BooleanWriter;
import ch.systemsx.cisd.hdf5.IHDF5ByteWriter;
import ch.systemsx.cisd.hdf5.IHDF5CompoundWriter;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeWriter;
import ch.systemsx.cisd.hdf5.IHDF5DoubleWriter;
import ch.systemsx.cisd.hdf5.IHDF5EnumWriter;
import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadWriteHandler;
import ch.systemsx.cisd.hdf5.IHDF5FloatWriter;
import ch.systemsx.cisd.hdf5.IHDF5IntWriter;
import ch.systemsx.cisd.hdf5.IHDF5LongWriter;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadWriteInfoProviderHandler;
import ch.systemsx.cisd.hdf5.IHDF5OpaqueWriter;
import ch.systemsx.cisd.hdf5.IHDF5ReferenceWriter;
import ch.systemsx.cisd.hdf5.IHDF5ShortWriter;
import ch.systemsx.cisd.hdf5.IHDF5StringWriter;
import ch.systemsx.cisd.hdf5.IHDF5TimeDurationWriter;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.BitSet;
import java.util.Date;
import java.util.List;

final class HDF5Writer
extends HDF5Reader
implements IHDF5Writer {
    private final HDF5BaseWriter baseWriter;
    private final IHDF5FileLevelReadWriteHandler fileHandler;
    private final IHDF5ObjectReadWriteInfoProviderHandler objectHandler;
    private final IHDF5ByteWriter byteWriter;
    private final IHDF5ByteWriter ubyteWriter;
    private final IHDF5ShortWriter shortWriter;
    private final IHDF5ShortWriter ushortWriter;
    private final IHDF5IntWriter intWriter;
    private final IHDF5IntWriter uintWriter;
    private final IHDF5LongWriter longWriter;
    private final IHDF5LongWriter ulongWriter;
    private final IHDF5FloatWriter floatWriter;
    private final IHDF5DoubleWriter doubleWriter;
    private final IHDF5BooleanWriter booleanWriter;
    private final IHDF5StringWriter stringWriter;
    private final IHDF5EnumWriter enumWriter;
    private final IHDF5CompoundWriter compoundWriter;
    private final IHDF5DateTimeWriter dateTimeWriter;
    private final HDF5TimeDurationWriter timeDurationWriter;
    private final IHDF5ReferenceWriter referenceWriter;
    private final IHDF5OpaqueWriter opaqueWriter;

    HDF5Writer(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        this.baseWriter = baseWriter;
        baseWriter.setMyReader(this);
        this.fileHandler = new HDF5FileLevelReadWriteHandler(baseWriter);
        this.objectHandler = new HDF5ObjectReadWriteInfoProviderHandler(baseWriter);
        this.byteWriter = new HDF5ByteWriter(baseWriter);
        this.ubyteWriter = new HDF5UnsignedByteWriter(baseWriter);
        this.shortWriter = new HDF5ShortWriter(baseWriter);
        this.ushortWriter = new HDF5UnsignedShortWriter(baseWriter);
        this.intWriter = new HDF5IntWriter(baseWriter);
        this.uintWriter = new HDF5UnsignedIntWriter(baseWriter);
        this.longWriter = new HDF5LongWriter(baseWriter);
        this.ulongWriter = new HDF5UnsignedLongWriter(baseWriter);
        this.floatWriter = new HDF5FloatWriter(baseWriter);
        this.doubleWriter = new HDF5DoubleWriter(baseWriter);
        this.booleanWriter = new HDF5BooleanWriter(baseWriter);
        this.stringWriter = new HDF5StringWriter(baseWriter);
        this.enumWriter = new HDF5EnumWriter(baseWriter);
        this.compoundWriter = new HDF5CompoundWriter(baseWriter, this.enumWriter);
        this.dateTimeWriter = new HDF5DateTimeWriter(baseWriter, (HDF5LongReader)this.longReader);
        this.timeDurationWriter = new HDF5TimeDurationWriter(baseWriter, (HDF5LongReader)this.longReader);
        this.referenceWriter = new HDF5ReferenceWriter(baseWriter);
        this.opaqueWriter = new HDF5OpaqueWriter(baseWriter);
    }

    HDF5BaseWriter getBaseWriter() {
        return this.baseWriter;
    }

    @Override
    public IHDF5FileLevelReadWriteHandler file() {
        return this.fileHandler;
    }

    @Override
    public IHDF5ObjectReadWriteInfoProviderHandler object() {
        return this.objectHandler;
    }

    @Override
    public boolean exists(String objectPath) {
        return this.objectHandler.exists(objectPath);
    }

    @Override
    public boolean isGroup(String objectPath) {
        return this.objectHandler.isGroup(objectPath);
    }

    @Override
    public void delete(String objectPath) {
        this.objectHandler.delete(objectPath);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath) {
        return this.objectHandler.getDataSetInformation(dataSetPath);
    }

    @Override
    public List<String> getGroupMembers(String groupPath) {
        return this.objectHandler.getGroupMembers(groupPath);
    }

    @Override
    public IHDF5BooleanWriter bool() {
        return this.booleanWriter;
    }

    @Override
    public void writeBitField(String objectPath, BitSet data) {
        this.booleanWriter.writeBitField(objectPath, data);
    }

    @Override
    public void writeBoolean(String objectPath, boolean value) {
        this.booleanWriter.write(objectPath, value);
    }

    @Override
    public IHDF5OpaqueWriter opaque() {
        return this.opaqueWriter;
    }

    @Override
    public IHDF5DateTimeWriter time() {
        return this.dateTimeWriter;
    }

    @Override
    public IHDF5TimeDurationWriter duration() {
        return this.timeDurationWriter;
    }

    @Override
    public void writeDate(String objectPath, Date date) {
        this.dateTimeWriter.write(objectPath, date);
    }

    @Override
    public void writeDateArray(String objectPath, Date[] dates) {
        this.dateTimeWriter.writeArray(objectPath, dates);
    }

    @Override
    public void writeTimeDuration(String objectPath, HDF5TimeDuration timeDuration) {
        this.timeDurationWriter.write(objectPath, timeDuration);
    }

    @Override
    public void writeTimeDurationArray(String objectPath, HDF5TimeDurationArray timeDurations) {
        this.timeDurationWriter.writeArray(objectPath, timeDurations);
    }

    @Override
    public IHDF5ReferenceWriter reference() {
        return this.referenceWriter;
    }

    @Override
    public IHDF5StringWriter string() {
        return this.stringWriter;
    }

    @Override
    public void writeString(String objectPath, String data) {
        this.stringWriter.write(objectPath, data);
    }

    @Override
    public void writeStringArray(String objectPath, String[] data) {
        this.stringWriter.writeArray(objectPath, data);
    }

    @Override
    public IHDF5EnumWriter enumeration() {
        return this.enumWriter;
    }

    @Override
    public <T extends Enum<T>> void writeEnum(String objectPath, Enum<T> value) throws HDF5JavaException {
        this.enumWriter.write(objectPath, value);
    }

    @Override
    public <T extends Enum<T>> void writeEnumArray(String objectPath, Enum<T>[] data) {
        this.enumWriter.writeArray(objectPath, this.enumWriter.newAnonArray(data));
    }

    @Override
    public void writeEnumArray(String objectPath, String[] options, String[] data) {
        this.enumWriter.writeArray(objectPath, this.enumWriter.newAnonArray(options, data));
    }

    @Override
    public IHDF5CompoundWriter compound() {
        return this.compoundWriter;
    }

    @Override
    public <T> void writeCompound(String objectPath, T data) {
        this.compoundWriter.write(objectPath, data);
    }

    @Override
    public <T> void writeCompoundArray(String objectPath, T[] data) {
        this.compoundWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeByteArray(String objectPath, byte[] data) {
        this.byteWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeDouble(String objectPath, double value) {
        this.doubleWriter.write(objectPath, value);
    }

    @Override
    public void writeDoubleArray(String objectPath, double[] data) {
        this.doubleWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeDoubleMatrix(String objectPath, double[][] data) {
        this.doubleWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeFloat(String objectPath, float value) {
        this.floatWriter.write(objectPath, value);
    }

    @Override
    public void writeFloatArray(String objectPath, float[] data) {
        this.floatWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeFloatMatrix(String objectPath, float[][] data) {
        this.floatWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeInt(String objectPath, int value) {
        this.intWriter.write(objectPath, value);
    }

    @Override
    public void writeIntArray(String objectPath, int[] data) {
        this.intWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeIntMatrix(String objectPath, int[][] data) {
        this.intWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeLong(String objectPath, long value) {
        this.longWriter.write(objectPath, value);
    }

    @Override
    public void writeLongArray(String objectPath, long[] data) {
        this.longWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeLongMatrix(String objectPath, long[][] data) {
        this.longWriter.writeMatrix(objectPath, data);
    }

    @Override
    public IHDF5ByteWriter int8() {
        return this.byteWriter;
    }

    @Override
    public IHDF5ByteWriter uint8() {
        return this.ubyteWriter;
    }

    @Override
    public IHDF5ShortWriter int16() {
        return this.shortWriter;
    }

    @Override
    public IHDF5ShortWriter uint16() {
        return this.ushortWriter;
    }

    @Override
    public IHDF5IntWriter int32() {
        return this.intWriter;
    }

    @Override
    public IHDF5IntWriter uint32() {
        return this.uintWriter;
    }

    @Override
    public IHDF5LongWriter int64() {
        return this.longWriter;
    }

    @Override
    public IHDF5LongWriter uint64() {
        return this.ulongWriter;
    }

    @Override
    public IHDF5FloatWriter float32() {
        return this.floatWriter;
    }

    @Override
    public IHDF5DoubleWriter float64() {
        return this.doubleWriter;
    }
}

