/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.overlay.Overlay;
import net.imagej.plugins.commands.assign.InplaceUnaryTransform;
import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.ops.operation.real.unary.RealAddNoise;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;

public class NoiseAdder<T extends RealType<T>> {
    private final Dataset dataset;
    private final Overlay overlay;
    private final Position planePos;
    private double rangeStdDev;
    private double rangeMin;
    private double rangeMax;

    public NoiseAdder(Dataset dataset, Overlay overlay, Position pos) {
        this.dataset = dataset;
        this.overlay = overlay;
        this.planePos = pos;
    }

    protected void setStdDev(double stdDev) {
        this.rangeStdDev = stdDev;
    }

    public void run() {
        this.calcTypeMinAndMax();
        RealAddNoise op = new RealAddNoise(this.rangeMin, this.rangeMax, this.rangeStdDev);
        InplaceUnaryTransform transform = this.planePos == null ? new InplaceUnaryTransform((ComplexUnaryOperation<DoubleType, DoubleType>)op, new DoubleType(), this.dataset, this.overlay) : new InplaceUnaryTransform((ComplexUnaryOperation<DoubleType, DoubleType>)op, new DoubleType(), this.dataset, this.overlay, this.planePos);
        transform.run();
    }

    private void calcTypeMinAndMax() {
        this.rangeMin = this.dataset.getType().getMinValue();
        this.rangeMax = this.dataset.getType().getMaxValue();
    }
}

