/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.overlay;

import java.util.List;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayInfoList;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.ThresholdOverlay;
import net.imagej.threshold.ThresholdService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Overlay", mnemonic=111), @Menu(label="From Overlay Manager", weight=1.0, mnemonic=102)}, headless=true, attrs={@Attr(name="no-legacy")})
public class FromOverlayManager
extends ContextCommand {
    @Parameter(required=true)
    private ImageDisplay display;
    @Parameter
    private OverlayService ovrSrv;
    @Parameter
    private ThresholdService threshSrv;

    public void run() {
        OverlayInfoList overlayList = this.ovrSrv.getOverlayInfo();
        List selectedRoiMgrOverlays = overlayList.selectedOverlays();
        List currOverlays = this.ovrSrv.getOverlays(this.display);
        boolean changes = false;
        for (Overlay overlay : selectedRoiMgrOverlays) {
            if (currOverlays.contains(overlay)) continue;
            Overlay ov = overlay;
            boolean hadThresh = false;
            if (overlay instanceof ThresholdOverlay) {
                hadThresh = this.threshSrv.hasThreshold(this.display);
                ThresholdOverlay mgrThresh = (ThresholdOverlay)overlay;
                ThresholdOverlay dispThresh = this.threshSrv.getThreshold(this.display);
                dispThresh.setRange(mgrThresh.getRangeMin(), mgrThresh.getRangeMax());
                ov = dispThresh;
            }
            changes = true;
            if (hadThresh) continue;
            this.display.display((Object)ov);
        }
        if (changes) {
            this.display.update();
        }
    }

    public ImageDisplay getImageDisplay() {
        return this.display;
    }

    public void setImageDisplay(ImageDisplay disp) {
        this.display = disp;
    }
}

