/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import fiji.util.ArrowShape;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ArrowOptionPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    private EventListenerList listenerList = new EventListenerList();
    private boolean firingActionEvent = false;
    private JPanel jPanelMain;
    private JLabel jLabelArrowThickness;
    private JSlider jSliderArrowThickness;
    private Canvas canvasDrawingArea;
    private JPanel jPanelDrawArea;
    private JCheckBox jCheckBoxFillArrow;
    private JTextField jTextFieldArrowThickness;
    private JLabel jLabelArrowLength;
    private JTextField jTextFieldHeadLength;
    private JSlider jSliderHeadLength;
    private JComboBox jComboBoxHeadStyle;
    private JLabel jLabelHeadStyle;
    private static BasicStroke stroke;
    private static ArrowShape arrow;

    public ArrowOptionPanel(ArrowShape _arrow, BasicStroke _stroke) {
        this.initGUI();
        stroke = _stroke;
        arrow = _arrow;
        this.jComboBoxHeadStyle.setSelectedItem((Object)arrow.getStyle());
        this.jTextFieldArrowThickness.setText(String.format("%.0f", Float.valueOf(stroke.getLineWidth())));
        this.jSliderArrowThickness.setValue((int)stroke.getLineWidth());
        this.jTextFieldHeadLength.setText(String.format("%.0f", arrow.getLength()));
        this.jSliderHeadLength.setValue((int)arrow.getLength());
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrowOptionPanel.this.canvasDrawingArea.paint(ArrowOptionPanel.this.canvasDrawingArea.getGraphics());
            }
        };
        this.jComboBoxHeadStyle.addActionListener(al);
        this.jTextFieldArrowThickness.addActionListener(new TextFieldActionListener(this.jSliderArrowThickness));
        this.jTextFieldHeadLength.addActionListener(new TextFieldActionListener(this.jSliderHeadLength));
        this.jSliderArrowThickness.addChangeListener(new SliderChangeListener(this.jTextFieldArrowThickness));
        this.jSliderArrowThickness.addMouseWheelListener(new SliderMouseWheelListener(this.jSliderArrowThickness));
        this.jSliderHeadLength.addChangeListener(new SliderChangeListener(this.jTextFieldHeadLength));
        this.jSliderHeadLength.addMouseWheelListener(new SliderMouseWheelListener(this.jSliderHeadLength));
        this.jCheckBoxFillArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrowOptionPanel.this.canvasDrawingArea.paint(ArrowOptionPanel.this.canvasDrawingArea.getGraphics());
            }
        });
    }

    public ArrowOptionPanel() {
        this.initGUI();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrowOptionPanel.this.canvasDrawingArea.paint(ArrowOptionPanel.this.canvasDrawingArea.getGraphics());
            }
        };
        this.jComboBoxHeadStyle.addActionListener(al);
        this.jTextFieldArrowThickness.addActionListener(new TextFieldActionListener(this.jSliderArrowThickness));
        this.jTextFieldHeadLength.addActionListener(new TextFieldActionListener(this.jSliderHeadLength));
        this.jSliderArrowThickness.addChangeListener(new SliderChangeListener(this.jTextFieldArrowThickness));
        this.jSliderArrowThickness.addMouseWheelListener(new SliderMouseWheelListener(this.jSliderArrowThickness));
        this.jSliderHeadLength.addChangeListener(new SliderChangeListener(this.jTextFieldHeadLength));
        this.jSliderHeadLength.addMouseWheelListener(new SliderMouseWheelListener(this.jSliderHeadLength));
        this.jCheckBoxFillArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrowOptionPanel.this.canvasDrawingArea.paint(ArrowOptionPanel.this.canvasDrawingArea.getGraphics());
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrowOptionPanel inst = new ArrowOptionPanel();
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public BasicStroke getStroke() {
        return stroke;
    }

    public double getLength() {
        return arrow.getLength();
    }

    public ArrowShape.ArrowStyle getStyle() {
        return arrow.getStyle();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Arrow options");
            this.setResizable(false);
            this.jPanelMain = new JPanel();
            this.getContentPane().add((Component)this.jPanelMain, "Center");
            this.jPanelMain.setLayout(null);
            this.jPanelMain.setFont(new Font("Dialog", 0, 10));
            this.jPanelMain.setPreferredSize(new Dimension(353, 165));
            this.jLabelHeadStyle = new JLabel();
            this.jPanelMain.add(this.jLabelHeadStyle);
            this.jLabelHeadStyle.setText("Arrow head style");
            this.jLabelHeadStyle.setBounds(10, 15, 95, 15);
            this.jLabelHeadStyle.setFont(new Font("Arial", 0, 10));
            DefaultComboBoxModel<ArrowShape.ArrowStyle> jComboBoxHeadStyleModel = new DefaultComboBoxModel<ArrowShape.ArrowStyle>(ArrowShape.ArrowStyle.values());
            this.jComboBoxHeadStyle = new JComboBox();
            this.jPanelMain.add(this.jComboBoxHeadStyle);
            this.jComboBoxHeadStyle.setModel(jComboBoxHeadStyleModel);
            this.jComboBoxHeadStyle.setBounds(112, 11, 146, 24);
            this.jComboBoxHeadStyle.setFont(new Font("Arial", 0, 10));
            this.jSliderHeadLength = new JSlider();
            this.jPanelMain.add(this.jSliderHeadLength);
            this.jSliderHeadLength.setBounds(107, 40, 115, 19);
            this.jSliderHeadLength.setFont(new Font("Arial", 0, 10));
            this.jSliderHeadLength.setMinorTickSpacing(1);
            this.jSliderHeadLength.setMinimum(0);
            this.jSliderHeadLength.setMaximum(100);
            this.jSliderHeadLength.setValue(10);
            this.jTextFieldHeadLength = new JTextField();
            this.jPanelMain.add(this.jTextFieldHeadLength);
            this.jTextFieldHeadLength.setText("10");
            this.jTextFieldHeadLength.setBounds(225, 40, 30, 20);
            this.jTextFieldHeadLength.setFont(new Font("Arial", 0, 10));
            this.jTextFieldHeadLength.setBackground(new Color(238, 238, 238));
            this.jLabelArrowLength = new JLabel();
            this.jPanelMain.add(this.jLabelArrowLength);
            this.jLabelArrowLength.setText("Arrow head length");
            this.jLabelArrowLength.setBounds(10, 40, 94, 16);
            this.jLabelArrowLength.setFont(new Font("Arial", 0, 10));
            this.jLabelArrowThickness = new JLabel();
            this.jPanelMain.add(this.jLabelArrowThickness);
            this.jLabelArrowThickness.setText("Arrow thickness");
            this.jLabelArrowThickness.setBounds(10, 65, 102, 16);
            this.jLabelArrowThickness.setFont(new Font("Arial", 0, 10));
            this.jTextFieldArrowThickness = new JTextField();
            this.jPanelMain.add(this.jTextFieldArrowThickness);
            this.jTextFieldArrowThickness.setText("1");
            this.jTextFieldArrowThickness.setBounds(225, 60, 30, 20);
            this.jTextFieldArrowThickness.setFont(new Font("Arial", 0, 10));
            this.jTextFieldArrowThickness.setBackground(new Color(238, 238, 238));
            this.jSliderArrowThickness = new JSlider();
            this.jPanelMain.add(this.jSliderArrowThickness);
            this.jSliderArrowThickness.setBounds(110, 66, 115, 20);
            this.jSliderArrowThickness.setMinimum(1);
            this.jSliderArrowThickness.setMaximum(20);
            this.jSliderArrowThickness.setMinorTickSpacing(1);
            this.jSliderArrowThickness.setValue(1);
            this.jCheckBoxFillArrow = new JCheckBox();
            this.jPanelMain.add(this.jCheckBoxFillArrow);
            this.jCheckBoxFillArrow.setText("Fill");
            this.jCheckBoxFillArrow.setBounds(3, 85, 51, 23);
            this.jCheckBoxFillArrow.setFont(new Font("Arial", 0, 10));
            this.jPanelDrawArea = new JPanel();
            BorderLayout jPanelDrawAreaLayout = new BorderLayout();
            this.jPanelDrawArea.setLayout(jPanelDrawAreaLayout);
            this.jPanelMain.add(this.jPanelDrawArea);
            this.jPanelDrawArea.setBounds(22, 108, 233, 45);
            this.jPanelDrawArea.setBorder(BorderFactory.createBevelBorder(1));
            this.canvasDrawingArea = new ArrowExampleCanvas();
            this.jPanelDrawArea.add((Component)this.canvasDrawingArea, "Center");
            this.canvasDrawingArea.setPreferredSize(new Dimension(231, 24));
            this.pack();
            this.setSize(280, 180);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            long mostRecentEventTime = EventQueue.getMostRecentEventTime();
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiers();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                if (e == null) {
                    e = new ActionEvent(this, 1001, "arrowPropertyChanged", mostRecentEventTime, modifiers);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            this.firingActionEvent = false;
        }
    }

    private class SliderMouseWheelListener
    implements MouseWheelListener {
        private JSlider slider;

        public SliderMouseWheelListener(JSlider _slider) {
            this.slider = _slider;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int steps = e.getWheelRotation();
            this.slider.setValue(this.slider.getValue() + steps);
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private JSlider slider;

        public TextFieldActionListener(JSlider _slider) {
            this.slider = _slider;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField text_field = (JTextField)e.getSource();
            try {
                double val = Double.parseDouble(text_field.getText());
                this.slider.setValue((int)val);
            }
            catch (NumberFormatException nfe) {
                text_field.setText(String.format("%d", this.slider.getValue()));
            }
            ArrowOptionPanel.this.canvasDrawingArea.paint(ArrowOptionPanel.this.canvasDrawingArea.getGraphics());
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private JTextField text_field;

        public SliderChangeListener(JTextField _text_field) {
            this.text_field = _text_field;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider slider = (JSlider)e.getSource();
            this.text_field.setText(String.format("%d", slider.getValue()));
            ArrowOptionPanel.this.canvasDrawingArea.paint(ArrowOptionPanel.this.canvasDrawingArea.getGraphics());
        }
    }

    private class ArrowExampleCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        Point2D start;
        Point2D end;

        private ArrowExampleCanvas() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.start = new Point2D.Double((double)ArrowOptionPanel.this.jPanelDrawArea.getWidth() * 0.25, (double)ArrowOptionPanel.this.jPanelDrawArea.getHeight() / 2.0);
            this.end = new Point2D.Double((double)ArrowOptionPanel.this.jPanelDrawArea.getWidth() * 0.75, (double)ArrowOptionPanel.this.jPanelDrawArea.getHeight() / 2.0);
            arrow = new ArrowShape((ArrowShape.ArrowStyle)((Object)ArrowOptionPanel.this.jComboBoxHeadStyle.getSelectedItem()));
            arrow.setStartPoint(this.start);
            arrow.setEndPoint(this.end);
            try {
                double length = Double.parseDouble(ArrowOptionPanel.this.jTextFieldHeadLength.getText());
                float width = Float.parseFloat(ArrowOptionPanel.this.jTextFieldArrowThickness.getText());
                arrow.setLength(length);
                stroke = new BasicStroke(width, 0, 0);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Shape shape = stroke.createStrokedShape(arrow);
                Area area = new Area(shape);
                area.add(new Area(arrow));
                g2.draw(area);
                if (ArrowOptionPanel.this.jCheckBoxFillArrow.isSelected()) {
                    g2.fill(area);
                }
                ArrowOptionPanel.this.fireActionEvent();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

