/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJError;
import FlowJ.FlowJFlow;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import java.awt.Label;
import java.awt.event.MouseEvent;

class FlowJCanvas
extends ImageCanvas {
    private Object display;
    private Label alphaField;
    private Label rLabel;
    private Label sLabel;
    private Label posLabel;

    public FlowJCanvas(ImagePlus imp) {
        super(imp);
    }

    public void setDisplayed(Object display) {
        this.display = display;
    }

    public void setFields(Label alphaField, Label rLabel, Label sLabel, Label posLabel) {
        this.alphaField = alphaField;
        this.rLabel = rLabel;
        this.sLabel = sLabel;
        this.posLabel = posLabel;
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.display instanceof FlowJError) {
            FlowJError fe = (FlowJError)this.display;
            this.alphaField.setText("exp: " + IJ.d2s((double)fe.xExpected(x, y), (int)1) + ", " + IJ.d2s((double)fe.yExpected(x, y), (int)1));
            this.rLabel.setText("act: " + IJ.d2s((double)fe.flow.getX(x, y), (int)1) + ", " + IJ.d2s((double)fe.flow.getY(x, y), (int)1));
            this.posLabel.setText(x + ", " + y + ": psi = " + fe.psi(x, y) + "\u00ba");
        } else if (this.display instanceof FlowJFlow) {
            FlowJFlow flow = (FlowJFlow)this.display;
            if (flow.full(x, y)) {
                this.alphaField.setText("" + IJ.d2s((double)flow.getAlphaDeg(x, y), (int)2) + "\u00ba");
                this.rLabel.setText("" + IJ.d2s((double)flow.getMagnitude(x, y), (int)2) + "pxs/frame");
                this.sLabel.setText("(" + flow.calibratedMagnitudeString(flow.getMagnitude(x, y), 2) + ")");
                this.posLabel.setText(x + ", " + y);
            } else {
                this.alphaField.setText("");
                this.rLabel.setText("no flow");
                this.posLabel.setText(x + ", " + y);
            }
        } else if (this.alphaField instanceof Label) {
            this.posLabel.setText("pos:");
            this.alphaField.setText("orientation:");
            this.rLabel.setText("magnitude:");
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.display instanceof FlowJFlow && this.imp.getRoi() instanceof Roi) {
            FlowJFlow flow = (FlowJFlow)this.display;
            int s = flow.average(this.imp.getRoi());
            this.alphaField.setText("avg orientation: " + IJ.d2s((double)flow.averageAlpha(), (int)2) + "\u00ba");
            this.rLabel.setText("avg speed: " + IJ.d2s((double)flow.averageMagnitude(), (int)2) + "pxs/frame");
            this.sLabel.setText("(" + flow.calibratedMagnitudeString(flow.averageMagnitude(), 2) + ")");
            this.posLabel.setText("surface: " + s + "pxs");
        } else if (this.display instanceof FlowJError && this.imp.getRoi() instanceof Roi) {
            FlowJError fe = (FlowJError)this.display;
            this.alphaField.setText("avg psi: " + IJ.d2s((double)((FlowJError)this.display).average(this.imp.getRoi()), (int)2) + "\u00ba");
            this.rLabel.setText("");
            this.posLabel.setText("");
        }
    }
}

