/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJMapper;
import FlowJ.FlowJSpotNoise;
import bijnum.BIJmatrix;
import ij.process.ImageProcessor;

public class FlowJSpotNoiseMapper
extends FlowJMapper {
    public static final double chance = (double)0.9f;
    public static final double minMagnitude = (double)0.05f;
    private FlowJSpotNoise spotnoise;

    public FlowJSpotNoiseMapper(ImageProcessor impr, float[][][] flow, int axes, int maxp, int maxq, double pScaling, double qScaling, double rho) {
        super(impr, flow, axes, maxp, maxq, pScaling, qScaling, rho);
        this.spotnoise = new FlowJSpotNoise((byte[])impr.getPixels(), maxp, maxq, (double)0.4f);
    }

    @Override
    public void pixel(int ip, int iq, int ix, int iy, double dx, double dy) {
        double r = Math.random();
        if (r > (double)0.9f) {
            float[] v = this.pScaling == 1.0 && this.qScaling == 1.0 ? new float[]{this.flow[iy][ix][0], this.flow[iy][ix][1]} : FlowJSpotNoiseMapper.bl(this.flow, ix, iy, dx, dy);
            double mag = BIJmatrix.norm(v);
            double rnd = Math.random();
            int grnd = (int)(255.0 * rnd);
            if (mag / this.rho > (double)0.05f) {
                this.spotnoise.spot(ip, iq, (double)0.4f + 2.0 * mag / this.rho, grnd, v);
            }
        }
    }
}

