/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJBinaryShell;
import VolumeJ.VJCell;
import VolumeJ.VJClassifier;
import VolumeJ.VJGradient;
import VolumeJ.VJInterpolator;
import VolumeJ.VJMatrix;
import VolumeJ.VJRenderer;
import VolumeJ.VJShade;
import VolumeJ.VJShader;
import VolumeJ.VJThresholdedVolume;
import VolumeJ.VJUserInterface;
import VolumeJ.VJValue;
import VolumeJ.VJValueHSB;
import VolumeJ.VJVoxelLoc;
import java.awt.Color;
import volume.Volume;
import volume.VolumeRGB;

public class VJIsosurfaceRender
extends VJRenderer {
    private static final float EPSILON = 1.0E-4f;
    private VJBinaryShell shell;

    public VJIsosurfaceRender(VJInterpolator interpolator, VJShader shader, VJClassifier classifier) throws IllegalArgumentException {
        super(interpolator, shader, classifier);
    }

    @Override
    public void setVolume(Volume v) {
        this.v = v;
        VJThresholdedVolume tv = new VJThresholdedVolume(v, this.classifier);
        this.shell = new VJBinaryShell(tv);
    }

    @Override
    public synchronized void run() {
        this.running = true;
        float iso = (float)this.classifier.getThreshold();
        this.newViewportBuffer();
        VJValue sample0 = null;
        sample0 = this.outputType == 4 && this.v instanceof VolumeRGB ? new VJValueHSB() : new VJValue();
        VJValue sample1 = new VJValue();
        float[] istep = this.mi.getColumn(0);
        float[] jstep = this.mi.getColumn(1);
        float[] kstep = this.mi.getColumn(2);
        float[] cstep = this.mi.getColumn(3);
        float dx = (float)(this.depth - 1) * kstep[0];
        float dy = (float)(this.depth - 1) * kstep[1];
        float dz = (float)(this.depth - 1) * kstep[2];
        VJCell cell = new VJCell(this.m, this.mi);
        float[] rayvs = VJMatrix.newVector(this.ioffset, this.joffset, this.koffset);
        float[] rayos = this.mi.mul(rayvs);
        float ckx = (float)this.koffset * kstep[0] + (float)this.joffset * jstep[0] + (float)this.ioffset * istep[0] + cstep[0];
        float cky = (float)this.koffset * kstep[1] + (float)this.joffset * jstep[1] + (float)this.ioffset * istep[1] + cstep[1];
        float ckz = (float)this.koffset * kstep[2] + (float)this.joffset * jstep[2] + (float)this.ioffset * istep[2] + cstep[2];
        this.shell.advancePrepare(dx, dy, dz);
        long start = System.currentTimeMillis();
        for (int j = 0; j < this.height && this.running; ++j) {
            float ox = ckx + (float)j * jstep[0];
            float oy = cky + (float)j * jstep[1];
            float oz = ckz + (float)j * jstep[2];
            for (int i = 0; i < this.width; ++i) {
                cell.move(ox, oy, oz);
                int max = this.shell.advanceInit(cell, ox, oy, oz);
                while (true) {
                    float[] kintersect;
                    int k;
                    if (this.onTrace(i, j)) {
                        k = this.shell.advanceToSurfaceTracing(cell);
                        this.trace("(" + this.sequenceNumber + ")" + i + "," + j + ": " + this.shell.s);
                    } else {
                        k = this.shell.advanceToSurface(cell);
                    }
                    if (k >= max) break;
                    if (!this.interpolator.isValidGradient(cell, this.v)) continue;
                    if (this.onTrace(i, j)) {
                        kintersect = cell.intersectTracing(this.ioffset + i, this.joffset + j, this.koffset + k);
                        this.trace("(" + this.sequenceNumber + ")" + i + "," + j + ": " + cell.s);
                    } else {
                        kintersect = cell.intersect(this.ioffset + i, this.joffset + j, this.koffset + k);
                    }
                    if (kintersect == null) continue;
                    VJVoxelLoc vlk0 = new VJVoxelLoc(ox + (kintersect[0] - rayvs[2]) * kstep[0], oy + (kintersect[0] - rayvs[2]) * kstep[1], oz + (kintersect[0] - rayvs[2]) * kstep[2]);
                    VJVoxelLoc vlk1 = new VJVoxelLoc(ox + (kintersect[1] - rayvs[2]) * kstep[0], oy + (kintersect[1] - rayvs[2]) * kstep[1], oz + (kintersect[1] - rayvs[2]) * kstep[2]);
                    float k0sample = this.interpolator.value((VJValue)sample0, (Volume)this.v, (VJVoxelLoc)vlk0).floatvalue;
                    float k1sample = this.interpolator.value((VJValue)sample1, (Volume)this.v, (VJVoxelLoc)vlk1).floatvalue;
                    if (iso >= k0sample && iso <= k1sample || iso >= k1sample && iso <= k0sample) {
                        int pixel;
                        VJVoxelLoc vl = this.bisection(sample0, vlk0, iso, kintersect[0], kintersect[1], k0sample, k1sample, kstep, 3);
                        VJGradient g = this.interpolator.gradient(this.v, vl);
                        g.normalize();
                        VJShade shade = this.shader.shade(g);
                        if (sample0 instanceof VJValueHSB) {
                            VJValueHSB samplehsb = (VJValueHSB)sample0;
                            this.interpolator.valueHS(samplehsb, (VolumeRGB)this.v, iso, vl);
                            pixel = Color.HSBtoRGB(samplehsb.getHue(), samplehsb.getSaturation(), shade.get());
                        } else {
                            pixel = (int)((double)shade.get() * 255.0);
                        }
                        this.setPixel(pixel, i, j);
                        break;
                    }
                    if (!this.onTrace(i, j)) continue;
                    this.trace("(" + this.sequenceNumber + ") failed iso bracket at " + vlk0 + "," + vlk1 + " samples " + k0sample + ", " + k1sample);
                }
                ox += istep[0];
                oy += istep[1];
                oz += istep[2];
            }
            VJIsosurfaceRender.yield();
        }
        VJUserInterface.progress(1.0f);
        this.traceWrite();
        this.pixelms = (float)(System.currentTimeMillis() - start) / (float)(this.width * this.height);
        this.running = false;
    }

    private VJVoxelLoc bisection(VJValue sample, VJVoxelLoc vlk0, float iso, float k0, float k1, float k0sample, float k1sample, float[] kstep, int steps) {
        float basek0 = k0;
        float basek1 = k1;
        float base0sample = k0sample;
        float base1sample = k1sample;
        VJVoxelLoc vl = null;
        for (int s = 0; s < steps; ++s) {
            float m = k0 + (k1 - k0) / 2.0f;
            float mdiff = m - basek0;
            vl = new VJVoxelLoc(vlk0.x + mdiff * kstep[0], vlk0.y + mdiff * kstep[1], vlk0.z + mdiff * kstep[2]);
            float samplef = this.interpolator.value((VJValue)sample, (Volume)this.v, (VJVoxelLoc)vl).floatvalue;
            float dk0 = k0sample - iso;
            float dk1 = k1sample - iso;
            float diso = samplef - iso;
            if (diso < 1.0E-4f) {
                return vl;
            }
            if ((double)(dk0 * diso) > 0.0) {
                k0sample = samplef;
                k0 = m;
                continue;
            }
            if ((double)(dk1 * diso) > 0.0) {
                k1sample = samplef;
                k1 = m;
                continue;
            }
            if (Math.abs(dk0) >= Math.abs(dk1)) {
                k0sample = samplef;
                k0 = m;
                continue;
            }
            k1sample = samplef;
            k1 = m;
        }
        float sampleDiff = k1sample - k0sample;
        if ((double)Math.abs(sampleDiff) > 0.0) {
            float f = (iso - k0sample) / sampleDiff;
            float t = k0 + (k1 - k0) * f;
            float tshift = t - basek0;
            vl = new VJVoxelLoc(vlk0.x + tshift * kstep[0], vlk0.y + tshift * kstep[1], vlk0.z + tshift * kstep[2]);
        }
        return vl;
    }

    public static String desc() {
        return "Isosurface";
    }
}

