/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import bijnum.BIJJacobi;
import bijnum.BIJutil;
import bijnum.SVDC;
import bijnum.SVDCException;
import ij.IJ;

public class BIJmatrix {
    public static float[][] mul(float[][] a, float[][] b) {
        float[][] n = new float[a.length][b[0].length];
        BIJmatrix.mul(n, a, b, false);
        return n;
    }

    public static float[][] mul(float[][] a, float[][] b, boolean doShowProgress) {
        float[][] n = new float[a.length][b[0].length];
        BIJmatrix.mul(n, a, b, doShowProgress);
        return n;
    }

    public static void mul(float[][] m, float[][] a, float[][] b, boolean doShowProgress) {
        int iN = a.length;
        int iM = b[0].length;
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                float r = 0.0f;
                for (int k = 0; k < b.length; ++k) {
                    r += a[j][k] * b[k][i];
                }
                m[j][i] = r;
            }
            if (!doShowProgress) continue;
            IJ.showProgress((int)j, (int)iN);
        }
    }

    public static float[] mul(float[][] a, float[] v) throws IllegalArgumentException {
        if (a[0].length != v.length) {
            throw new IllegalArgumentException("mul dimensions do not match: " + a.length + "x" + a[0].length + " " + v.length);
        }
        float[] n = new float[a.length];
        for (int i = 0; i < n.length; ++i) {
            for (int k = 0; k < v.length; ++k) {
                int n2 = i;
                n[n2] = n[n2] + a[i][k] * v[k];
            }
        }
        return n;
    }

    public static void mulElements(double[] r, double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] * b[i];
        }
    }

    public static void mulElements(float[] r, float[] a, float[] b) {
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] * b[i];
        }
    }

    public static float[] mulElements(float[] a, float[] b) {
        float[] n = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            n[i] = a[i] * b[i];
        }
        return n;
    }

    public static void divElements(float[] r, float[] a, float[] b) {
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] / b[i];
        }
    }

    public static float[][] mulOuter(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("mul dimensions do not match: " + a.length + "!=" + b.length);
        }
        float[][] n = new float[a.length][a.length];
        for (int j = 0; j < n.length; ++j) {
            for (int i = 0; i < n[0].length; ++i) {
                n[j][i] = a[j] * b[i];
            }
        }
        return n;
    }

    public static float[][] mulT(float[][] a, float[][] b, boolean doShowProgress) {
        int iN = a[0].length;
        int iM = b[0].length;
        float[][] n = new float[iM][iN];
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                float r = 0.0f;
                for (int k = 0; k < b.length; ++k) {
                    r += a[k][j] * b[k][i];
                }
                n[i][j] = r;
            }
            if (!doShowProgress) continue;
            IJ.showProgress((int)j, (int)iN);
        }
        return n;
    }

    @Deprecated
    public static float[] mul(float[] v, double scalar) {
        int iN = v.length;
        float[] n = new float[iN];
        for (int i = 0; i < iN; ++i) {
            n[i] = (float)((double)v[i] * scalar);
        }
        return n;
    }

    public static void mulElements(float[] r, float[] v, double scalar) {
        for (int i = 0; i < v.length; ++i) {
            r[i] = (float)((double)v[i] * scalar);
        }
    }

    public static void mulElements(double[] r, double[] v, double scalar) {
        for (int i = 0; i < v.length; ++i) {
            r[i] = v[i] * scalar;
        }
    }

    public static void mul(float[][] r, float[][] m, float scalar) {
        int iN = m.length;
        int iM = m[0].length;
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                r[j][i] = m[j][i] * scalar;
            }
        }
    }

    public static void mul(float[] r, float[][] a, float[] v) throws IllegalArgumentException {
        if (a[0].length != v.length) {
            throw new IllegalArgumentException("mul dimensions do not match: " + a.length + "x" + a[0].length + " " + v.length);
        }
        for (int i = 0; i < a.length; ++i) {
            for (int k = 0; k < v.length; ++k) {
                int n = i;
                r[n] = r[n] + a[i][k] * v[k];
            }
        }
    }

    public static float[] flatten(float[][] m) {
        int iN = m.length;
        int iM = m[0].length;
        float[] n = new float[iN * iM];
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                n[j * iM + i] = m[j][i];
            }
        }
        return n;
    }

    public static boolean containsNaN(float[] v) {
        for (int j = 0; j < v.length; ++j) {
            if (!Float.isNaN(v[j])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNaN(float[][] m) {
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                if (!Float.isNaN(m[j][i])) continue;
                return true;
            }
        }
        return false;
    }

    public static float[][] transpose(float[][] m) {
        float[][] n = new float[m[0].length][m.length];
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                n[i][j] = m[j][i];
            }
        }
        return n;
    }

    public static byte[][] transpose(byte[][] m) {
        byte[][] n = new byte[m[0].length][m.length];
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                n[i][j] = m[j][i];
            }
        }
        return n;
    }

    public static float[] minmax(float[][] m) {
        int iN = m.length;
        int iM = m[0].length;
        float[] minmax = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                float val = m[j][i];
                if (val == Float.NaN) continue;
                if (val < minmax[0]) {
                    minmax[0] = val;
                    continue;
                }
                if (!(val > minmax[1])) continue;
                minmax[1] = val;
            }
        }
        return minmax;
    }

    public static float[] minmax(float[] v) {
        float[] minmax = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        for (int j = 0; j < v.length; ++j) {
            float val = v[j];
            if (Float.isNaN(val)) continue;
            if (val < minmax[0]) {
                minmax[0] = val;
                continue;
            }
            if (!(val > minmax[1])) continue;
            minmax[1] = val;
        }
        return minmax;
    }

    public static float[] minmaxNot0(float[] v) {
        float[] minmax = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        for (int j = 0; j < v.length; ++j) {
            float val = v[j];
            if (val == 0.0f) continue;
            if (val < minmax[0]) {
                minmax[0] = val;
                continue;
            }
            if (!(val > minmax[1])) continue;
            minmax[1] = val;
        }
        return minmax;
    }

    public static float[] minmaxNot0(float[][] m) {
        int iN = m.length;
        int iM = m[0].length;
        float[] minmax = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                float val = m[j][i];
                if (val == 0.0f) continue;
                if (val < minmax[0]) {
                    minmax[0] = val;
                    continue;
                }
                if (!(val > minmax[1])) continue;
                minmax[1] = val;
            }
        }
        return minmax;
    }

    public static float[] abs(float[] v) {
        float[] n = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            n[i] = Math.abs(v[i]);
        }
        return n;
    }

    public static float[] mask(float[] v, float[] mask) {
        int n = 0;
        for (int i = 0; i < mask.length; ++i) {
            if (!(mask[i] > 0.0f)) continue;
            ++n;
        }
        float[] nv = new float[n];
        int c = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!(mask[i] > 0.0f)) continue;
            nv[c++] = v[i];
        }
        return nv;
    }

    public static float[] add(float[] v, float scalar, float[] mask) {
        int iN = v.length;
        for (int j = 0; j < iN; ++j) {
            if (mask[j] != 1.0f) continue;
            int n = j;
            v[n] = v[n] + scalar;
        }
        return v;
    }

    public static void addElements(double[] r, double[] a, double[] b) {
        for (int j = 0; j < a.length; ++j) {
            r[j] = a[j] + b[j];
        }
    }

    public static void addElements(float[] r, float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Vector sizes do not match " + a.length + " " + b.length);
        }
        for (int j = 0; j < a.length; ++j) {
            r[j] = a[j] + b[j];
        }
    }

    public static void add(float[][] r, float[][] a, float[][] b) {
        for (int j = 0; j < a.length; ++j) {
            for (int k = 0; k < a[0].length; ++k) {
                r[j][k] = a[j][k] + b[j][k];
            }
        }
    }

    public static float[] addElements(float[] a, float[] b) {
        float[] n = new float[a.length];
        for (int j = 0; j < a.length; ++j) {
            n[j] = a[j] + b[j];
        }
        return n;
    }

    public static float[][] pow(float[][] m, float power) {
        int iN = m.length;
        int iM = m[0].length;
        float[][] nm = new float[iN][iM];
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                nm[j][i] = (float)Math.pow(m[j][i], power);
            }
        }
        return nm;
    }

    public static float norm(float[] v) {
        double l = 0.0;
        for (int i = 0; i < v.length; ++i) {
            l += (double)v[i] * (double)v[i];
        }
        return (float)Math.sqrt(l);
    }

    public static void ln(float[] r, float[] v) {
        for (int i = 0; i < v.length; ++i) {
            r[i] = v[i] == 0.0f ? (float)Math.log(1.4E-45f) : (float)Math.log(v[i]);
        }
    }

    public static void pow(double[] r, double[] v, double power) {
        for (int i = 0; i < v.length; ++i) {
            r[i] = power < 1.0 && power > -1.0 && v[i] < 0.0 ? 0.0 : Math.pow(v[i], power);
        }
    }

    public static void pow(float[] r, float[] v, double power) {
        for (int i = 0; i < v.length; ++i) {
            r[i] = power < 1.0 && power > -1.0 && v[i] < 0.0f ? 0.0f : (float)Math.pow(v[i], power);
        }
    }

    public static float[] div(float[] v, double divisor) {
        int iN = v.length;
        float[] nv = new float[iN];
        for (int i = 0; i < iN; ++i) {
            nv[i] = (float)((double)v[i] / divisor);
        }
        return nv;
    }

    public static void divElements(float[][] m, double divisor) {
        int iN = m.length;
        int iM = m[0].length;
        for (int j = 0; j < iN; ++j) {
            int i = 0;
            while (i < iM) {
                float[] fArray = m[j];
                int n = i++;
                fArray[n] = (float)((double)fArray[n] / divisor);
            }
        }
    }

    public static float[] copy(float[] v) {
        float[] nv = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            nv[i] = v[i];
        }
        return nv;
    }

    public static float[][] copy(float[][] m) {
        int iN = m.length;
        int iM = m[0].length;
        float[][] nm = new float[iN][iM];
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                nm[j][i] = m[j][i];
            }
        }
        return nm;
    }

    public static void add(float[][] m, double scalar) {
        for (int j = 0; j < m.length; ++j) {
            int i = 0;
            while (i < m[0].length) {
                float[] fArray = m[j];
                int n = i++;
                fArray[n] = (float)((double)fArray[n] + scalar);
            }
        }
    }

    public static void add(float[][] a, float[][] b) throws IllegalArgumentException {
        if (a.length != b.length) {
            throw new IllegalArgumentException("sub: vector sizes do not match");
        }
        int iN = a.length;
        int iM = a[0].length;
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                float[] fArray = a[j];
                int n = i;
                fArray[n] = fArray[n] + b[j][i];
            }
        }
    }

    public static void sub(float[][] r, float[][] m, float[][] n) {
        int iN = m.length;
        int iM = m[0].length;
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                r[j][i] = m[j][i] - n[j][i];
            }
        }
    }

    public static void sub(float[][] r, float[][] m, float[] v) throws IllegalArgumentException {
        int iN = m.length;
        int iM = m[0].length;
        if (iM != v.length) {
            throw new IllegalArgumentException("sub: vector size does not match matrix");
        }
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                r[j][i] = m[j][i] - v[i];
            }
        }
    }

    public static float[] sub(float[] a, float[] b) throws IllegalArgumentException {
        if (a.length != b.length) {
            throw new IllegalArgumentException("sub: vector sizes do not match");
        }
        float[] n = new float[a.length];
        for (int j = 0; j < a.length; ++j) {
            n[j] = a[j] - b[j];
        }
        return n;
    }

    public static void subElements(float[] r, float[] a, float[] b) {
        for (int j = 0; j < a.length; ++j) {
            r[j] = a[j] - b[j];
        }
    }

    public static void sub(float[] r, float[] a, double scalar) {
        for (int j = 0; j < a.length; ++j) {
            r[j] = (float)((double)a[j] - scalar);
        }
    }

    public static float[] diag(float[][] m) {
        int iN = m.length;
        float[] v = new float[iN];
        for (int i = 0; i < iN; ++i) {
            v[i] = m[i][i];
        }
        return v;
    }

    public static float[][] diag(float[] v) {
        int iN = v.length;
        float[][] m = new float[iN][iN];
        for (int i = 0; i < iN; ++i) {
            m[i][i] = v[i];
        }
        return m;
    }

    public static float[] trunc(float[] v, int n) {
        int iN = v.length;
        if (iN == n) {
            return v;
        }
        float[] nv = new float[n];
        for (int i = 0; i < n; ++i) {
            nv[i] = v[i];
        }
        return nv;
    }

    public static float[][] trunc(float[][] m, int n) {
        int iN = m.length;
        if (iN == n) {
            return m;
        }
        float[][] nm = new float[n][];
        for (int i = 0; i < n; ++i) {
            nm[i] = m[i];
        }
        return nm;
    }

    public static float[] subset(float[] v, int[] indices) {
        float[] r = new float[indices.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = v[indices[i]];
        }
        return r;
    }

    public static float[] subset(float[] v, int start) {
        float[] r = new float[v.length - start];
        for (int i = start; i < r.length; ++i) {
            r[i - start] = v[i];
        }
        return r;
    }

    public static float[] subset(float[] v, int start, int last) {
        float[] r = new float[last - start + 1];
        for (int i = start; i <= last; ++i) {
            r[i - start] = v[i];
        }
        return r;
    }

    public static float[][] subset(float[][] m, int start, int last) {
        float[][] r = new float[last - start + 1][];
        for (int i = start; i <= last; ++i) {
            r[i - start] = m[i];
        }
        return r;
    }

    public static float[][] subset(float[][] m, int[] indices) {
        float[][] r = new float[indices.length][];
        for (int i = 0; i < r.length; ++i) {
            r[i] = m[indices[i]];
        }
        return r;
    }

    public static float[][] subsetColumns(float[][] m, int[] indices) {
        float[][] r = new float[m.length][indices.length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = 0; j < r[0].length; ++j) {
                r[i][j] = m[i][indices[j]];
            }
        }
        return r;
    }

    public static float[] col(float[][] m, int n) {
        float[] v = new float[m.length];
        for (int i = 0; i < m.length; ++i) {
            v[i] = m[i][n];
        }
        return v;
    }

    public static float[] concat(float[] a, float[] b) {
        int i;
        int al = 0;
        if (a != null) {
            al = a.length;
        }
        float[] v = new float[al + b.length];
        for (i = 0; i < al; ++i) {
            v[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            v[i + al] = b[i];
        }
        return v;
    }

    public static float[][] repmat(float[] a, int n, int m) {
        float[][] b = new float[n][m * a.length];
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                b[j][i] = a[i % a.length];
            }
        }
        return b;
    }

    public static float[][] repmat(float[][] a, int n, int m) {
        float[][] b = new float[n * a.length][m * a[0].length];
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                b[j][i] = a[j % a.length][i % a[0].length];
            }
        }
        return b;
    }

    public static float[][] inverse(float[][] m) throws IllegalArgumentException {
        if (m.length > 4) {
            throw new IllegalArgumentException("Cannot invert this matrix " + m.length);
        }
        float[][] mi = new float[m.length][m[0].length];
        if (m.length == 2) {
            BIJmatrix.invert2x2(mi, m);
        } else if (m.length == 3) {
            BIJmatrix.invert3x3(mi, m);
        } else if (m.length == 4) {
            BIJmatrix.invert4x4(mi, m);
        }
        return mi;
    }

    private static void invert2x2(float[][] mi, float[][] m) {
        float d = BIJmatrix.determinant(m);
        mi[0][0] = m[1][1] / d;
        mi[0][1] = -m[0][1] / d;
        mi[1][0] = -m[1][0] / d;
        mi[1][1] = m[0][0] / d;
    }

    private static void invert3x3(float[][] mi, float[][] m) {
        float d = BIJmatrix.determinant(m);
        if (Math.abs(d) <= 2.8E-45f) {
            mi[0][0] = 0.0f;
            mi[0][1] = 0.0f;
            mi[0][2] = 0.0f;
            mi[1][0] = 0.0f;
            mi[1][1] = 0.0f;
            mi[1][2] = 0.0f;
            mi[2][0] = 0.0f;
            mi[2][1] = 0.0f;
            mi[2][2] = 0.0f;
        } else {
            mi[0][0] = (-m[1][2] * m[2][1] + m[1][1] * m[2][2]) / d;
            mi[0][1] = (m[0][2] * m[2][1] - m[0][1] * m[2][2]) / d;
            mi[0][2] = (-m[0][2] * m[1][1] + m[0][1] * m[1][2]) / d;
            mi[1][0] = (m[1][2] * m[2][0] - m[1][0] * m[2][2]) / d;
            mi[1][1] = (-m[0][2] * m[2][0] + m[0][0] * m[2][2]) / d;
            mi[1][2] = (m[0][2] * m[1][0] - m[0][0] * m[1][2]) / d;
            mi[2][0] = (-m[1][1] * m[2][0] + m[1][0] * m[2][1]) / d;
            mi[2][1] = (m[0][1] * m[2][0] - m[0][0] * m[2][1]) / d;
            mi[2][2] = (-m[0][1] * m[1][0] + m[0][0] * m[1][1]) / d;
        }
    }

    private static void invert4x4(float[][] mi, float[][] m) throws IllegalArgumentException {
        float[] t = new float[20];
        float[] x = new float[4];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 1.0f;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 0.0f;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 0.0f;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 0.0f;
        if (BIJmatrix.GaussElim(t, x) <= 0) {
            throw new IllegalArgumentException("inverse failure");
        }
        mi[0][0] = x[0];
        mi[1][0] = x[1];
        mi[2][0] = x[2];
        mi[3][0] = x[3];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 0.0f;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 1.0f;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 0.0f;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 0.0f;
        if (BIJmatrix.GaussElim(t, x) <= 0) {
            throw new IllegalArgumentException("inverse failure");
        }
        mi[0][1] = x[0];
        mi[1][1] = x[1];
        mi[2][1] = x[2];
        mi[3][1] = x[3];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 0.0f;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 0.0f;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 1.0f;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 0.0f;
        if (BIJmatrix.GaussElim(t, x) <= 0) {
            throw new IllegalArgumentException("inverse failure");
        }
        mi[0][2] = x[0];
        mi[1][2] = x[1];
        mi[2][2] = x[2];
        mi[3][2] = x[3];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 0.0f;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 0.0f;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 0.0f;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 1.0f;
        if (BIJmatrix.GaussElim(t, x) <= 0) {
            throw new IllegalArgumentException("inverse failure");
        }
        mi[0][3] = x[0];
        mi[1][3] = x[1];
        mi[2][3] = x[2];
        mi[3][3] = x[3];
    }

    public static int GaussElim(float[] a, float[] x) {
        int j;
        int i;
        int n = x.length;
        for (int i2 = 0; i2 < n; ++i2) {
            x[i2] = 0.0f;
        }
        int w = n + 1;
        for (i = 0; i < n - 1; ++i) {
            int p;
            for (p = i; p < n && (double)a[p * w + i] == 0.0; ++p) {
            }
            if (p == n) {
                return 0;
            }
            if (p != i) {
                for (int k = 0; k < w; ++k) {
                    float temp = a[i * w + k];
                    a[i * w + k] = a[p * w + k];
                    a[p * w + k] = temp;
                }
            }
            for (j = i + 1; j < n; ++j) {
                float m = a[j * w + i] / a[i * w + i];
                for (int k = 0; k <= n; ++k) {
                    a[j * w + k] = a[j * w + k] - m * a[i * w + k];
                }
            }
        }
        if (a[(n - 1) * w + (n - 1)] == 0.0f) {
            return 0;
        }
        x[n - 1] = a[(n - 1) * w + n] / a[(n - 1) * w + (n - 1)];
        for (i = n - 2; i >= 0; --i) {
            float s = 0.0f;
            for (j = i + 1; j < n; ++j) {
                s += a[i * w + j] * x[j];
            }
            x[i] = (a[i * w + n] - s) / a[i * w + i];
        }
        return 1;
    }

    public static float determinant(float[][] m) {
        if (m.length == 2) {
            return m[0][0] * m[1][1] - m[1][0] * m[0][1];
        }
        if (m.length == 3) {
            float det = -m[0][2] * m[1][1] * m[2][0] + m[0][1] * m[1][2] * m[2][0] + m[0][2] * m[1][0] * m[2][1] - m[0][0] * m[1][2] * m[2][1] - m[0][1] * m[1][0] * m[2][2] + m[0][0] * m[1][1] * m[2][2];
            return det;
        }
        return 0.0f;
    }

    public static void test() {
        IJ.log((String)"Testing matrices.");
        float[][] h = new float[][]{{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, {6.0f, 7.0f, 8.0f, 9.0f, 10.0f}};
        IJ.log((String)("h = " + BIJutil.toString(h)));
        float[][] i = BIJmatrix.transpose(h);
        IJ.log((String)("i = " + BIJutil.toString(i)));
        float[][] j = BIJmatrix.mul(i, h);
        IJ.log((String)("i*h=j = " + BIJutil.toString(j)));
        float[][] k = BIJmatrix.mul((float[][])h, i);
        IJ.log((String)("h*i=k = " + BIJutil.toString(k)));
        BIJJacobi jac = new BIJJacobi(j);
        jac.compute();
        IJ.log((String)jac.toString());
    }

    public static void sort(float[] indicator, float[] v, float[][] m) {
        for (int i = 0; i < indicator.length; ++i) {
            int k = i;
            float p = indicator[k];
            for (int j = i + 1; j < indicator.length; ++j) {
                if (!(indicator[j] >= p)) continue;
                k = j;
                p = indicator[k];
            }
            if (k == i) continue;
            indicator[k] = indicator[i];
            indicator[i] = p;
            float t = v[i];
            v[i] = v[k];
            v[k] = t;
            for (int j = 0; j < m.length; ++j) {
                p = m[j][i];
                m[j][i] = m[j][k];
                m[j][k] = p;
            }
        }
    }

    public static int[] sort(float[] v) {
        int i;
        float[] vv = new float[v.length];
        for (i = 0; i < v.length; ++i) {
            vv[i] = v[i];
        }
        for (i = 0; i < v.length; ++i) {
            int k = i;
            float p = vv[k];
            for (int j = i + 1; j < v.length; ++j) {
                if (!(vv[j] >= p)) continue;
                k = j;
                p = vv[k];
            }
            if (k == i) continue;
            vv[k] = vv[i];
            vv[i] = p;
        }
        int[] indices = new int[v.length];
        block3: for (int i2 = 0; i2 < v.length; ++i2) {
            for (int j = 0; j < v.length; ++j) {
                if (v[j] != vv[i2]) continue;
                indices[i2] = j;
                continue block3;
            }
        }
        return indices;
    }

    @Deprecated
    public static float pseudoinverse(float[][] JI, float[][] J, double singularLimit) {
        int n = JI.length;
        int m = JI[0].length;
        double[][] dJ = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                dJ[i][j] = J[i][j];
            }
        }
        double[][] dJI = new double[n][m];
        float condnum = (float)BIJmatrix.pseudoinverse(dJI, dJ, singularLimit);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                JI[i][j] = (float)dJI[i][j];
            }
        }
        return condnum;
    }

    @Deprecated
    public static double pseudoinverse(double[][] JI, double[][] J, double singularLimit) {
        int k;
        int j;
        int i;
        int n = JI.length;
        int m = JI[0].length;
        if (n > J[0].length || m > J.length) {
            throw new IllegalArgumentException("pseudoinverse failure");
        }
        double[][] U = new double[m][n];
        double[][] V = new double[n][n];
        double[] W = new double[n];
        double[] zero = new double[n];
        double[] temp = new double[m];
        double[][] tempJ = new double[m][n];
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j2 = 0; j2 < n; ++j2) {
                tempJ[i2][j2] = J[i2][j2];
            }
        }
        try {
            SVDC.dsvdc_j(tempJ, m, n, W, zero, U, V, temp, 21);
        }
        catch (SVDCException e) {
            throw new IllegalArgumentException("svdc failure");
        }
        double[][] DI = new double[n][n];
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i3 = 0; i3 < n; ++i3) {
            DI[i3][i3] = W[i3] != 0.0 ? 1.0 / W[i3] : Double.MAX_VALUE;
            if (Math.abs(W[i3]) > max) {
                max = Math.abs(W[i3]);
            }
            if (!(Math.abs(W[i3]) < min)) continue;
            min = Math.abs(W[i3]);
        }
        double condnum = min != 0.0 ? max / min : Double.MAX_VALUE;
        double[][] V1 = new double[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                V1[i][j] = 0.0;
                for (k = 0; k < n; ++k) {
                    double[] dArray = V1[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + V[i][k] * DI[k][j];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                JI[i][j] = 0.0;
                for (k = 0; k < n; ++k) {
                    double[] dArray = JI[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + V1[i][k] * U[j][k];
                }
            }
        }
        if (condnum < 100000.0 && !BIJmatrix.checkinverse(J, JI)) {
            throw new IllegalArgumentException("pseudoinverse failure");
        }
        if (singularLimit != 0.0) {
            for (i = 0; i < n; ++i) {
                if (!(DI[i][i] > 1.0 / singularLimit)) continue;
                DI[i][i] = 1.0 / singularLimit;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                V1[i][j] = 0.0;
                for (k = 0; k < n; ++k) {
                    double[] dArray = V1[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + V[i][k] * DI[k][j];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                JI[i][j] = 0.0;
                for (k = 0; k < n; ++k) {
                    double[] dArray = JI[i];
                    int n5 = j;
                    dArray[n5] = dArray[n5] + V1[i][k] * U[j][k];
                }
            }
        }
        return condnum;
    }

    public static boolean checkinverse(double[][] J, double[][] JI) {
        int j;
        int i;
        int n = JI.length;
        int m = JI[0].length;
        boolean error = false;
        double[][] I = new double[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                I[i][j] = 0.0;
                for (int k = 0; k < m; ++k) {
                    double[] dArray = I[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + JI[i][k] * J[k][j];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (i == j) {
                    if (!(Math.abs(I[i][i]) < 0.9999) && !(Math.abs(I[i][i]) > 1.0001)) continue;
                    error = true;
                    continue;
                }
                if (!(Math.abs(I[i][j]) > 1.0E-4)) continue;
                error = true;
            }
        }
        if (error) {
            int j2;
            IJ.log((String)"Inverse failure\nJ matrix =");
            for (i = 0; i < m; ++i) {
                String s = "";
                for (j2 = 0; j2 < n; ++j2) {
                    s = s + J[i][j2] + "\t";
                }
                IJ.log((String)s);
            }
            IJ.log((String)"JI matrix =");
            for (i = 0; i < m; ++i) {
                String s = "";
                for (j2 = 0; j2 < n; ++j2) {
                    s = s + JI[j2][i] + "\t ";
                }
                IJ.log((String)s);
            }
            IJ.log((String)"I matrix =");
            for (i = 0; i < n; ++i) {
                String s = "";
                for (j2 = 0; j2 < n; ++j2) {
                    s = s + I[j2][i] + "\t ";
                }
                IJ.log((String)s);
            }
        }
        return !error;
    }
}

