/*
 * Decompiled with CFR 0.152.
 */
package knn;

import bijnum.BIJmatrix;
import knn.Feature;
import volume.Convolver;
import volume.GaussianDerivative;

public class FilterBank {
    protected float[] scales;
    protected float[][] thetas;
    protected int nrOrders;
    protected int n = -1;

    public FilterBank(float[] scales, int nrOrders) {
        this.scales = scales;
        this.nrOrders = nrOrders;
        this.thetas = new float[nrOrders][];
        for (int scale = 0; scale < scales.length; ++scale) {
            for (int order = 0; order < nrOrders; ++order) {
                this.thetas[order] = FilterBank.thetaSet(order);
            }
        }
    }

    public int getNumber() {
        if (this.n < 0) {
            for (int scale = 0; scale < this.scales.length; ++scale) {
                for (int order = 0; order < this.nrOrders; ++order) {
                    if (this.thetas[order] != null) {
                        for (int theta = 0; theta < this.thetas[order].length; ++theta) {
                            ++this.n;
                        }
                        continue;
                    }
                    ++this.n;
                }
            }
        }
        return this.n + 1;
    }

    public Feature filter(int filternumber, float[] image, int width, String extraText) {
        Feature f = null;
        double[] params = this.params(filternumber);
        f = FilterBank.L(image, width, (int)params[0], params[1], params[2], extraText);
        return f;
    }

    public String toString(int filternumber, String preString) {
        String name = "<unknown " + filternumber + ">";
        double[] params = this.params(filternumber);
        name = FilterBank.name((int)params[0], params[1], params[2], preString);
        return name;
    }

    protected static String name(int order, double scale, double theta, String extraText) {
        if (order == 0) {
            return extraText + "L" + order + " scale=" + scale + "p";
        }
        return extraText + "L" + order + "(" + theta + " dgrs) scale=" + scale + "p";
    }

    protected double[] params(int filternumber) {
        double[] r = new double[3];
        for (int scale = 0; scale < this.scales.length; ++scale) {
            for (int order = 0; order < this.nrOrders; ++order) {
                for (int theta = 0; theta < this.thetas[order].length; ++theta) {
                    if (filternumber-- > 0) continue;
                    r[0] = order;
                    r[1] = this.scales[scale];
                    r[2] = this.thetas[order][theta];
                    return r;
                }
            }
        }
        return null;
    }

    public static Feature L(float[] image, int width, int n, double scale, double theta, String extraText) {
        Feature f = null;
        if (n == 0) {
            GaussianDerivative k0 = new GaussianDerivative(scale, 0);
            float[] L = Convolver.convolvex(image, width, image.length / width, k0);
            L = Convolver.convolvey(L, width, image.length / width, k0);
            f = new Feature(FilterBank.name(n, scale, theta, extraText), L);
        } else if (n == 1) {
            GaussianDerivative k0 = new GaussianDerivative(scale, 0);
            GaussianDerivative k1 = new GaussianDerivative(scale, 1);
            float[] Lx = Convolver.convolvex(image, width, image.length / width, k1);
            Lx = Convolver.convolvey(Lx, width, image.length / width, k0);
            float[] Ly = Convolver.convolvex(image, width, image.length / width, k0);
            Ly = Convolver.convolvey(Ly, width, image.length / width, k1);
            double cth = Math.cos(theta / 180.0 * Math.PI);
            double sth = Math.sin(theta / 180.0 * Math.PI);
            float[] px = new float[Lx.length];
            BIJmatrix.mulElements(px, Lx, cth);
            float[] py = new float[Lx.length];
            BIJmatrix.mulElements(py, Ly, sth);
            float[] L = BIJmatrix.addElements(px, py);
            f = new Feature(FilterBank.name(n, scale, theta, extraText), L);
        } else if (n == 2) {
            GaussianDerivative k0 = new GaussianDerivative(scale, 0);
            GaussianDerivative k1 = new GaussianDerivative(scale, 1);
            GaussianDerivative k2 = new GaussianDerivative(scale, 2);
            float[] Lxx = Convolver.convolvex(image, width, image.length / width, k2);
            Lxx = Convolver.convolvey(Lxx, width, image.length / width, k0);
            float[] Lxy = Convolver.convolvex(image, width, image.length / width, k1);
            Lxy = Convolver.convolvey(Lxy, width, image.length / width, k1);
            float[] Lyy = Convolver.convolvex(image, width, image.length / width, k0);
            Lyy = Convolver.convolvey(Lyy, width, image.length / width, k2);
            double cth = Math.cos(theta / 180.0 * Math.PI);
            double sth = Math.sin(theta / 180.0 * Math.PI);
            double c2th = cth * cth;
            double csth = cth * sth;
            double s2th = sth * sth;
            float[] pxx2 = new float[Lxx.length];
            BIJmatrix.mulElements(pxx2, Lxx, c2th);
            float[] pxy2 = new float[Lxy.length];
            BIJmatrix.mulElements(pxy2, Lxy, 2.0 * csth);
            float[] pyy2 = new float[Lyy.length];
            BIJmatrix.mulElements(pyy2, Lyy, s2th);
            float[] L = BIJmatrix.addElements(pxx2, pxy2);
            BIJmatrix.addElements(L, L, pyy2);
            f = new Feature(FilterBank.name(n, scale, theta, extraText), L);
        }
        return f;
    }

    public static Feature[] filter(float[] image, int width, float[] scales) {
        int nrOrders = 3;
        Feature[][][] ls = new Feature[scales.length][nrOrders][];
        float[][] thetas = new float[nrOrders][];
        int length = 0;
        for (int j = 0; j < scales.length; ++j) {
            for (int order = 0; order < nrOrders; ++order) {
                thetas[order] = FilterBank.thetaSet(order);
                ls[j][order] = FilterBank.L(image, width, order, scales[j], thetas[order]);
                length += ls[j][order].length;
            }
        }
        Feature[] Ln = new Feature[length];
        int index = 0;
        for (int j = 0; j < scales.length; ++j) {
            for (int order = 0; order < nrOrders; ++order) {
                for (int i = 0; i < ls[j][order].length; ++i) {
                    Ln[index++] = ls[j][order][i];
                }
            }
        }
        ls = null;
        return Ln;
    }

    public static float[] thetaSet(int order) {
        float[] theta = new float[order + 1];
        theta[0] = 0.0f;
        if (order == 1) {
            theta[1] = 90.0f;
        } else if (order == 2) {
            theta[1] = 60.0f;
            theta[2] = 120.0f;
        } else if (order != 0) {
            throw new IllegalArgumentException("order > 2");
        }
        return theta;
    }

    public static float[] scaleSet(int n) {
        float[] scales = new float[n];
        for (int i = 0; i < n; ++i) {
            scales[i] = (float)Math.pow(2.0, i);
        }
        return scales;
    }

    public static Feature[] L(float[] image, int width, int n, double scale, float[] theta) {
        Feature[] f;
        block3: {
            float[][] L;
            block4: {
                block2: {
                    f = new Feature[theta.length];
                    L = new float[theta.length][];
                    if (n != 0) break block2;
                    GaussianDerivative k0 = new GaussianDerivative(scale, 0);
                    L[0] = Convolver.convolvex(image, width, image.length / width, k0);
                    L[0] = Convolver.convolvey(L[0], width, image.length / width, k0);
                    f[0] = new Feature(FilterBank.name(n, scale, 0.0, ""), L[0]);
                    break block3;
                }
                if (n != 1) break block4;
                GaussianDerivative k0 = new GaussianDerivative(scale, 0);
                GaussianDerivative k1 = new GaussianDerivative(scale, 1);
                float[] Lx = Convolver.convolvex(image, width, image.length / width, k1);
                Lx = Convolver.convolvey(Lx, width, image.length / width, k0);
                float[] Ly = Convolver.convolvex(image, width, image.length / width, k0);
                Ly = Convolver.convolvey(Ly, width, image.length / width, k1);
                for (int i = 0; i < theta.length; ++i) {
                    double cth = Math.cos((double)(theta[i] / 180.0f) * Math.PI);
                    double sth = Math.sin((double)(theta[i] / 180.0f) * Math.PI);
                    float[] px = new float[Lx.length];
                    BIJmatrix.mulElements(px, Lx, cth);
                    float[] py = new float[Lx.length];
                    BIJmatrix.mulElements(py, Ly, sth);
                    L[i] = BIJmatrix.addElements(px, py);
                    f[i] = new Feature(FilterBank.name(n, scale, theta[i], ""), L[i]);
                }
                break block3;
            }
            if (n != 2) break block3;
            GaussianDerivative k0 = new GaussianDerivative(scale, 0);
            GaussianDerivative k1 = new GaussianDerivative(scale, 1);
            GaussianDerivative k2 = new GaussianDerivative(scale, 2);
            float[] Lxx = Convolver.convolvex(image, width, image.length / width, k2);
            Lxx = Convolver.convolvey(Lxx, width, image.length / width, k0);
            float[] Lxy = Convolver.convolvex(image, width, image.length / width, k1);
            Lxy = Convolver.convolvey(Lxy, width, image.length / width, k1);
            float[] Lyy = Convolver.convolvex(image, width, image.length / width, k0);
            Lyy = Convolver.convolvey(Lyy, width, image.length / width, k2);
            for (int i = 0; i < theta.length; ++i) {
                double cth = Math.cos((double)(theta[i] / 180.0f) * Math.PI);
                double sth = Math.sin((double)(theta[i] / 180.0f) * Math.PI);
                double c2th = cth * cth;
                double csth = cth * sth;
                double s2th = sth * sth;
                float[] pxx2 = new float[Lxx.length];
                BIJmatrix.mulElements(pxx2, Lxx, c2th);
                float[] pxy2 = new float[Lxy.length];
                BIJmatrix.mulElements(pxy2, Lxy, 2.0 * csth);
                float[] pyy2 = new float[Lyy.length];
                BIJmatrix.mulElements(pyy2, Lyy, s2th);
                L[i] = BIJmatrix.addElements(pxx2, pxy2);
                BIJmatrix.addElements(L[i], L[i], pyy2);
                f[i] = new Feature(FilterBank.name(n, scale, theta[i], ""), L[i]);
            }
        }
        return f;
    }
}

