/*
 * Decompiled with CFR 0.152.
 */
package knn;

import bijfit.DesignMatrix;
import bijfit.DesignMatrixLinear;
import bijfit.GeneralLinearLeastSquares;
import bijnum.BIJfit;
import bijnum.BIJmatrix;
import bijnum.BIJutil;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import knn.Feature;
import volume.Convolver;
import volume.GaussianDerivative;
import volume.Transformer;

public class StereoFilterBank {
    protected float[] scales;
    protected float[] xshifts;
    protected int nrOrders;
    protected int n = -1;

    public StereoFilterBank() {
    }

    public StereoFilterBank(float[] scales, float[] xshifts) {
        this.scales = scales;
        this.nrOrders = 1;
        this.xshifts = xshifts;
    }

    public int getNumber() {
        this.n = this.xshifts.length * this.scales.length;
        return this.n;
    }

    public String toString(int filternumber, String preString) {
        double[] params = this.params(filternumber);
        String name = "<unknown " + filternumber + ">";
        if (params != null) {
            name = StereoFilterBank.name((int)params[0], params[1], 0.0, preString);
        }
        return name;
    }

    public static String toString(String preString) {
        return preString + "D scale=" + 0 + "p";
    }

    protected static String name(double scale, double xshift, double yshift, String extraText) {
        if (yshift == 0.0) {
            return extraText + "S(" + xshift + " pixels) scale=" + scale + "p";
        }
        return extraText + "S(" + xshift + ", " + yshift + " pixels) scale=" + scale + "p";
    }

    protected double[] params(int filternumber) {
        double[] r = new double[2];
        for (int scale = 0; scale < this.scales.length; ++scale) {
            for (int xshift = 0; xshift < this.xshifts.length; ++xshift) {
                if (filternumber-- > 0) continue;
                r[1] = this.xshifts[xshift];
                r[0] = this.scales[scale];
                return r;
            }
        }
        System.err.println("Incorrect featurenumber");
        return null;
    }

    public Feature filter(int filternumber, float[] left_image, float[] right_image, int width, String extraText) {
        Feature f = null;
        double[] params = this.params(filternumber);
        f = StereoFilterBank.S(left_image, right_image, width, (int)params[0], params[1], 0.0, extraText);
        return f;
    }

    public Feature depth(float[] left_image, float[] right_image, int width, String extraText) throws Exception {
        Feature f = null;
        f = StereoFilterBank.D(left_image, right_image, width, this.scales[0], this.xshifts, extraText);
        return f;
    }

    public static Feature S(float[] image_left, float[] image_right, int width, double scale, double xshift, double yshift, String extraText) {
        Feature f = null;
        float[] shifted = Transformer.quick(image_right, width, (int)Math.round(xshift), 0);
        float[] delta = BIJmatrix.sub(image_left, shifted);
        if (scale > 0.0) {
            GaussianDerivative k0 = new GaussianDerivative(scale, 0);
            delta = Convolver.convolvex(delta, width, delta.length / width, k0);
            delta = Convolver.convolvey(delta, width, delta.length / width, k0);
        }
        f = new Feature(StereoFilterBank.name(scale, Math.round(xshift), 0.0, extraText), delta);
        return f;
    }

    public static Feature D(float[] image_left, float[] image_right, int width, double scale, float[] xshifts, String extraText) throws Exception {
        Feature f = null;
        float[][] deltas = new float[xshifts.length][];
        if (scale > 0.0) {
            GaussianDerivative k0 = new GaussianDerivative(scale, 0);
            image_left = Convolver.convolvex(image_left, width, image_left.length / width, k0);
            image_left = Convolver.convolvey(image_left, width, image_left.length / width, k0);
            image_right = Convolver.convolvex(image_right, width, image_right.length / width, k0);
            image_right = Convolver.convolvey(image_right, width, image_right.length / width, k0);
        }
        for (int s = 0; s < xshifts.length; ++s) {
            float[] params = new float[]{xshifts[s], 0.0f};
            float[] shifted_right = Transformer.transform(image_right, width, params);
            deltas[s] = BIJmatrix.sub(image_left, shifted_right);
            BIJmatrix.pow(deltas[s], deltas[s], 2.0);
        }
        ImageStack is = BIJutil.imageStackFromMatrix(deltas, width);
        ImagePlus newimp = new ImagePlus("deltas", is);
        FileSaver fs = new FileSaver(newimp);
        fs.saveAsTiffStack("G:\\stereo disk data" + System.getProperty("file.separator") + newimp.getTitle() + ".tiff");
        float[][] transpose_deltas = BIJmatrix.transpose(deltas);
        int binning = 1;
        float[] depthmap = StereoFilterBank.linzeros(transpose_deltas, xshifts, width, binning);
        f = new Feature(StereoFilterBank.toString(extraText), depthmap);
        return f;
    }

    public static float[] linzeros(float[][] mys, float[] yxs, int width, int binning) {
        float[] map = new float[mys.length];
        for (int y = 0; y < mys.length / width; y += binning) {
            for (int x = 0; x < width; x += binning) {
                float[] xs = null;
                float[] ys = null;
                for (int j = 0; j < binning; ++j) {
                    for (int i = 0; i < binning; ++i) {
                        xs = BIJmatrix.concat(xs, yxs);
                        ys = BIJmatrix.concat(ys, mys[(y + j) * width + x + i]);
                    }
                }
                DesignMatrixLinear dm = new DesignMatrixLinear(xs);
                float[] params = GeneralLinearLeastSquares.fit(ys, (DesignMatrix)dm);
                double a = params[0];
                double b = params[1];
                float zerocrossing = 0.0f;
                if (b != 0.0) {
                    zerocrossing = (float)(-a / b);
                }
                for (int j = 0; j < binning; ++j) {
                    for (int i = 0; i < binning; ++i) {
                        map[(y + j) * width + x + i] = zerocrossing;
                    }
                }
            }
        }
        return map;
    }

    public static float[] linzerosOld(float[][] mys, float[] yxs, int width, int binning) {
        float[] map = new float[mys.length];
        for (int y = 0; y < mys.length / width; y += binning) {
            for (int x = 0; x < width; x += binning) {
                float[] xs = null;
                float[] ys = null;
                for (int j = 0; j < binning; ++j) {
                    for (int i = 0; i < binning; ++i) {
                        xs = BIJmatrix.concat(xs, yxs);
                        ys = BIJmatrix.concat(ys, mys[(y + j) * width + x + i]);
                    }
                }
                double[] params = BIJfit.linear(xs, ys);
                double a = params[0];
                double b = params[1];
                float zerocrossing = 0.0f;
                if (b != 0.0) {
                    zerocrossing = (float)(-a / b);
                }
                for (int j = 0; j < binning; ++j) {
                    for (int i = 0; i < binning; ++i) {
                        map[(y + j) * width + x + i] = zerocrossing;
                    }
                }
            }
        }
        return map;
    }
}

