/*
 * Decompiled with CFR 0.152.
 */
package registration;

import ij.IJ;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.Vector;
import registration.LocatedCircle;

public class HoughTransform {
    protected int width;
    protected int height;
    protected float[] values;
    protected int xoffset;
    protected int yoffset;
    protected double radius;
    protected double maxvalue;
    public double threshold;

    public HoughTransform(int width, int height, double threshold) {
        this.xoffset = 0;
        this.yoffset = 0;
        this.width = width;
        this.height = height;
        this.threshold = threshold;
        this.maxvalue = -1.7976931348623157E308;
    }

    public HoughTransform(Rectangle roi, double threshold) {
        this.xoffset = roi.x;
        this.yoffset = roi.y;
        this.width = roi.width;
        this.height = roi.height;
        this.threshold = threshold;
        this.maxvalue = -1.7976931348623157E308;
    }

    public void circleTransform(float[] image, int imagewidth, double radius) {
        this.radius = radius;
        int amax = (int)Math.round(8.0 * radius);
        int[][] a = new int[amax][2];
        int i = 0;
        for (int j = 0; j < a.length; ++j) {
            double theta = Math.PI * 2 * (double)j / (double)a.length;
            int rhoj = (int)Math.round(radius * Math.cos(theta));
            int thetaj = (int)Math.round(radius * Math.sin(theta));
            if (i != 0 && (rhoj == a[i][0] || thetaj == a[i][1])) continue;
            a[i][0] = rhoj;
            a[i][1] = thetaj;
            ++i;
        }
        amax = i;
        this.compute(a, image, imagewidth);
    }

    public static float[] line(float[] image, int width, int distanceBins, int thetaBins) {
        int height = image.length / width;
        float[] a = new float[thetaBins * distanceBins];
        double thetaStep = Math.PI / (double)thetaBins;
        double rStep = Math.max(width, height) / distanceBins;
        for (int y = 0; y < height; ++y) {
            IJ.showStatus((String)("Hough: " + y));
            for (int x = 0; x < width; ++x) {
                double d = image[y * width + x];
                if (d <= 0.0) continue;
                double dx = (double)x - (double)width / 2.0;
                double dy = (double)y - (double)height / 2.0;
                for (int tix = 0; tix < thetaBins; ++tix) {
                    int rix;
                    double theta = (double)tix * thetaStep;
                    double r = dx * Math.cos(theta) + dy * Math.sin(theta);
                    if (r < 0.0) {
                        r = -r;
                        theta += Math.PI;
                    }
                    if ((rix = (int)Math.round(r / rStep)) >= distanceBins) {
                        IJ.log((String)("Error in line Hough rix " + rix + " theta" + theta + " ix" + tix + " x=" + x + "y=" + y));
                    }
                    int n = tix * distanceBins + rix;
                    a[n] = a[n] + 1.0f;
                }
            }
        }
        return a;
    }

    protected void compute(int[][] a, float[] pixels, int pixelswidth) {
        this.values = new float[this.height * this.width];
        double maxd = -1.7976931348623157E308;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                double d = pixels[(y + this.yoffset) * pixelswidth + (x + this.xoffset)];
                if (d <= this.threshold) continue;
                for (int i = 0; i < a.length; ++i) {
                    int centerj = y + a[i][0];
                    int centeri = x + a[i][1];
                    if (centerj < 0 || centerj >= this.height || centeri < 0 || centeri >= this.width) continue;
                    int n = centerj * this.width + centeri;
                    this.values[n] = this.values[n] + 1.0f;
                    if (!((double)this.values[centerj * this.width + centeri] > this.maxvalue)) continue;
                    this.maxvalue = this.values[centerj * this.width + centeri];
                }
            }
        }
        this.maxvalue = maxd * (double)a.length;
    }

    public float[] getValues() {
        return this.values;
    }

    public float[] getCenter() {
        int bestx = 0;
        int besty = 0;
        double max = -1.7976931348623157E308;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!((double)this.values[y * this.width + x] / this.maxvalue > max)) continue;
                max = (double)this.values[y * this.width + x] / this.maxvalue;
                bestx = x;
                besty = y;
            }
        }
        float[] result = new float[]{bestx, besty};
        return result;
    }

    public Vector getCircles(int maxc, double scale) {
        float[] copy = (float[])this.values.clone();
        Vector<LocatedCircle> centers = new Vector<LocatedCircle>();
        double maxd = -1.7976931348623157E308;
        double lastmaxd = 0.0;
        for (int c = 0; c < maxc; ++c) {
            lastmaxd = maxd;
            maxd = -1.7976931348623157E308;
            int maxdx = 0;
            int maxdy = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (!((double)copy[y * this.width + x] > maxd)) continue;
                    maxd = copy[y * this.width + x];
                    maxdx = x;
                    maxdy = y;
                }
            }
            if (maxd < lastmaxd / 2.0) break;
            double confidence = maxd / this.maxvalue;
            LocatedCircle hc = new LocatedCircle(maxdx, maxdy, this.radius, confidence);
            centers.addElement(hc);
            int annihRadius = (int)Math.max(Math.round(scale), 2L);
            for (int y = maxdy - annihRadius; y < maxdy + annihRadius; ++y) {
                for (int x = maxdx - annihRadius; x < maxdx + annihRadius; ++x) {
                    if (x < 0 || x >= this.width || y < 0 || y >= this.height) continue;
                    copy[y * this.width + x] = 0.0f;
                }
            }
        }
        return centers;
    }

    public LocatedCircle getLargestCircle(float[] image, int imagewidth, int imageheight) {
        double radius;
        double minRadius = Math.min(this.width, this.height) / 2 - 30;
        double maxRadius = Math.min(this.width, this.height) / 2 + 30;
        int bestCenterx = 0;
        int bestCentery = 0;
        double max = -1.7976931348623157E308;
        for (radius = minRadius; radius < maxRadius; radius += 5.0) {
            IJ.showStatus((String)("Fitting circle " + 100.0 * (radius - minRadius) / (maxRadius - minRadius) + "%"));
            this.circleTransform(image, imagewidth, radius);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (!((double)this.values[y * this.width + x] > max)) continue;
                    max = this.values[y * this.width + x];
                    bestCenterx = x;
                    bestCentery = y;
                }
            }
        }
        LocatedCircle hc = new LocatedCircle(bestCenterx, bestCentery, radius, max);
        return hc;
    }

    public LocatedCircle getCircle(float[] image, int imagewidth, int imageheight, float radius) {
        int bestCenterx = 0;
        int bestCentery = 0;
        double max = -1.7976931348623157E308;
        IJ.showStatus((String)"Fitting circle...");
        this.circleTransform(image, imagewidth, radius);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!((double)this.values[y * this.width + x] > max)) continue;
                max = this.values[y * this.width + x];
                bestCenterx = x;
                bestCentery = y;
            }
        }
        LocatedCircle hc = new LocatedCircle(bestCenterx, bestCentery, radius, max);
        return hc;
    }

    public ImageProcessor getImageProcessor() {
        if (this.values == null) {
            return null;
        }
        return new FloatProcessor(this.width, this.height, this.values, null);
    }
}

