/*
 * Decompiled with CFR 0.152.
 */
package volume;

import java.io.Serializable;
import volume.Kernel;

public abstract class Volume
implements Serializable {
    protected int width;
    protected int height;
    protected int depth;
    protected int edge;
    protected double aspectx;
    protected double aspecty;
    protected double aspectz;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public abstract Object get(int var1, int var2, int var3);

    public abstract void set(Object var1, int var2, int var3, int var4);

    public void setAspects(double aspectx, double aspecty, double aspectz) {
        this.aspectx = aspectx;
        this.aspecty = aspecty;
        this.aspectz = aspectz;
    }

    public double getAspectx() {
        return this.aspectx;
    }

    public double getAspecty() {
        return this.aspecty;
    }

    public double getAspectz() {
        return this.aspectz;
    }

    @Deprecated
    public int getEdge() {
        return this.edge;
    }

    @Deprecated
    public void setEdge(int edge) {
        this.edge = edge;
    }

    @Deprecated
    public boolean in(double x, double y, double z) {
        return x >= (double)this.edge && x < (double)(this.width - this.edge) && y >= (double)this.edge && y < (double)(this.height - this.edge);
    }

    @Deprecated
    public boolean valid(int x, int y) {
        return x >= this.edge && x < this.width - this.edge && y >= this.edge && y < this.height - this.edge;
    }

    @Deprecated
    public boolean valid(int x, int y, int z) {
        return x >= this.edge && x < this.width - this.edge && y >= this.edge && y < this.height - this.edge && z >= this.edge && z < this.depth - this.edge;
    }

    public int discreteSupport(Kernel kernel) {
        if (kernel instanceof Kernel) {
            return Math.max(this.depth, kernel.support() + this.depth - 1);
        }
        return this.depth;
    }

    public String toString() {
        return "volume: " + this.width + "x" + this.height + "x" + this.depth + " anisotropy: " + this.aspectx + "x" + this.aspecty + "x" + this.aspectz;
    }
}

