/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.LinearInterpolator;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LinearInterpolatorTest
extends TestCase {
    private static final float R0 = 3.0f;
    private static final float R1 = 4.0f;
    private static final float R2 = 5.0f;
    private static final float R3 = 6.0f;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(LinearInterpolatorTest.class);
        TestRunner.run((Test)suite);
    }

    public void testInterpolator1() {
        float fxu;
        int nxu = 100;
        float dxu = 0.3f;
        float xmin = fxu = 3.3f;
        float xmax = fxu + (float)(nxu - 1) * dxu;
        float[] yu = new float[nxu];
        for (int ixu = 0; ixu < nxu; ++ixu) {
            yu[ixu] = LinearInterpolatorTest.ramp(fxu + (float)ixu * dxu);
        }
        LinearInterpolator li = new LinearInterpolator();
        li.setExtrapolation(LinearInterpolator.Extrapolation.CONSTANT);
        li.setUniform(nxu, dxu, fxu, yu);
        int nx = 500;
        float dx = 1.02f * (xmax - xmin) / (float)(nx - 1);
        float fx = xmin - 2.3f * dx;
        for (int ix = 0; ix < nx; ++ix) {
            float x = fx + (float)ix * dx;
            float yi = li.interpolate(x);
            float c = ArrayMath.max(xmin, ArrayMath.min(xmax, x));
            float yr = LinearInterpolatorTest.ramp(c);
            LinearInterpolatorTest.assertEquals((float)yi, (float)yr, (float)(yr * 1.0E-5f));
        }
    }

    public void testInterpolator2() {
        int nx1u = 100;
        int nx2u = 200;
        float dx1u = 0.3f;
        float dx2u = 0.4f;
        float fx1u = 3.3f;
        float fx2u = 4.3f;
        float x1min = fx1u;
        float x1max = fx1u + (float)(nx1u - 1) * dx1u;
        float x2min = fx2u;
        float x2max = fx2u + (float)(nx2u - 1) * dx2u;
        float[][] yu = new float[nx2u][nx1u];
        for (int ix2u = 0; ix2u < nx2u; ++ix2u) {
            for (int ix1u = 0; ix1u < nx1u; ++ix1u) {
                yu[ix2u][ix1u] = LinearInterpolatorTest.ramp(fx1u + (float)ix1u * dx1u, fx2u + (float)ix2u * dx2u);
            }
        }
        LinearInterpolator li = new LinearInterpolator();
        li.setExtrapolation(LinearInterpolator.Extrapolation.CONSTANT);
        li.setUniform(nx1u, dx1u, fx1u, nx2u, dx2u, fx2u, yu);
        int nx1 = 300;
        int nx2 = 400;
        float dx1 = 1.02f * (x1max - x1min) / (float)(nx1 - 1);
        float dx2 = 1.01f * (x2max - x2min) / (float)(nx2 - 1);
        float fx1 = x1min - 3.9f * dx1;
        float fx2 = x2min - 4.1f * dx2;
        for (int ix2 = 0; ix2 < nx2; ++ix2) {
            float x2 = fx2 + (float)ix2 * dx2;
            float c2 = ArrayMath.max(x2min, ArrayMath.min(x2max, x2));
            for (int ix1 = 0; ix1 < nx1; ++ix1) {
                float x1 = fx1 + (float)ix1 * dx1;
                float yi = li.interpolate(x1, x2);
                float c1 = ArrayMath.max(x1min, ArrayMath.min(x1max, x1));
                float yr = LinearInterpolatorTest.ramp(c1, c2);
                LinearInterpolatorTest.assertEquals((float)yi, (float)yr, (float)(yr * 1.0E-5f));
            }
        }
    }

    public void testInterpolator3() {
        int nx1u = 110;
        int nx2u = 220;
        int nx3u = 330;
        float dx1u = 0.3f;
        float dx2u = 0.4f;
        float dx3u = 0.5f;
        float fx1u = 3.3f;
        float fx2u = 4.3f;
        float fx3u = 5.3f;
        float x1min = fx1u;
        float x1max = fx1u + (float)(nx1u - 1) * dx1u;
        float x2min = fx2u;
        float x2max = fx2u + (float)(nx2u - 1) * dx2u;
        float x3min = fx3u;
        float x3max = fx3u + (float)(nx3u - 1) * dx3u;
        float[][][] yu = new float[nx3u][nx2u][nx1u];
        for (int ix3u = 0; ix3u < nx3u; ++ix3u) {
            for (int ix2u = 0; ix2u < nx2u; ++ix2u) {
                for (int ix1u = 0; ix1u < nx1u; ++ix1u) {
                    yu[ix3u][ix2u][ix1u] = LinearInterpolatorTest.ramp(fx1u + (float)ix1u * dx1u, fx2u + (float)ix2u * dx2u, fx3u + (float)ix3u * dx3u);
                }
            }
        }
        LinearInterpolator li = new LinearInterpolator();
        li.setExtrapolation(LinearInterpolator.Extrapolation.CONSTANT);
        li.setUniform(nx1u, dx1u, fx1u, nx2u, dx2u, fx2u, nx3u, dx3u, fx3u, yu);
        int nx1 = 30;
        int nx2 = 40;
        int nx3 = 20;
        float dx1 = 1.1f * (x1max - x1min) / (float)(nx1 - 1);
        float dx2 = 1.2f * (x2max - x2min) / (float)(nx2 - 1);
        float dx3 = 1.3f * (x3max - x3min) / (float)(nx3 - 1);
        float fx1 = x1min - 3.3f * dx1;
        float fx2 = x2min - 2.3f * dx2;
        float fx3 = x3min - 4.3f * dx3;
        for (int ix3 = 0; ix3 < nx3; ++ix3) {
            float x3 = fx3 + (float)ix3 * dx3;
            float c3 = ArrayMath.max(x3min, ArrayMath.min(x3max, x3));
            for (int ix2 = 0; ix2 < nx2; ++ix2) {
                float x2 = fx2 + (float)ix2 * dx2;
                float c2 = ArrayMath.max(x2min, ArrayMath.min(x2max, x2));
                for (int ix1 = 0; ix1 < nx1; ++ix1) {
                    float x1 = fx1 + (float)ix1 * dx1;
                    float c1 = ArrayMath.max(x1min, ArrayMath.min(x1max, x1));
                    float yi = li.interpolate(x1, x2, x3);
                    float yr = LinearInterpolatorTest.ramp(c1, c2, c3);
                    LinearInterpolatorTest.assertEquals((float)yi, (float)yr, (float)(yr * 1.0E-5f));
                }
            }
        }
    }

    public void testInterpolator1Zero() {
        float[] yu = new float[]{1.0f};
        LinearInterpolator li = new LinearInterpolator();
        li.setExtrapolation(LinearInterpolator.Extrapolation.ZERO);
        li.setUniform(1, 2.0, 0.0, yu);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(-2.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(-1.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)1.0, (double)li.interpolate(0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(1.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(2.0), (double)0.0);
    }

    public void testInterpolator2Zero() {
        float[][] yu = new float[][]{{1.0f}};
        LinearInterpolator li = new LinearInterpolator();
        li.setExtrapolation(LinearInterpolator.Extrapolation.ZERO);
        li.setUniform(1, 2.0, 0.0, 1, 1.0, 0.0, yu);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(-2.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(-1.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)1.0, (double)li.interpolate(0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(1.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(2.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(0.0, -1.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(0.0, -0.5), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)1.0, (double)li.interpolate(0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(0.0, 0.5), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(0.0, 1.0), (double)0.0);
    }

    public void testInterpolator3Zero() {
        float[][][] yu = new float[][][]{new float[][]{{1.0f}}};
        LinearInterpolator li = new LinearInterpolator();
        li.setExtrapolation(LinearInterpolator.Extrapolation.ZERO);
        li.setUniform(1, 2.0, 0.0, 1, 1.0, 0.0, 1, 4.0, 0.0, yu);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(-2.0, 0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(-1.0, 0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)1.0, (double)li.interpolate(0.0, 0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(1.0, 0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(2.0, 0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(0.0, -1.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(0.0, -0.5, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)1.0, (double)li.interpolate(0.0, 0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(0.0, 0.5, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(0.0, 1.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(0.0, 0.0, -4.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(0.0, 0.0, -2.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)1.0, (double)li.interpolate(0.0, 0.0, 0.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.5, (double)li.interpolate(0.0, 0.0, 2.0), (double)0.0);
        LinearInterpolatorTest.assertEquals((double)0.0, (double)li.interpolate(0.0, 0.0, 4.0), (double)0.0);
    }

    private static float ramp(float x1) {
        return 3.0f + 4.0f * x1;
    }

    private static float ramp(float x1, float x2) {
        return 3.0f + 4.0f * x1 + 5.0f * x2;
    }

    private static float ramp(float x1, float x2, float x3) {
        return 3.0f + 4.0f * x1 + 5.0f * x2 + 6.0f * x3;
    }

    private static void trace(String s) {
    }
}

