/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.BilinearInterpolator2;
import edu.mines.jtk.util.ArrayMath;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BilinearInterpolator2Test
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(BilinearInterpolator2Test.class);
        TestRunner.run((Test)suite);
    }

    public void testSingleValues() {
        float[][][] xy = BilinearInterpolator2Test.sampleTestFunction(11, 12);
        float[] x1 = xy[0][0];
        float[] x2 = xy[0][1];
        float[][] y = xy[1];
        float x1min = ArrayMath.min(x1);
        float x1max = ArrayMath.max(x1);
        float x1del = x1max - x1min;
        float x2min = ArrayMath.min(x2);
        float x2max = ArrayMath.max(x2);
        float x2del = x2max - x2min;
        x1min -= 0.2f * x1del;
        x1max += 0.2f * x1del;
        x2min -= 0.2f * x2del;
        x2max += 0.2f * x2del;
        BilinearInterpolator2 bi = BilinearInterpolator2Test.makeInterpolator(x1, x2, y);
        int n = 101;
        Random r = new Random(5L);
        for (int i = 0; i < n; ++i) {
            float x1i = x1min + (x1max - x1min) * r.nextFloat();
            float x2i = x2min + (x2max - x2min) * r.nextFloat();
            float y00 = bi.interpolate00(x1i, x2i);
            float y10 = bi.interpolate10(x1i, x2i);
            float y01 = bi.interpolate01(x1i, x2i);
            BilinearInterpolator2Test.assertEqual(BilinearInterpolator2Test.testFunction00(x1i, x2i), y00);
            BilinearInterpolator2Test.assertEqual(BilinearInterpolator2Test.testFunction10(x1i, x2i), y10);
            BilinearInterpolator2Test.assertEqual(BilinearInterpolator2Test.testFunction01(x1i, x2i), y01);
        }
    }

    public void testArrayValues() {
        float[][][] xy = BilinearInterpolator2Test.sampleTestFunction(11, 13);
        float[] x1 = xy[0][0];
        float[] x2 = xy[0][1];
        float[][] y = xy[1];
        float x1min = ArrayMath.min(x1);
        float x1max = ArrayMath.max(x1);
        float x2min = ArrayMath.min(x2);
        float x2max = ArrayMath.max(x2);
        BilinearInterpolator2 bi = BilinearInterpolator2Test.makeInterpolator(x1, x2, y);
        int n1i = 101;
        int n2i = 102;
        float d1i = (x1max - x1min) / (float)(n1i - 1);
        float d2i = (x2max - x2min) / (float)(n2i - 1);
        float f1i = x1min;
        float f2i = x2min;
        float[] x1i = ArrayMath.rampfloat(f1i, d1i, n1i);
        float[] x2i = ArrayMath.rampfloat(f2i, d2i, n2i);
        float[][] yi = bi.interpolate(x1i, x2i);
        for (int i2i = 0; i2i < n2i; ++i2i) {
            for (int i1i = 0; i1i < n1i; ++i1i) {
                BilinearInterpolator2Test.assertEqual(BilinearInterpolator2Test.testFunction00(x1i[i1i], x2i[i2i]), yi[i2i][i1i]);
            }
        }
    }

    public void testSampleValues() {
        float[][][] xy = BilinearInterpolator2Test.sampleTestFunction(11, 13);
        float[] x1 = xy[0][0];
        float[] x2 = xy[0][1];
        float[][] y = xy[1];
        float x1min = ArrayMath.min(x1);
        float x1max = ArrayMath.max(x1);
        float x2min = ArrayMath.min(x2);
        float x2max = ArrayMath.max(x2);
        BilinearInterpolator2 bi = BilinearInterpolator2Test.makeInterpolator(x1, x2, y);
        int n1i = 101;
        int n2i = 102;
        float d1i = (x1max - x1min) / (float)(n1i - 1);
        float d2i = (x2max - x2min) / (float)(n2i - 1);
        float f1i = x1min;
        float f2i = x2min;
        Sampling s1i = new Sampling(n1i, d1i, f1i);
        Sampling s2i = new Sampling(n2i, d2i, f2i);
        float[][] yi = bi.interpolate(s1i, s2i);
        for (int i2i = 0; i2i < n2i; ++i2i) {
            float x2i = (float)s2i.getValue(i2i);
            for (int i1i = 0; i1i < n1i; ++i1i) {
                float x1i = (float)s1i.getValue(i1i);
                BilinearInterpolator2Test.assertEqual(BilinearInterpolator2Test.testFunction00(x1i, x2i), yi[i2i][i1i]);
            }
        }
    }

    private static BilinearInterpolator2 makeInterpolator(float[] x1, float[] x2, float[][] y) {
        return new BilinearInterpolator2(x1, x2, y);
    }

    private static float[][][] sampleTestFunction(int n1, int n2) {
        Random r = new Random(3L);
        float[] x1 = ArrayMath.mul(2.0f, ArrayMath.randfloat(r, n1));
        float[] x2 = ArrayMath.mul(2.0f, ArrayMath.randfloat(r, n2));
        ArrayMath.quickSort(x1);
        ArrayMath.quickSort(x2);
        float[][] y = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                y[i2][i1] = BilinearInterpolator2Test.testFunction00(x1[i1], x2[i2]);
            }
        }
        return new float[][][]{new float[][]{x1, x2}, y};
    }

    private static float testFunction00(float x1, float x2) {
        return (1.1f + 1.3f * x1) * (1.2f + 1.4f * x2);
    }

    private static float testFunction10(float x1, float x2) {
        return 1.3f * (1.2f + 1.4f * x2);
    }

    private static float testFunction01(float x1, float x2) {
        return 1.4f * (1.1f + 1.3f * x1);
    }

    private static void assertEqual(float x, float y) {
        BilinearInterpolator2Test.assertTrue((String)(x + " = " + y), (boolean)BilinearInterpolator2Test.almostEqual(x, y));
    }

    private static boolean almostEqual(float x, float y) {
        float ax = ArrayMath.abs(x);
        float ay = ArrayMath.abs(y);
        return ArrayMath.abs(x - y) <= 0.001f * ArrayMath.max(ax, ay);
    }
}

