/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.Gridder2;

public class SimpleGridder2
implements Gridder2 {
    private int _n;
    private float _fnull;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;

    public SimpleGridder2(float[] f, float[] x1, float[] x2) {
        this.setScattered(f, x1, x2);
    }

    public void setNullValue(float fnull) {
        this._fnull = fnull;
    }

    public static float[][] samplesOnGrid(Sampling s1, Sampling s2, float[] f, float[] x1, float[] x2) {
        float[][] fxs = SimpleGridder2.samplesOnGrid(s1, s2, f, x1, x2, null);
        return new float[][]{fxs[0], fxs[1], fxs[2]};
    }

    public static float[][] samplesOnGrid(Sampling s1, Sampling s2, float[] f, float[] x1, float[] x2, float[] sd) {
        int i2;
        int n = f.length;
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        double d1 = s1.getDelta();
        double d2 = s2.getDelta();
        double f1 = s1.getFirst();
        double f2 = s2.getFirst();
        double l1 = s1.getLast();
        double l2 = s2.getLast();
        f1 -= 0.5 * d1;
        l1 += 0.5 * d1;
        f2 -= 0.5 * d2;
        l2 += 0.5 * d2;
        boolean[][] ez = null;
        if (sd != null) {
            ez = new boolean[n2][n1];
            for (int i = 0; i < n; ++i) {
                if (sd[i] != 0.0f) continue;
                double x1i = x1[i];
                double x2i = x2[i];
                if (!(f1 <= x1i) || !(x1i <= l1) || !(f2 <= x2i) || !(x2i <= l2)) continue;
                int i1 = s1.indexOfNearest(x1i);
                int i22 = s2.indexOfNearest(x2i);
                ez[i22][i1] = true;
            }
        }
        float[][] g = new float[n2][n1];
        float[][] w = new float[n2][n1];
        for (int i = 0; i < n; ++i) {
            double x1i = x1[i];
            double x2i = x2[i];
            if (!(f1 <= x1i) || !(x1i <= l1) || !(f2 <= x2i) || !(x2i <= l2)) continue;
            int i1 = s1.indexOfNearest(x1i);
            int i23 = s2.indexOfNearest(x2i);
            if (sd == null || ez[i23][i1] && sd[i] == 0.0f) {
                float[] fArray = g[i23];
                int n3 = i1;
                fArray[n3] = fArray[n3] + f[i];
                float[] fArray2 = w[i23];
                int n4 = i1;
                fArray2[n4] = fArray2[n4] + 1.0f;
                continue;
            }
            if (ez[i23][i1]) continue;
            float wi = 1.0f / (sd[i] * sd[i]);
            float[] fArray = g[i23];
            int n5 = i1;
            fArray[n5] = fArray[n5] + wi * f[i];
            float[] fArray3 = w[i23];
            int n6 = i1;
            fArray3[n6] = fArray3[n6] + wi;
        }
        n = 0;
        for (i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                if (!(w[i2][i1] > 0.0f)) continue;
                ++n;
            }
        }
        f = new float[n];
        x1 = new float[n];
        x2 = new float[n];
        if (sd != null) {
            sd = new float[n];
        }
        int i = 0;
        for (i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                if (!(w[i2][i1] > 0.0f)) continue;
                f[i] = g[i2][i1] / w[i2][i1];
                x1[i] = (float)s1.getValue(i1);
                x2[i] = (float)s2.getValue(i2);
                if (sd != null) {
                    sd[i] = ez[i2][i1] ? 0.0f : 1.0f / (float)Math.sqrt(w[i2][i1]);
                }
                ++i;
            }
        }
        return new float[][]{f, x1, x2, sd};
    }

    public static float[][] getGriddedSamples(float fnull, Sampling s1, Sampling s2, float[][] g) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                if (g[i2][i1] == fnull) continue;
                ++n;
            }
        }
        float[] f = new float[n];
        float[] x1 = new float[n];
        float[] x2 = new float[n];
        int i = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2i = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1i;
                if (g[i2][i1] == fnull) continue;
                x1[i] = x1i = (float)s1.getValue(i1);
                x2[i] = x2i;
                f[i] = g[i2][i1];
                ++i;
            }
        }
        return new float[][]{f, x1, x2};
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2) {
        this._n = f.length;
        this._f = f;
        this._x1 = x1;
        this._x2 = x2;
    }

    @Override
    public float[][] grid(Sampling s1, Sampling s2) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        double d1 = s1.getDelta();
        double d2 = s2.getDelta();
        double f1 = s1.getFirst();
        double f2 = s2.getFirst();
        double l1 = s1.getLast();
        double l2 = s2.getLast();
        f1 -= 0.5 * d1;
        l1 += 0.5 * d1;
        f2 -= 0.5 * d2;
        l2 += 0.5 * d2;
        float[][] g = new float[n2][n1];
        float[][] c = new float[n2][n1];
        for (int i = 0; i < this._n; ++i) {
            double x1 = this._x1[i];
            double x2 = this._x2[i];
            if (!(f1 <= x1) || !(x1 <= l1) || !(f2 <= x2) || !(x2 <= l2)) continue;
            int i1 = s1.indexOfNearest(x1);
            int i2 = s2.indexOfNearest(x2);
            float[] fArray = g[i2];
            int n = i1;
            fArray[n] = fArray[n] + this._f[i];
            float[] fArray2 = c[i2];
            int n3 = i1;
            fArray2[n3] = fArray2[n3] + 1.0f;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                g[i2][i1] = c[i2][i1] > 0.0f ? g[i2][i1] / c[i2][i1] : this._fnull;
            }
        }
        return g;
    }
}

