/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ArrayVect1f;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

public class ArrayVect1fs
implements Vect {
    static final long serialVersionUID = 1L;
    protected ArrayVect1f[] _data = null;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");

    public ArrayVect1fs(ArrayVect1f[] data) {
        this.init(data);
    }

    public ArrayVect1fs() {
    }

    private void init(ArrayVect1f[] data) {
        this._data = data;
    }

    public int getSize() {
        return this._data.length;
    }

    public ArrayVect1f[] getData() {
        return this._data;
    }

    @Override
    public ArrayVect1fs clone() {
        try {
            ArrayVect1fs result = (ArrayVect1fs)super.clone();
            if (this._data != null) {
                ArrayVect1f[] data = (ArrayVect1f[])this._data.clone();
                for (int i = 0; i < data.length; ++i) {
                    data[i] = data[i].clone();
                }
                result.init(data);
            }
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public double dot(VectConst other) {
        double result = 0.0;
        ArrayVect1fs rhs = (ArrayVect1fs)other;
        for (int i = 0; i < this._data.length; ++i) {
            result += this._data[i].dot(rhs._data[i]);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this._data.length; ++i) {
            sb.append(String.valueOf(this._data[i]));
            if (i >= this._data.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void dispose() {
        for (ArrayVect1f a_data : this._data) {
            a_data.dispose();
        }
        this._data = null;
    }

    @Override
    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize(), 0.0);
        for (ArrayVect1f a_data : this._data) {
            a_data.multiplyInverseCovariance();
            VectUtil.scale(a_data, scale);
        }
    }

    @Override
    public void constrain() {
        for (ArrayVect1f a_data : this._data) {
            a_data.constrain();
        }
    }

    @Override
    public void postCondition() {
    }

    @Override
    public void add(double scaleThis, double scaleOther, VectConst other) {
        ArrayVect1fs rhs = (ArrayVect1fs)other;
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i].add(scaleThis, scaleOther, rhs._data[i]);
        }
    }

    @Override
    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    @Override
    public double magnitude() {
        double result = 0.0;
        for (ArrayVect1f a_data : this._data) {
            result += a_data.magnitude();
        }
        result = Almost.FLOAT.divide(result, (double)this.getSize(), 0.0);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._data.length);
        for (ArrayVect1f a_data : this._data) {
            out.writeObject(a_data);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this._data = new ArrayVect1f[length];
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (ArrayVect1f)in.readObject();
        }
    }
}

