/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ArrayVect3f
implements Vect {
    protected transient float[][][] _data = null;
    protected transient double _variance = 1.0;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;

    public ArrayVect3f(float[][][] data, double variance) {
        this.init(data, variance);
    }

    public double getVariance() {
        return this._variance;
    }

    protected ArrayVect3f() {
    }

    protected final void init(float[][][] data, double variance) {
        this._data = data;
        this._variance = variance;
    }

    public float[][][] getData() {
        return this._data;
    }

    public int getSize() {
        return this._data.length * this._data[0].length * this._data[0][0].length;
    }

    @Override
    public void add(double scaleThis, double scaleOther, VectConst other) {
        float s1 = (float)scaleThis;
        float s2 = (float)scaleOther;
        ArrayVect3f rhs = (ArrayVect3f)other;
        for (int i = 0; i < this._data.length; ++i) {
            for (int j = 0; j < this._data[0].length; ++j) {
                for (int k = 0; k < this._data[0][0].length; ++k) {
                    this._data[i][j][k] = s1 * this._data[i][j][k] + s2 * rhs._data[i][j][k];
                }
            }
        }
    }

    @Override
    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    @Override
    public void dispose() {
        this._data = null;
    }

    @Override
    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize() * this._variance, 0.0);
        VectUtil.scale(this, scale);
    }

    @Override
    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), (double)this.getSize() * this._variance, 0.0);
    }

    @Override
    public void constrain() {
    }

    @Override
    public void postCondition() {
    }

    @Override
    public ArrayVect3f clone() {
        try {
            float[][][] newData = new float[this._data.length][this._data[0].length][];
            for (int i = 0; i < newData.length; ++i) {
                for (int j = 0; j < newData[0].length; ++j) {
                    newData[i][j] = (float[])this._data[i][j].clone();
                }
            }
            ArrayVect3f result = (ArrayVect3f)super.clone();
            result.init(newData, this._variance);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public double dot(VectConst other) {
        double result = 0.0;
        ArrayVect3f rhs = (ArrayVect3f)other;
        for (int i = 0; i < this._data.length; ++i) {
            for (int j = 0; j < this._data[0].length; ++j) {
                for (int k = 0; k < this._data[0][0].length; ++k) {
                    result += (double)this._data[i][j][k] * (double)rhs._data[i][j][k];
                }
            }
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", this._data);
        map.put("variance", this._variance);
        map.put("VERSION", 1);
        out.writeObject(map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Map map = (Map)in.readObject();
        this._data = (float[][][])map.get("data");
        this._variance = (Double)map.get("variance");
        int version = (Integer)map.get("VERSION");
        if (version != 1) {
            Logger.getLogger(this.getClass().getName()).warning("Need to convert data from version " + version + " to " + 1);
        }
    }
}

