/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ArrayVect1;
import edu.mines.jtk.opt.GaussNewtonSolver;
import edu.mines.jtk.opt.LinearTransform;
import edu.mines.jtk.opt.LinearTransformWrapper;
import edu.mines.jtk.opt.QuadraticSolver;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GaussNewtonSolverTest
extends TestCase {
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static boolean printedUndisposed = false;
    private static boolean projectWasTested = false;
    private static final String NL = System.getProperty("line.separator");

    public void testMain() throws Exception {
        GaussNewtonSolver.setExpensiveDebug(true);
        final double[] coord = new double[]{0.0, 1.0, 3.0, 4.0};
        TestVect data = new TestVect(new double[]{0.0, 8.0, 8.0, 20.0}, 1.0E-4, "data");
        LinearTransform linearTransform = new LinearTransform(){

            @Override
            public void forward(Vect data1, VectConst model) {
                VectUtil.zero(data1);
                double[] d = ((ArrayVect1)data1).getData();
                double[] m = ((ArrayVect1)model).getData();
                for (int i = 0; i < coord.length; ++i) {
                    int n = i;
                    d[n] = d[n] + m[0];
                    int n2 = i;
                    d[n2] = d[n2] + coord[i] * m[1];
                }
            }

            @Override
            public void addTranspose(VectConst data1, Vect model) {
                double[] d = ((ArrayVect1)data1).getData();
                double[] m = ((ArrayVect1)model).getData();
                for (int i = 0; i < coord.length; ++i) {
                    m[0] = m[0] + d[i];
                    m[1] = m[1] + coord[i] * d[i];
                }
            }

            @Override
            public void inverseHessian(Vect model) {
            }

            @Override
            public void adjustRobustErrors(Vect dataError) {
            }
        };
        TestVect model = new TestVect(new double[]{-1.0, -1.0}, 1.0, "model");
        boolean dampOnlyPerturbation = false;
        int conjugateGradIterations = 2;
        ArrayVect1 result = (ArrayVect1)QuadraticSolver.solve(data, model, linearTransform, dampOnlyPerturbation, conjugateGradIterations, null);
        LOG.fine("data = " + data);
        LOG.fine("model = " + model);
        LOG.fine("result = " + result);
        assert (new Almost(4).equal(1.0, result.getData()[0])) : "result=" + result;
        assert (new Almost(5).equal(4.0, result.getData()[1])) : "result=" + result;
        model.dispose();
        result.dispose();
        double[] dampPerturb = null;
        TestVect model2 = new TestVect(new double[]{0.9, 3.9}, 1.0, "model");
        boolean dampOnlyPerturbation2 = true;
        int conjugateGradIterations2 = 2;
        ArrayVect1 result2 = (ArrayVect1)QuadraticSolver.solve(data, model2, linearTransform, dampOnlyPerturbation2, conjugateGradIterations2, null);
        LOG.fine("data = " + data);
        LOG.fine("model = " + model2);
        LOG.fine("result = " + result2);
        dampPerturb = result2.getData();
        assert (new Almost(4).equal(1.0, result2.getData()[0])) : "result=" + result2;
        assert (new Almost(5).equal(4.0, result2.getData()[1])) : "result=" + result2;
        model2.dispose();
        result2.dispose();
        model2 = new TestVect(new double[]{0.9, 3.9}, 1.0, "model");
        dampOnlyPerturbation2 = false;
        conjugateGradIterations2 = 2;
        result2 = (ArrayVect1)QuadraticSolver.solve(data, model2, linearTransform, dampOnlyPerturbation2, conjugateGradIterations2, null);
        LOG.fine("data = " + data);
        LOG.fine("model = " + model2);
        LOG.fine("result = " + result2);
        double[] dampAll = result2.getData();
        assert (new Almost(4).equal(1.0, result2.getData()[0])) : "result=" + result2;
        assert (new Almost(5).equal(4.0, result2.getData()[1])) : "result=" + result2;
        assert (dampAll[0] > dampPerturb[0]);
        assert (dampAll[1] < dampPerturb[1]);
        double dampAll2 = 0.0;
        double dampPerturb2 = 0.0;
        for (int i = 0; i < 2; ++i) {
            dampAll2 += dampAll[i] * dampAll[i];
            dampPerturb2 += dampPerturb[i] * dampPerturb[i];
        }
        LOG.fine("dampAll2=" + dampAll2 + " dampPerturb2=" + dampPerturb2);
        assert (dampAll2 < dampPerturb2);
        model2.dispose();
        result2.dispose();
        assert (TestVect.max <= 10) : "max=" + TestVect.max;
        for (int twice = 0; twice < 2; ++twice) {
            boolean project = twice == 1;
            TestVect perturb = new TestVect(new double[2], 1.0, "perturb");
            TestVect model3 = new TestVect(new double[]{0.9, 3.9}, 1.0, "model");
            boolean dampOnlyPerturbation3 = false;
            int linearizationIterations = 3;
            int lineSearchIterations = 20;
            double lineSearchError = 1.0E-6;
            int conjugateGradIterations3 = 1;
            LinearTransformWrapper transform = new LinearTransformWrapper(linearTransform);
            ArrayVect1 result3 = (ArrayVect1)GaussNewtonSolver.solve(data, model3, project ? perturb : null, transform, dampOnlyPerturbation3, conjugateGradIterations3, lineSearchIterations, linearizationIterations, lineSearchError, null);
            LOG.fine("data = " + data);
            LOG.fine("model = " + model3);
            LOG.fine("result = " + result3);
            assert (new Almost(3).equal(1.0, result3.getData()[0])) : "result=" + result3;
            assert (new Almost(4).equal(4.0, result3.getData()[1])) : "result=" + result3;
            model3.dispose();
            result3.dispose();
            model3 = new TestVect(new double[]{0.9, 3.9}, 1.0, "model");
            dampOnlyPerturbation3 = true;
            linearizationIterations = 3;
            lineSearchIterations = 30;
            lineSearchError = 1.0E-6;
            conjugateGradIterations3 = 2;
            transform = new LinearTransformWrapper(linearTransform);
            result3 = (ArrayVect1)GaussNewtonSolver.solve(data, model3, project ? perturb : null, transform, dampOnlyPerturbation3, conjugateGradIterations3, lineSearchIterations, linearizationIterations, lineSearchError, null);
            LOG.fine("data = " + data);
            LOG.fine("model = " + model3);
            LOG.fine("result = " + result3);
            assert (new Almost(4).equal(1.0, result3.getData()[0])) : "result=" + result3;
            assert (new Almost(5).equal(4.0, result3.getData()[1])) : "result=" + result3;
            model3.dispose();
            result3.dispose();
            perturb.dispose();
        }
        data.dispose();
        if (TestVect.undisposed.size() > 0) {
            throw new IllegalStateException(TestVect.getTraces());
        }
        assert (TestVect.max <= 10) : "max=" + TestVect.max;
        assert (projectWasTested);
        GaussNewtonSolver.setExpensiveDebug(false);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public GaussNewtonSolverTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(GaussNewtonSolverTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GaussNewtonSolverTest.suite());
    }

    private static class TestVect
    extends ArrayVect1 {
        private static final long serialVersionUID = 1L;
        public static int max = 0;
        public static int total = 0;
        public static Map<Object, String> undisposed = Collections.synchronizedMap(new HashMap());
        public String identity = "default";

        @Override
        public void add(double scaleThis, double scaleOther, VectConst other) {
            this.assertSameType(other);
            super.add(scaleThis, scaleOther, other);
        }

        @Override
        public void project(double scaleThis, double scaleOther, VectConst other) {
            TestVect tv = (TestVect)other;
            if (!this.identity.equals(tv.identity)) {
                projectWasTested = true;
            }
            super.add(scaleThis, scaleOther, other);
        }

        @Override
        public double dot(VectConst other) {
            this.assertSameType(other);
            return super.dot(other);
        }

        private void assertSameType(VectConst other) {
            TestVect tv = (TestVect)other;
            if (!this.identity.equals(tv.identity)) {
                throw new IllegalArgumentException("different types");
            }
        }

        public TestVect(double[] data, double variance, String identity) {
            super(data, variance);
            this.identity = identity;
            this.remember(this);
        }

        @Override
        public TestVect clone() {
            TestVect result = (TestVect)super.clone();
            this.remember(result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remember(Object tv) {
            Map<Object, String> map = undisposed;
            synchronized (map) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                new Exception("This vector was never disposed").printStackTrace(pw);
                pw.flush();
                undisposed.put(tv, sw.toString());
                max = Math.max(max, undisposed.size());
                ++total;
                if (undisposed.size() > 12 && !printedUndisposed) {
                    LOG.severe("**********************************************");
                    LOG.severe(TestVect.getTraces());
                    LOG.severe("**********************************************");
                    printedUndisposed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Map<Object, String> map = undisposed;
            synchronized (map) {
                super.dispose();
                undisposed.remove(this);
            }
        }

        public static String getTraces() {
            StringBuilder sb = new StringBuilder();
            for (String s : undisposed.values()) {
                sb.append(s);
                sb.append(NL);
            }
            return sb.toString();
        }
    }
}

