/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Tuple3;

public class Vector3
extends Tuple3 {
    public Vector3() {
    }

    public Vector3(double x, double y, double z) {
        super(x, y, z);
    }

    public Vector3(Vector3 v) {
        super(v.x, v.y, v.z);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 negate() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 negateEquals() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 normalize() {
        double d = this.length();
        double s = d > 0.0 ? 1.0 / d : 1.0;
        return new Vector3(this.x * s, this.y * s, this.z * s);
    }

    public Vector3 normalizeEquals() {
        double d = this.length();
        double s = d > 0.0 ? 1.0 / d : 1.0;
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    public Vector3 plus(Vector3 v) {
        return new Vector3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3 plusEquals(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector3 minus(Vector3 v) {
        return new Vector3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3 minusEquals(Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Vector3 times(double s) {
        return new Vector3(this.x * s, this.y * s, this.z * s);
    }

    public Vector3 timesEquals(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    public double dot(Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector3 cross(Vector3 v) {
        return new Vector3(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }
}

