/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.renjin.compiler.ByteCodeVisitor;
import org.renjin.compiler.ConstantGeneratingVisitor;
import org.renjin.compiler.FieldSexpPool;
import org.renjin.compiler.GenerationContext;
import org.renjin.compiler.ThunkMap;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.IRFunction;
import org.renjin.compiler.ir.tac.IRFunctionTable;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.sexp.Closure;

public class ClosureCompiler
implements Opcodes {
    private IRFunction closure;
    private ClassWriter cw;
    private ClassVisitor cv;
    private GenerationContext generationContext;

    public static Class<Closure> compileAndLoad(IRFunction closure) {
        return new ClosureCompiler("Closure" + System.identityHashCode(closure)).doCompileAndLoad(closure);
    }

    public static Class<Closure> compileAndLoad(Closure closureSexp) {
        IRFunctionTable functionTable = new IRFunctionTable();
        IRBodyBuilder builder = new IRBodyBuilder(functionTable);
        return ClosureCompiler.compileAndLoad(new IRFunction(closureSexp.getFormals(), closureSexp.getBody(), builder.build(closureSexp.getBody())));
    }

    public static byte[] compile(String className, IRFunction closure) {
        return new ClosureCompiler(className).doCompile(closure);
    }

    public ClosureCompiler(String className) {
        this.generationContext = new GenerationContext(className, new FieldSexpPool(className), new ThunkMap(className + "$thunk$"));
    }

    public byte[] doCompile(IRFunction closure) {
        this.closure = closure;
        this.startClass();
        this.writeDoEval();
        this.writeConstructor();
        this.writeFormals();
        this.writeBodySexp();
        this.generationContext.getSexpPool().writeFields(this.cv);
        this.writeClassEnd();
        return this.cw.toByteArray();
    }

    public Class<Closure> doCompileAndLoad(IRFunction closure) {
        return new MyClassLoader().defineClass(this.generationContext.getClassName().replace('/', '.'), this.doCompile(closure));
    }

    private void startClass() {
        this.cw = new ClassWriter(2){

            protected String getCommonSuperClass(String className1, String className2) {
                return super.getCommonSuperClass(ClosureCompiler.this.resolveForwardReference(className1), ClosureCompiler.this.resolveForwardReference(className2));
            }
        };
        this.cv = this.cw;
        this.cv.visit(50, 33, this.generationContext.getClassName(), null, "org/renjin/sexp/Closure", null);
    }

    private String resolveForwardReference(String className) {
        if (className.contains("$closure$")) {
            return "org/renjin/sexp/Closure";
        }
        return className;
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "(Lorg/renjin/sexp/Environment;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, this.generationContext.getClassName(), "createFormals", "()Lorg/renjin/sexp/PairList;");
        mv.visitMethodInsn(184, this.generationContext.getClassName(), "createBody", "()Lorg/renjin/sexp/SEXP;");
        mv.visitMethodInsn(183, "org/renjin/sexp/Closure", "<init>", "(Lorg/renjin/sexp/Environment;Lorg/renjin/sexp/PairList;Lorg/renjin/sexp/SEXP;)V");
        this.generationContext.getSexpPool().writeConstructorBody(mv);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeDoEval() {
        MethodVisitor mv = this.cv.visitMethod(1, "doApply", "(Lorg/renjin/eval/Context;)Lorg/renjin/sexp/SEXP;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/renjin/eval/Context", "getEnvironment", "()Lorg/renjin/sexp/Environment;");
        mv.visitVarInsn(58, 2);
        this.writeDoEvalBody(mv);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeFormals() {
        MethodVisitor mv = this.cv.visitMethod(10, "createFormals", "()Lorg/renjin/sexp/PairList;", null, null);
        mv.visitCode();
        ConstantGeneratingVisitor cgv = new ConstantGeneratingVisitor(mv);
        this.closure.getFormals().accept(cgv);
        mv.visitInsn(176);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
    }

    private void writeBodySexp() {
        MethodVisitor mv = this.cv.visitMethod(10, "createBody", "()Lorg/renjin/sexp/SEXP;", null, null);
        mv.visitCode();
        ConstantGeneratingVisitor cgv = new ConstantGeneratingVisitor(mv);
        this.closure.getBodyExpression().accept(cgv);
        mv.visitInsn(176);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
    }

    private void writeDoEvalBody(MethodVisitor mv) {
        ByteCodeVisitor visitor = new ByteCodeVisitor(this.generationContext, mv);
        ControlFlowGraph cfg = new ControlFlowGraph(this.closure.getBody());
        for (BasicBlock bb : cfg.getBasicBlocks()) {
            System.out.println(bb.statementsToString());
            visitor.startBasicBlock(bb);
            for (Statement stmt : bb.getStatements()) {
                stmt.accept(visitor);
            }
        }
    }

    private void writeClassEnd() {
        this.cv.visitEnd();
    }

    public List<Map.Entry<String, IRFunction>> getNestedClosures() {
        return this.generationContext.getNestedClosures();
    }

    public ThunkMap getThunkMap() {
        return this.generationContext.getThunkMap();
    }

    class MyClassLoader
    extends ClassLoader {
        MyClassLoader() {
        }

        public Class defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

