/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.ssa;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.CfgPredicates;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.DominanceTree;
import org.renjin.compiler.ir.ssa.PhiFunction;
import org.renjin.compiler.ir.ssa.SsaVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.Statement;

public class SsaTransformer {
    private ControlFlowGraph cfg;
    private DominanceTree dtree;
    private Map<Variable, Integer> C = Maps.newHashMap();
    private Map<Variable, Stack<Integer>> S = Maps.newHashMap();

    public SsaTransformer(ControlFlowGraph cfg, DominanceTree dtree) {
        this.cfg = cfg;
        this.dtree = dtree;
    }

    public void transform() {
        this.insertPhiFunctions();
        this.renameVariables();
    }

    private void insertPhiFunctions() {
        int iterCount = 0;
        HashMap hasAlready = Maps.newHashMap();
        HashMap work = Maps.newHashMap();
        for (BasicBlock X : this.cfg.getLiveBasicBlocks()) {
            hasAlready.put(X, 0);
            work.put(X, 0);
        }
        LinkedList W = Lists.newLinkedList();
        for (Variable V : this.cfg.variables()) {
            ++iterCount;
            for (BasicBlock X : Iterables.filter(this.cfg.getLiveBasicBlocks(), CfgPredicates.containsAssignmentTo(V))) {
                work.put(X, iterCount);
                W.add(X);
            }
            while (!W.isEmpty()) {
                BasicBlock X = (BasicBlock)W.poll();
                for (BasicBlock Y : this.dtree.getFrontier(X)) {
                    if (X == this.cfg.getExit() || (Integer)hasAlready.get(Y) >= iterCount) continue;
                    Y.insertPhiFunction(V, this.cfg.getPredecessors(Y).size());
                    hasAlready.put(Y, iterCount);
                    if ((Integer)work.get(Y) >= iterCount) continue;
                    work.put(Y, iterCount);
                    W.add(Y);
                }
            }
        }
    }

    private void renameVariables() {
        for (Variable V : this.cfg.variables()) {
            this.C.put(V, 1);
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(0);
            this.S.put(V, stack);
        }
        this.search(this.cfg.getEntry());
    }

    private void search(BasicBlock X) {
        for (Statement stmt : X.getStatements()) {
            Assignment assignment;
            int i;
            Variable V2;
            Expression rhs = stmt.getRHS();
            if (!(rhs instanceof PhiFunction)) {
                for (Variable V2 : rhs.variables()) {
                    i = this.Top(V2);
                    rhs = rhs.replaceVariable(V2, new SsaVariable(V2, i));
                }
                stmt = X.replaceStatement(stmt, stmt.withRHS(rhs));
            }
            if (!(stmt instanceof Assignment) || !((assignment = (Assignment)stmt).getLHS() instanceof Variable)) continue;
            V2 = (Variable)assignment.getLHS();
            i = this.C.get(V2);
            X.replaceStatement(assignment, assignment.withLHS(new SsaVariable(V2, i)));
            this.S.get(V2).push(i);
            this.C.put(V2, i + 1);
        }
        for (BasicBlock Y : this.cfg.getSuccessors(X)) {
            int j = this.whichPred(Y, X);
            for (Assignment A : Lists.newArrayList(Y.phiAssignments())) {
                PhiFunction rhs = (PhiFunction)A.getRHS();
                Variable V = rhs.getArgument(j);
                int i = this.Top(V);
                rhs = rhs.replaceVariable(j, i);
                Y.replaceStatement(A, (Statement)new Assignment(A.getLHS(), rhs));
            }
        }
        for (BasicBlock Y : this.dtree.getChildren(X)) {
            this.search(Y);
        }
        for (Assignment A : X.assignments()) {
            if (!(A.getLHS() instanceof SsaVariable)) continue;
            SsaVariable lhs = (SsaVariable)A.getLHS();
            this.S.get(lhs.getInner()).pop();
        }
    }

    private int Top(Variable V) {
        Stack<Integer> stack = this.S.get(V);
        if (stack.isEmpty()) {
            throw new IllegalStateException("Variable " + V + " has not been assigned to before its use");
        }
        return stack.peek();
    }

    private int whichPred(BasicBlock X, BasicBlock Y) {
        int j = 0;
        for (BasicBlock P : this.cfg.getPredecessors(X)) {
            if (P.equals(Y)) {
                return j;
            }
            ++j;
        }
        throw new IllegalArgumentException("X is not a predecessor of Y");
    }
}

