/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class EnvironmentVariable
implements Variable {
    private final Symbol name;

    public EnvironmentVariable(Symbol name) {
        this.name = name;
    }

    public EnvironmentVariable(String name) {
        this(Symbol.get(name));
    }

    public Symbol getName() {
        return this.name;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        SEXP value = context.getEnvironment().findVariable(this.name);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("object '" + this.name + "' not found", new Object[0]);
        }
        return value.force(context);
    }

    @Override
    public void setValue(Context context, Object[] temp, Object value) {
        context.getEnvironment().setVariable(this.name, (SEXP)value);
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public Set<Variable> variables() {
        return Collections.singleton(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvironmentVariable other = (EnvironmentVariable)obj;
        return this.name == other.name;
    }

    @Override
    public Variable replaceVariable(Variable name, Variable newName) {
        if (this.equals(name)) {
            return newName;
        }
        return this;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void setChild(int i, Expression expr) {
        throw new IllegalArgumentException();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitEnvironmentVariable(this);
    }

    @Override
    public SEXP getSExpression() {
        return this.name;
    }
}

