/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.renjin.compiler.pipeline.DeferredJitter;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.JitKey;
import org.renjin.compiler.pipeline.JittedComputation;

public class DeferredJitCache {
    public static final DeferredJitCache INSTANCE = new DeferredJitCache();
    private final Cache<JitKey, JittedComputation> cache = CacheBuilder.newBuilder().softValues().maximumSize(100L).build();

    private DeferredJitCache() {
    }

    public JittedComputation compile(DeferredNode node) {
        JitKey key = node.jitKey();
        JittedComputation computation = (JittedComputation)this.cache.getIfPresent((Object)key);
        if (computation != null) {
            return computation;
        }
        DeferredJitter jitter = new DeferredJitter();
        computation = jitter.compile(node);
        this.cache.put((Object)key, (Object)computation);
        return computation;
    }
}

