/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.MathUtils;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Deferrable;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.DoubleVector;

public class MathExt {
    private static final int DBL_MAX_10_EXP = 308;
    private static final int MAX_DIGITS = 308;

    private MathExt() {
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double gamma(double x) {
        return Math.exp(Gamma.logGamma((double)x));
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double lgamma(double x) {
        return Gamma.logGamma((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double sign(double x) {
        return Math.signum(x);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double log(double x, double base) {
        return MathUtils.log((double)base, (double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double log(double d) {
        return Math.log(d);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double log2(double d) {
        return MathUtils.log((double)2.0, (double)d);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double abs(double x) {
        return Math.abs(x);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double abs(Complex x) {
        return x.abs();
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double asinh(double val) {
        return Math.log(val + Math.sqrt(val * val + 1.0));
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double acosh(double val) {
        return Math.log(val + Math.sqrt(val + 1.0) * Math.sqrt(val - 1.0));
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double atanh(double val) {
        return 0.5 * Math.log((1.0 + val) / (1.0 - val));
    }

    @Deferrable
    @Internal
    @DataParallel
    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double signif(double x, int digits) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            return x;
        }
        if (digits <= 0) {
            digits = 1;
        }
        return new BigDecimal(x).round(new MathContext(digits, RoundingMode.HALF_UP)).doubleValue();
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double expm1(double x) {
        return Math.expm1(x);
    }

    @Deferrable
    @Builtin
    @DataParallel
    public static double log1p(double x) {
        return Math.log1p(x);
    }

    @Internal
    @Deferrable
    @DataParallel
    public static double beta(double a, double b) {
        return Math.exp(Beta.logBeta((double)a, (double)b));
    }

    @Internal
    @Deferrable
    @DataParallel
    public static double lbeta(double a, double b) {
        return Beta.logBeta((double)a, (double)b);
    }

    @Internal
    @DataParallel
    public static double choose(double n, int k) {
        if (k < 0) {
            return 0.0;
        }
        if (k == 0) {
            return 1.0;
        }
        if ((double)((int)n) == n) {
            return MathUtils.binomialCoefficientDouble((int)((int)n), (int)k);
        }
        return MathExt.gamma(n + 1.0) / (MathExt.gamma(n - (double)k + 1.0) * MathExt.gamma(k + 1));
    }

    @Internal
    @DataParallel
    public static double lchoose(double n, int k) {
        return Math.log(MathExt.choose(n, k));
    }

    @Builtin
    @Deferrable
    @DataParallel
    public static double round(double x) {
        return Math.rint(x);
    }

    @Builtin
    @Deferrable
    @DataParallel
    public static double round(double x, int digits) {
        double sign2;
        if (Double.isNaN(x) || Double.isNaN(digits)) {
            return x + (double)digits;
        }
        if (!DoubleVector.isFinite(x)) {
            return x;
        }
        if ((double)digits == Double.POSITIVE_INFINITY) {
            return x;
        }
        if ((double)digits == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (digits > 308) {
            digits = 308;
        }
        int dig = (int)Math.floor((double)digits + 0.5);
        if (x < 0.0) {
            sign2 = -1.0;
            x = -x;
        } else {
            sign2 = 1.0;
        }
        if (dig == 0) {
            return sign2 * Math.rint(x);
        }
        if (dig > 0) {
            return sign2 * new BigDecimal(x).setScale(digits, RoundingMode.HALF_EVEN).doubleValue();
        }
        double pow10 = Math.pow(10.0, -dig);
        return sign2 * Math.rint(x / pow10) * pow10;
    }

    @Builtin
    @Deferrable
    @DataParallel
    public static Complex round(Complex x, int digits) {
        return new Complex(MathExt.round(x.getReal(), digits), MathExt.round(x.getImaginary(), digits));
    }

    @Generic
    @Deferrable
    @Builtin(value="trunc")
    @DataParallel
    public static double truncate(double x) {
        return Math.floor(x);
    }
}

