/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Graphics;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.renjin.base.Base;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.gcc.runtime.BooleanPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.invoke.reflection.FunctionBinding;
import org.renjin.methods.Methods;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.NativeStringVector;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.BooleanArrayVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;

public class Native {
    public static final boolean DEBUG = false;

    @Builtin(value=".C")
    public static SEXP dotC(@Current Context context, @Current Environment rho, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="NAOK") boolean naOk, @NamedFlag(value="DUP") boolean dup, @NamedFlag(value="ENCODING") boolean encoding) throws IllegalAccessException {
        MethodHandle method;
        if (methodExp instanceof StringVector) {
            String methodName = ((StringVector)methodExp).getElementAsString(0);
            if (packageName.equals("base")) {
                return Native.delegateToJavaMethod(context, Base.class, methodName, callArguments);
            }
            List<Method> methods = Native.findMethod(Native.getPackageClass(packageName, context), methodName);
            if (methods.isEmpty()) {
                throw new EvalException("Can't find method %s in package %s", methodName, packageName);
            }
            method = MethodHandles.publicLookup().unreflect((Method)Iterables.getOnlyElement(methods));
        } else if (methodExp instanceof ExternalPtr && ((ExternalPtr)methodExp).getInstance() instanceof Method) {
            method = MethodHandles.publicLookup().unreflect((Method)((ExternalPtr)methodExp).getInstance());
        } else if (methodExp instanceof ListVector) {
            ExternalPtr address = (ExternalPtr)((ListVector)methodExp).get("address");
            method = (MethodHandle)address.getInstance();
        } else {
            throw new EvalException("Invalid method argument of type %s", methodExp.getTypeName());
        }
        Object[] nativeArguments = new Object[method.type().parameterCount()];
        for (int i = 0; i != nativeArguments.length; ++i) {
            TypeDescriptor.OfField type = method.type().parameterType(i);
            if (type.equals(IntPtr.class)) {
                nativeArguments[i] = Native.intPtrFromVector(callArguments.get(i));
                continue;
            }
            if (type.equals(DoublePtr.class)) {
                nativeArguments[i] = Native.doublePtrFromVector(callArguments.get(i));
                continue;
            }
            if (type.equals(ObjectPtr.class)) {
                nativeArguments[i] = Native.stringPtrToCharPtrPtr(callArguments.get(i));
                continue;
            }
            throw new EvalException("Don't know how to marshall type " + callArguments.get(i).getClass().getName() + " to for C argument " + type + " in call to " + method, new Object[0]);
        }
        try {
            method.invokeWithArguments(nativeArguments);
        }
        catch (Error | EvalException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException(e.getMessage(), e);
        }
        ListVector.NamedBuilder builder = new ListVector.NamedBuilder();
        for (int i = 0; i != nativeArguments.length; ++i) {
            builder.add(callArguments.getName(i), Native.sexpFromPointer(nativeArguments[i], callArguments.get(i).getAttributes()));
        }
        return builder.build();
    }

    private static ObjectPtr stringPtrToCharPtrPtr(SEXP sexp) {
        if (!(sexp instanceof StringVector)) {
            throw new EvalException(".C function expected 'character', but argument was '%s'", sexp.getTypeName());
        }
        StringVector vector2 = (StringVector)sexp;
        Object[] strings = new BytePtr[sexp.length()];
        for (int i = 0; i < sexp.length(); ++i) {
            String element = vector2.getElementAsString(i);
            if (element == null) continue;
            strings[i] = BytePtr.nullTerminatedString((String)element, (Charset)Charsets.UTF_8);
        }
        return new ObjectPtr(strings, 0);
    }

    private static void dumpCall(String methodName, String packageName, ListVector callArguments) {
        System.out.print(".C('" + methodName + "', ");
        for (NamedValue arg : callArguments.namedValues()) {
            if (!Strings.isNullOrEmpty((String)arg.getName())) {
                System.out.print(arg.getName() + " = ");
            }
            System.out.println(Deparse.deparse(null, arg.getValue(), 80, false, 0, 0) + ", ");
        }
        System.out.println("PACKAGE = '" + packageName + "')");
    }

    public static SEXP sexpFromPointer(Object ptr, AttributeMap attributes2) {
        if (ptr instanceof DoublePtr) {
            return DoubleArrayVector.unsafe(((DoublePtr)ptr).array, attributes2);
        }
        if (ptr instanceof IntPtr) {
            return new IntArrayVector(((IntPtr)ptr).array, attributes2);
        }
        if (ptr instanceof ObjectPtr) {
            return new NativeStringVector((ObjectPtr)ptr, attributes2);
        }
        throw new UnsupportedOperationException(ptr.toString());
    }

    public static DoublePtr doublePtrFromVector(SEXP sexp) {
        if (!(sexp instanceof AtomicVector)) {
            throw new EvalException("expected atomic vector", new Object[0]);
        }
        return new DoublePtr(((AtomicVector)sexp).toDoubleArray());
    }

    public static IntPtr intPtrFromVector(SEXP sexp) {
        if (!(sexp instanceof AtomicVector)) {
            throw new EvalException("expected atomic vector", new Object[0]);
        }
        AtomicVector vector2 = (AtomicVector)sexp;
        int[] array2 = new int[vector2.length()];
        for (int i = 0; i != array2.length; ++i) {
            array2[i] = vector2.getElementAsInt(i);
        }
        return new IntPtr(array2, 0);
    }

    @Builtin(value=".Fortran")
    public static SEXP dotFortran(@Current Context context, @Current Environment rho, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="CLASS") String className, @NamedFlag(value="NAOK") boolean naOk, @NamedFlag(value="DUP") boolean dup, @NamedFlag(value="ENCODING") boolean encoding) throws IllegalAccessException {
        String methodName;
        MethodHandle method;
        if (methodExp instanceof ListVector) {
            ListVector methodObject = (ListVector)methodExp;
            ExternalPtr address = (ExternalPtr)methodObject.get("address");
            method = (MethodHandle)address.getInstance();
            methodName = ((StringVector)methodObject.get("name")).getElementAsString(0);
        } else if (methodExp instanceof StringVector) {
            if ("base".equals(packageName)) {
                className = "org.renjin.appl.Appl";
            }
            methodName = ((StringVector)methodExp).getElementAsString(0);
            method = Native.findFortranMethod(className, methodName);
        } else if (methodExp instanceof ExternalPtr && ((ExternalPtr)methodExp).getInstance() instanceof Method) {
            Method methodRef = (Method)((ExternalPtr)methodExp).getInstance();
            methodName = methodRef.getName();
            method = MethodHandles.publicLookup().unreflect(methodRef);
        } else {
            throw new EvalException("Invalid argument type for method = %s", methodExp.getTypeName());
        }
        Class<?>[] fortranTypes = method.type().parameterArray();
        if (fortranTypes.length != callArguments.length()) {
            throw new EvalException("Invalid number of args", new Object[0]);
        }
        Object[] fortranArgs = new Object[fortranTypes.length];
        ListVector.NamedBuilder returnValues = ListVector.newNamedBuilder();
        for (int i = 0; i != callArguments.length(); ++i) {
            Object[] array2;
            AtomicVector vector2 = (AtomicVector)callArguments.get(i);
            if (fortranTypes[i].equals(DoublePtr.class)) {
                array2 = vector2.toDoubleArray();
                fortranArgs[i] = new DoublePtr(array2, 0);
                returnValues.add(callArguments.getName(i), (SEXP)DoubleArrayVector.unsafe(array2, vector2.getAttributes()));
                continue;
            }
            if (fortranTypes[i].equals(IntPtr.class)) {
                array2 = vector2.toIntArray();
                fortranArgs[i] = new IntPtr((int[])array2, 0);
                returnValues.add(callArguments.getName(i), (SEXP)IntArrayVector.unsafe((int[])array2, vector2.getAttributes()));
                continue;
            }
            if (fortranTypes[i].equals(BooleanPtr.class)) {
                array2 = Native.toBooleanArray(vector2);
                fortranArgs[i] = new BooleanPtr((boolean[])array2);
                returnValues.add(callArguments.getName(i), (SEXP)BooleanArrayVector.unsafe((boolean[])array2));
                continue;
            }
            throw new UnsupportedOperationException("fortran type: " + fortranTypes[i]);
        }
        try {
            method.invokeWithArguments(fortranArgs);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EvalException("Exception thrown while executing " + methodName, e);
        }
        return returnValues.build();
    }

    private static boolean[] toBooleanArray(AtomicVector vector2) {
        boolean[] array2 = new boolean[vector2.length()];
        for (int i = 0; i < vector2.length(); ++i) {
            int element = vector2.getElementAsRawLogical(i);
            if (element == Integer.MIN_VALUE) {
                throw new EvalException("NAs cannot be passed to logical fortran argument", new Object[0]);
            }
            array2[i] = element != 0;
        }
        return array2;
    }

    private static MethodHandle findFortranMethod(String className, String methodName) throws IllegalAccessException {
        Class<?> declaringClass = null;
        try {
            declaringClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new EvalException(String.format("Could not find class named %s", className), e);
        }
        String mangledName = methodName.toLowerCase() + "_";
        for (Method method : declaringClass.getMethods()) {
            if (!method.getName().equals(mangledName) || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            return MethodHandles.publicLookup().unreflect(method);
        }
        throw new EvalException("Could not find method %s in class %s", methodName, className);
    }

    @Builtin(value=".Call")
    public static SEXP dotCall(@Current Context context, @Current Environment rho, SEXP methodExp, @ArgumentList ListVector callArguments, @NamedFlag(value="PACKAGE") String packageName, @NamedFlag(value="CLASS") String className) throws ClassNotFoundException {
        if (methodExp.inherits("NativeSymbolInfo")) {
            ExternalPtr address = (ExternalPtr)((ListVector)methodExp).get("address");
            MethodHandle methodHandle = (MethodHandle)address.getInstance();
            if (methodHandle.type().parameterCount() != callArguments.length()) {
                throw new EvalException("Expected %d arguments, found %d", methodHandle.type().parameterCount(), callArguments.length());
            }
            MethodHandle transformedHandle = methodHandle.asSpreader(SEXP[].class, methodHandle.type().parameterCount());
            SEXP[] arguments = Native.toSexpArray(callArguments);
            try {
                if (methodHandle.type().returnType().equals(Void.TYPE)) {
                    transformedHandle.invokeExact(arguments);
                    return Null.INSTANCE;
                }
                return transformedHandle.invokeExact(arguments);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new EvalException("Exception calling " + methodExp + " : " + e.getMessage(), e);
            }
        }
        if (methodExp instanceof StringVector) {
            Class<?> clazz;
            String methodName = ((StringVector)methodExp).getElementAsString(0);
            if (packageName != null) {
                clazz = Native.getPackageClass(packageName, context);
            } else if (className != null) {
                clazz = Class.forName(className);
            } else {
                throw new EvalException("Either the PACKAGE or CLASS argument must be provided", new Object[0]);
            }
            return Native.delegateToJavaMethod(context, clazz, methodName, callArguments);
        }
        throw new EvalException("Invalid method argument: " + methodExp, new Object[0]);
    }

    private static SEXP[] toSexpArray(ListVector callArguments) {
        SEXP[] args2 = new SEXP[callArguments.length()];
        for (int i = 0; i < callArguments.length(); ++i) {
            args2[i] = callArguments.get(i);
        }
        return args2;
    }

    public static SEXP delegateToJavaMethod(Context context, Class clazz, String methodName, ListVector arguments) {
        List<Method> overloads = Native.findMethod(clazz, methodName);
        if (overloads.isEmpty()) {
            throw new EvalException("Method " + methodName + " not defined in " + clazz.getName(), new Object[0]);
        }
        FunctionBinding binding = new FunctionBinding(overloads);
        return binding.invoke(null, context, arguments);
    }

    public static List<Method> findMethod(Class packageClass, String methodName) {
        ArrayList overloads = Lists.newArrayList();
        for (Method method : packageClass.getMethods()) {
            if (!method.getName().equals(methodName) || (method.getModifiers() & 9) == 0) continue;
            overloads.add(method);
        }
        return overloads;
    }

    private static Class getPackageClass(String packageName, Context context) {
        if (packageName == null || packageName.equals("base")) {
            return Base.class;
        }
        if (packageName.equals("methods")) {
            return Methods.class;
        }
        if (packageName.equals("grDevices")) {
            return Graphics.class;
        }
        Namespace namespace = context.getNamespaceRegistry().getNamespace(context, packageName);
        FqPackageName fqname = namespace.getFullyQualifiedName();
        String packageClassName = fqname.getGroupId() + "." + fqname.getPackageName() + "." + fqname.getPackageName();
        try {
            return namespace.getPackage().loadClass(packageClassName);
        }
        catch (ClassNotFoundException e) {
            throw new EvalException("Could not load class '%s' from package '%s'", packageClassName, packageClassName);
        }
    }
}

