/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Split {
    private Split() {
    }

    @Internal
    public static ListVector split(Vector toSplit, IntVector factors) {
        assert (toSplit.length() == factors.length());
        SplitMap map = new SplitMap(toSplit);
        for (int i = 0; i != factors.length(); ++i) {
            int split2 = factors.getElementAsInt(i);
            if (IntVector.isNA(split2)) continue;
            map.getSplitBuilder(split2).addFrom(toSplit, i);
        }
        StringVector levels2 = (StringVector)factors.getAttributes().get(Symbols.LEVELS);
        ListVector.NamedBuilder resultList = new ListVector.NamedBuilder();
        for (Integer split3 : map.getKeys()) {
            resultList.add(levels2.getElementAsString(split3 - 1), (SEXP)map.getSplitBuilder(split3).build());
        }
        return resultList.build();
    }

    private static class SplitMap {
        private Vector sourceVector;
        private Map<Integer, Vector.Builder> splits = Maps.newHashMap();

        public SplitMap(Vector sourceVector) {
            this.sourceVector = sourceVector;
        }

        public Vector.Builder getSplitBuilder(int value) {
            Vector.Builder builder = this.splits.get(value);
            if (builder == null) {
                builder = this.sourceVector.newBuilderWithInitialSize(0);
                this.splits.put(value, builder);
            }
            return builder;
        }

        public Set<Integer> getKeys() {
            return this.splits.keySet();
        }
    }
}

