/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import com.google.common.base.Optional;
import org.renjin.primitives.packaging.ClasspathPackage;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.primitives.packaging.Package;
import org.renjin.primitives.packaging.PackageLoader;

public class ClasspathPackageLoader
implements PackageLoader {
    private ClassLoader classLoader;

    public ClasspathPackageLoader() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public ClasspathPackageLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    @Override
    public Optional<Package> load(FqPackageName name) {
        ClasspathPackage pkg = new ClasspathPackage(this.classLoader, name);
        if (pkg.resourceExists("environment")) {
            return Optional.of((Object)pkg);
        }
        return Optional.absent();
    }
}

