/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import org.renjin.sexp.Symbol;

public final class FqPackageName {
    public static final String CRAN_GROUP_ID = "org.renjin.cran";
    public static final String CORE_GROUP_ID = "org.renjin";
    public static final FqPackageName BASE = new FqPackageName("org.renjin", "base");
    private final String groupId;
    private final String packageName;

    public FqPackageName(String groupId, String packageName) {
        this.groupId = groupId;
        this.packageName = packageName;
    }

    public static FqPackageName fromSymbol(Symbol symbol2) {
        String name = symbol2.getPrintName();
        int sep = name.lastIndexOf(58);
        if (sep == -1) {
            sep = name.lastIndexOf(".");
        }
        return new FqPackageName(name.substring(0, sep), name.substring(sep + 1));
    }

    public static FqPackageName cranPackage(Symbol name) {
        return new FqPackageName(CRAN_GROUP_ID, name.getPrintName());
    }

    public static FqPackageName cranPackage(String name) {
        return new FqPackageName(CRAN_GROUP_ID, name);
    }

    public static FqPackageName corePackage(Symbol name) {
        return new FqPackageName(CORE_GROUP_ID, name.getPrintName());
    }

    public static FqPackageName corePackage(String name) {
        return new FqPackageName(CORE_GROUP_ID, name);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Symbol getPackageSymbol() {
        return Symbol.get(this.packageName);
    }

    public String toString(char separator) {
        return this.groupId + separator + this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FqPackageName that = (FqPackageName)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        return this.packageName.equals(that.packageName);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.packageName.hashCode();
        return result;
    }

    public String toString() {
        return this.toString(':');
    }
}

