/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.eval.Context;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class AssignLeftFunction
extends SpecialFunction {
    public AssignLeftFunction() {
        super("<-");
    }

    protected AssignLeftFunction(String name) {
        super(name);
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        Object lhs = call2.getArgument(0);
        Object rhs = call2.getArgument(1);
        return this.assignLeft(context, rho, (SEXP)lhs, (SEXP)rhs);
    }

    public SEXP assignLeft(Context context, Environment rho, SEXP lhs, SEXP value) {
        Symbol target;
        SEXP evaluatedValue = context.evaluate(value, rho);
        SEXP rhs = new Promise(value, evaluatedValue);
        while (lhs instanceof FunctionCall) {
            FunctionCall call2 = (FunctionCall)lhs;
            Symbol getter = (Symbol)call2.getFunction();
            Symbol setter = Symbol.get(getter.getPrintName() + "<-");
            PairList setterArgs = PairList.Node.newBuilder().addAll(call2.getArguments()).add("value", rhs).build();
            FunctionCall setterCall = new FunctionCall(setter, setterArgs);
            rhs = context.evaluate(setterCall, rho);
            lhs = call2.getArgument(0);
        }
        if (lhs instanceof Symbol) {
            target = (Symbol)lhs;
        } else if (lhs instanceof StringVector) {
            target = Symbol.get(((StringVector)lhs).getElementAsString(0));
        } else {
            throw new InvalidSyntaxException("cannot assign to value '" + lhs + " (of type " + lhs.getTypeName() + ")");
        }
        if (rhs instanceof Promise) {
            rhs = rhs.force(context);
        }
        this.assignResult(context, rho, target, rhs);
        context.setInvisibleFlag();
        return evaluatedValue;
    }

    protected void assignResult(Context context, Environment rho, Symbol target, SEXP rhs) {
        rho.setVariable(target, rhs);
    }
}

