/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.apache.commons.math.special.Gamma;
import org.renjin.eval.Session;
import org.renjin.primitives.MathExt;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.Distributions;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.SignRank;
import org.renjin.stats.internals.distributions.Utils;

public class Binom {
    public static double rbinom(Session context, double nin, double pp) {
        double alv;
        int ix;
        double c2 = 0.0;
        double fm = 0.0;
        double npq = 0.0;
        double p1 = 0.0;
        double p2 = 0.0;
        double p3 = 0.0;
        double p4 = 0.0;
        double qn = 0.0;
        double xl = 0.0;
        double xll = 0.0;
        double xlr = 0.0;
        double xm = 0.0;
        double xr = 0.0;
        double psave = -1.0;
        int nsave = -1;
        int m = 0;
        if (Double.isInfinite(nin)) {
            return Double.NaN;
        }
        double r = Math.floor(nin + 0.5);
        if (r != nin) {
            return Double.NaN;
        }
        if (Double.isInfinite(pp) || r < 0.0 || pp < 0.0 || pp > 1.0) {
            return Double.NaN;
        }
        if (r == 0.0 || pp == 0.0) {
            return 0.0;
        }
        if (pp == 1.0) {
            return r;
        }
        if (r >= 2.147483647E9) {
            return Distributions.qbinom(context.rng.unif_rand(), (int)r, pp, false, false);
        }
        int n = (int)r;
        double p = Math.min(pp, 1.0 - pp);
        double q = 1.0 - p;
        double np = (double)n * p;
        r = p / q;
        double g = r * (double)(n + 1);
        if (pp != psave || n != nsave) {
            psave = pp;
            nsave = n;
            if (np < 30.0) {
                qn = Math.pow(q, n);
                block0: while (true) {
                    int ix2 = 0;
                    double f = qn;
                    double u = context.rng.unif_rand();
                    while (true) {
                        if (u < f) {
                            if (psave > 0.5) {
                                ix2 = n - ix2;
                            }
                            return ix2;
                        }
                        if (ix2 > 110) continue block0;
                        u -= f;
                        f *= g / (double)(++ix2) - r;
                    }
                    break;
                }
            }
            double ffm = np + p;
            m = (int)ffm;
            fm = m;
            npq = np * q;
            p1 = (double)((int)(2.195 * Math.sqrt(npq) - 4.6 * q)) + 0.5;
            xm = fm + 0.5;
            xl = xm - p1;
            xr = xm + p1;
            c2 = 0.134 + 20.5 / (15.3 + fm);
            double al = (ffm - xl) / (ffm - xl * p);
            xll = al * (1.0 + 0.5 * al);
            al = (xr - ffm) / (xr * q);
            xlr = al * (1.0 + 0.5 * al);
            p2 = p1 * (1.0 + c2 + c2);
            p3 = p2 + c2 / xll;
            p4 = p3 + c2 / xlr;
        } else if (n == nsave) {
            if (np < 30.0) {
                // empty if block
            }
            block2: while (true) {
                int ix3 = 0;
                double f = qn;
                double u = context.rng.unif_rand();
                while (true) {
                    if (u < f) {
                        if (psave > 0.5) {
                            ix3 = n - ix3;
                        }
                        return ix3;
                    }
                    if (ix3 > 110) continue block2;
                    u -= f;
                    f *= g / (double)(++ix3) - r;
                }
                break;
            }
        }
        while (true) {
            double u = context.rng.unif_rand() * p4;
            double v = context.rng.unif_rand();
            if (u <= p1) {
                ix = (int)(xm - p1 * v + u);
                if (psave > 0.5) {
                    ix = n - ix;
                }
                return ix;
            }
            if (u <= p2) {
                double x = xl + (u - p1) / c2;
                if ((v = v * c2 + 1.0 - Math.abs(xm - x) / p1) > 1.0 || v <= 0.0) continue;
                ix = (int)x;
            } else if (u > p3) {
                ix = (int)(xr - Math.log(v) / xlr);
                if (ix > n) continue;
                v = v * (u - p3) * xlr;
            } else {
                ix = (int)(xl + Math.log(v) / xll);
                if (ix < 0) continue;
                v = v * (u - p2) * xll;
            }
            int k = Math.abs(ix - m);
            if (k <= 20 || (double)k >= npq / 2.0 - 1.0) {
                int i;
                double f = 1.0;
                if (m < ix) {
                    for (i = m + 1; i <= ix; ++i) {
                        f *= g / (double)i - r;
                    }
                } else if (m != ix) {
                    for (i = ix + 1; i <= m; ++i) {
                        f /= g / (double)i - r;
                    }
                }
                if (!(v <= f)) continue;
                if (psave > 0.5) {
                    ix = n - ix;
                }
                return ix;
            }
            double amaxp = (double)k / npq * (((double)k * ((double)k / 3.0 + 0.625) + 0.1666666666666) / npq + 0.5);
            double ynorm = (double)(-k * k) / (2.0 * npq);
            alv = Math.log(v);
            if (alv < ynorm - amaxp) {
                if (psave > 0.5) {
                    ix = n - ix;
                }
                return ix;
            }
            if (alv <= ynorm + amaxp) break;
        }
        double x1 = ix + 1;
        double f1 = fm + 1.0;
        double z = (double)(n + 1) - fm;
        double w = (double)(n - ix) + 1.0;
        double z2 = z * z;
        double x2 = x1 * x1;
        double f2 = f1 * f1;
        double w2 = w * w;
        if (alv <= xm * Math.log(f1 / x1) + ((double)(n - m) + 0.5) * Math.log(z / w) + (double)(ix - m) * Math.log(w * p / (x1 * q)) + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / f2) / f2) / f2) / f2) / f1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / z2) / z2) / z2) / z2) / z / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / x2) / x2) / x2) / x2) / x1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / w2) / w2) / w2) / w2) / w / 166320.0) {
            // empty if block
        }
        if (psave > 0.5) {
            ix = n - ix;
        }
        return ix;
    }

    public static double bd0(double x, double np) {
        if (!DoubleVector.isFinite(x) || !DoubleVector.isFinite(np) || np == 0.0) {
            return Double.NaN;
        }
        if (Math.abs(x - np) < 0.1 * (x + np)) {
            double v = (x - np) / (x + np);
            double s = (x - np) * v;
            double ej = 2.0 * x * v;
            v *= v;
            int j = 1;
            while (true) {
                double s1;
                if ((s1 = s + (ej *= v) / (double)((j << 1) + 1)) == s) {
                    return s1;
                }
                s = s1;
                ++j;
            }
        }
        return x * Math.log(x / np) + np - x;
    }

    public static double stirlerr(double n) {
        double S0 = 0.08333333333333333;
        double S1 = 0.002777777777777778;
        double S2 = 7.936507936507937E-4;
        double S32 = 5.952380952380953E-4;
        double S42 = 8.417508417508417E-4;
        double[] sferr_halves = new double[]{0.0, 0.15342640972002736, 0.08106146679532726, 0.05481412105191765, 0.0413406959554093, 0.03316287351993629, 0.02767792568499834, 0.023746163656297496, 0.020790672103765093, 0.018488450532673187, 0.016644691189821193, 0.015134973221917378, 0.013876128823070748, 0.012810465242920227, 0.01189670994589177, 0.011104559758206917, 0.010411265261972096, 0.009799416126158804, 0.009255462182712733, 0.008768700134139386, 0.00833056343336287, 0.00793411456431402, 0.007573675487951841, 0.007244554301320383, 0.00694284010720953, 0.006665247032707682, 0.006408994188004207, 0.006171712263039458, 0.0059513701127588475, 0.0057462165130101155, 0.005554733551962801};
        if (n <= 15.0) {
            double nn = n + n;
            if (nn == (double)((int)nn)) {
                return sferr_halves[(int)nn];
            }
            return Math.log(MathExt.gamma(n + 1.0)) - (n + 0.5) * Math.log(n) + n - Math.log(Math.sqrt(Math.PI * 2));
        }
        double nn = n * n;
        if (n > 500.0) {
            return (0.08333333333333333 - 0.002777777777777778 / nn) / n;
        }
        if (n > 80.0) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / nn) / nn) / n;
        }
        if (n > 35.0) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / nn) / nn) / nn) / n;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / nn) / nn) / nn) / nn) / n;
    }

    public static double dbinom_raw(double x, double n, double p, double q, boolean give_log) {
        if (p == 0.0) {
            return x == 0.0 ? SignRank.R_D__1(true, give_log) : SignRank.R_D__0(true, give_log);
        }
        if (q == 0.0) {
            return x == n ? SignRank.R_D__1(true, give_log) : SignRank.R_D__0(true, give_log);
        }
        if (x == 0.0) {
            if (n == 0.0) {
                return SignRank.R_D__1(true, give_log);
            }
            double lc = p < 0.1 ? -Binom.bd0(n, n * q) - n * p : n * Math.log(q);
            return SignRank.R_D_exp(lc, true, give_log);
        }
        if (x == n) {
            double lc = q < 0.1 ? -Binom.bd0(n, n * p) - n * q : n * Math.log(p);
            return SignRank.R_D_exp(lc, true, give_log);
        }
        if (x < 0.0 || x > n) {
            return SignRank.R_D__0(true, give_log);
        }
        double lc = Binom.stirlerr(n) - Binom.stirlerr(x) - Binom.stirlerr(n - x) - Binom.bd0(x, n * p) - Binom.bd0(n - x, n * q);
        double lf = Math.log(Math.PI * 2) + Math.log(x) + Math.log1p(-x / n);
        return SignRank.R_D_exp(lc - 0.5 * lf, true, give_log);
    }

    private static double do_search(double y, double[] z, double p, double n, double pr, double incr) {
        double d;
        block4: {
            if (!(z[0] >= p)) break block4;
            while (true) {
                block6: {
                    block5: {
                        double d2;
                        if (y == 0.0) break block5;
                        z[0] = Distributions.pnbinom(y - incr, (int)n, pr, true, false);
                        if (!(d2 < p)) break block6;
                    }
                    return y;
                }
                y = Math.max(0.0, y - incr);
            }
        }
        do {
            z[0] = Distributions.pnbinom(y += incr, (int)n, pr, true, false);
        } while (!(d >= p));
        return y;
    }

    public static double qnbinom(double p, double size, double prob, boolean lower_tail, boolean log_p) {
        double oldincr;
        double[] z = new double[1];
        if (DoubleVector.isNaN(p) || DoubleVector.isNaN(size) || DoubleVector.isNaN(prob)) {
            return p + size + prob;
        }
        if (prob <= 0.0 || prob > 1.0 || size <= 0.0) {
            return Double.NaN;
        }
        if (prob == 1.0) {
            return 0.0;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        double Q = 1.0 / prob;
        double P = (1.0 - prob) * Q;
        double mu = size * P;
        double sigma = Math.sqrt(size * P * Q);
        double gamma2 = (Q + P) / sigma;
        if (!lower_tail || log_p) {
            if ((p = Normal.R_DT_qIv(p, lower_tail ? 1.0 : 0.0, log_p ? 1.0 : 0.0)) == SignRank.R_DT_0(lower_tail, log_p)) {
                return 0.0;
            }
            if (p == SignRank.R_DT_1(lower_tail, log_p)) {
                return Double.POSITIVE_INFINITY;
            }
        }
        if (p + 1.01 * SignRank.DBL_EPSILON >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        z[0] = Distributions.qnorm(p, 0.0, 1.0, true, false);
        double y = Math.floor(mu + sigma * (z[0] + gamma2 * (z[0] * z[0] - 1.0) / 6.0) + 0.5);
        z[0] = Distributions.pnbinom(y, (int)size, prob, true, false);
        p *= 1.0 - 64.0 * SignRank.DBL_EPSILON;
        if (y < 100000.0) {
            return Binom.do_search(y, z, p, size, prob, 1.0);
        }
        double incr = Math.floor(y * 0.001);
        do {
            oldincr = incr;
            y = Binom.do_search(y, z, p, size, prob, incr);
            incr = Math.max(1.0, Math.floor(incr / 100.0));
        } while (oldincr > 1.0 && incr > y * 1.0E-15);
        return y;
    }

    public static double dnbinom_mu(double x, double size, double mu, boolean give_log) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(size) || DoubleVector.isNaN(mu)) {
            return x + size + mu;
        }
        if (mu < 0.0 || size < 0.0) {
            return Double.NaN;
        }
        if (SignRank.R_D_nonint(x, true, give_log)) {
            return SignRank.R_D__0(true, give_log);
        }
        if (x < 0.0 || !DoubleVector.isFinite(x)) {
            return SignRank.R_D__0(true, give_log);
        }
        if ((x = SignRank.R_D_forceint(x)) == 0.0) {
            return SignRank.R_D_exp(size * (size < mu ? Math.log(size / (size + mu)) : Math.log1p(-mu / (size + mu))), true, give_log);
        }
        if (x < 1.0E-10 * size) {
            return SignRank.R_D_exp(x * Math.log(size * mu / (size + mu)) - mu - Gamma.logGamma((double)(x + 1.0)) + Math.log1p(x * (x - 1.0) / (2.0 * size)), true, give_log);
        }
        double ans = Binom.dbinom_raw(size, x + size, size / (size + mu), mu / (size + mu), give_log);
        double p = size / (size + x);
        return give_log ? Math.log(p) + ans : p * ans;
    }

    public static double qnbinom_mu(double p, double size, double mu, boolean lower_tail, boolean log_p) {
        return Binom.qnbinom(p, size, size / (size + mu), lower_tail, log_p);
    }

    public static double pnbinom_mu(double x, double size, double mu, boolean lower_tail, boolean log_p) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(size) || DoubleVector.isNaN(mu)) {
            return x + size + mu;
        }
        if (!DoubleVector.isFinite(size) || !DoubleVector.isFinite(mu)) {
            return Double.NaN;
        }
        if (size <= 0.0 || mu < 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            SignRank.R_DT_0(lower_tail, log_p);
        }
        if (!DoubleVector.isFinite(x)) {
            return SignRank.R_DT_1(lower_tail, log_p);
        }
        x = Math.floor(x + 1.0E-7);
        int[] ierr = new int[1];
        double[] w = new double[1];
        double[] wc = new double[1];
        Utils.bratio(size, x + 1.0, size / (size + mu), mu / (size + mu), w, wc, ierr, log_p);
        return lower_tail ? w[0] : wc[0];
    }
}

