/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.Distributions;
import org.renjin.stats.internals.distributions.Gamma;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.Poisson;
import org.renjin.stats.internals.distributions.SignRank;

public class ChiSquare {
    static double rchisq(Session context, double df2) {
        if (df2 < 0.0) {
            return Double.NaN;
        }
        return Gamma.rgamma(context, df2 / 2.0, 2.0);
    }

    static double rnchisq(Session context, double df2, double lambda) {
        if (df2 < 0.0 || lambda < 0.0) {
            return Double.NaN;
        }
        if (lambda == 0.0) {
            if (df2 == 0.0) {
                return Double.NaN;
            }
            return Gamma.rgamma(context, df2 / 2.0, 2.0);
        }
        double r = Poisson.rpois(context, lambda / 2.0);
        if (r > 0.0) {
            r = ChiSquare.rchisq(context, 2.0 * r);
        }
        if (df2 > 0.0) {
            r += Gamma.rgamma(context, df2 / 2.0, 2.0);
        }
        return r;
    }

    public static double pnchisq(double x, double df2, double ncp, boolean lower_tail, boolean log_p) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(df2) || DoubleVector.isNaN(ncp)) {
            return x + df2 + ncp;
        }
        if (!DoubleVector.isFinite(df2) || !DoubleVector.isFinite(ncp)) {
            return Double.NaN;
        }
        if (df2 < 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        double ans = ChiSquare.pnchisq_raw(x, df2, ncp, 1.0E-12, 8.0 * SignRank.DBL_EPSILON, 1000000, lower_tail);
        if (ncp >= 80.0) {
            if (lower_tail) {
                ans = Math.min(ans, 1.0);
            } else {
                if (ans < 1.0E-10) {
                    // empty if block
                }
                ans = Math.max(ans, 0.0);
            }
        }
        if (!log_p) {
            return ans;
        }
        if (ncp >= 80.0 || ans < 0.99999999) {
            return Math.log(ans);
        }
        ans = ChiSquare.pnchisq_raw(x, df2, ncp, 1.0E-12, 8.0 * SignRank.DBL_EPSILON, 1000000, !lower_tail);
        return Math.log1p(-ans);
    }

    /*
     * Unable to fully structure code
     */
    public static double pnchisq_raw(double x, double f, double theta, double errmax, double reltol, int itrmax, boolean lower_tail) {
        l_lam = -1.0;
        l_x = -1.0;
        lu = -1.0;
        _dbl_min_exp = Math.log(2.0) * -1022.0;
        if (x <= 0.0) {
            if (x == 0.0 && f == 0.0) {
                return lower_tail != false ? Math.exp(-0.5 * theta) : -Math.expm1(-0.5 * theta);
            }
            return lower_tail != false ? 0.0 : 1.0;
        }
        if (!DoubleVector.isFinite(x)) {
            return lower_tail != false ? 1.0 : 0.0;
        }
        if (theta < 80.0) {
            sum = 0.0;
            sum2 = 0.0;
            lambda = 0.5 * theta;
            pr = Math.exp(-lambda);
            i = 0;
            while (i < 110) {
                sum += pr * Distributions.pchisq(x, f + (double)(2 * i), lower_tail, false);
                if ((sum2 += pr) >= 0.999999999999999) break;
                pr *= lambda / (double)(++i);
            }
            ans_inner = sum / sum2;
            return ans_inner;
        }
        lam = 0.5 * theta;
        v0 = lamSml = -lam < _dbl_min_exp;
        if (lamSml) {
            u = 0.0;
            lu = -lam;
            l_lam = Math.log(lam);
        } else {
            u = Math.exp(-lam);
        }
        v = u;
        x2 = 0.5 * x;
        f2 = 0.5 * f;
        f_x_2n = f - x;
        if (!(f2 * SignRank.DBL_EPSILON > 0.125)) ** GOTO lbl-1000
        t = x2 - f2;
        if (Math.abs(v1) < Math.sqrt(SignRank.DBL_EPSILON) * f2) {
            lt = (1.0 - t) * (2.0 - t / (f2 + 1.0)) - 0.5 * Math.log(6.283185307179586 * (f2 + 1.0));
        } else lbl-1000:
        // 2 sources

        {
            lt = f2 * Math.log(x2) - x2 - org.apache.commons.math.special.Gamma.logGamma((double)(f2 + 1.0));
        }
        v2 = tSml = lt < _dbl_min_exp;
        if (tSml) {
            if (x > f + theta + 5.0 * Math.sqrt(2.0 * (f + 2.0 * theta))) {
                return lower_tail != false ? 1.0 : 0.0;
            }
            l_x = Math.log(x);
            t = 0.0;
            term = 0.0;
            ans = 0.0;
        } else {
            t = Math.exp(lt);
            ans = term = v * t;
        }
        n = 1;
        f_2n = f + 2.0;
        f_x_2n += 2.0;
        while (true) {
            if (f_x_2n > 0.0) {
                bound = t * x / f_x_2n;
                is_it = false;
                is_r = false;
                is_b = bound <= errmax;
                if (is_b && (is_r = term <= reltol * ans) || (is_it = n > itrmax)) break;
            }
            if (lamSml) {
                if ((lu += l_lam - Math.log(n)) >= _dbl_min_exp) {
                    v = u = Math.exp(lu);
                    lamSml = false;
                }
            } else {
                v += (u *= lam / (double)n);
            }
            if (tSml) {
                if ((lt += l_x - Math.log(f_2n)) >= _dbl_min_exp) {
                    t = Math.exp(lt);
                    tSml = false;
                }
            } else {
                t *= x / f_2n;
            }
            if (!lamSml && !tSml) {
                term = v * t;
                ans += term;
            }
            ++n;
            f_2n += 2.0;
            f_x_2n += 2.0;
        }
        if (is_it) {
            // empty if block
        }
        return lower_tail != false ? ans : 1.0 - ans;
    }

    public static double qnchisq(double p, double df2, double ncp, boolean lower_tail, boolean log_p) {
        double lx;
        double pp;
        double ff;
        double c2;
        double b;
        double ux;
        double accu = 1.0E-13;
        double racc = 4.0 * SignRank.DBL_EPSILON;
        double Eps = 1.0E-11;
        double rEps = 1.0E-10;
        if (DoubleVector.isNaN(p) || DoubleVector.isNaN(df2) || DoubleVector.isNaN(ncp)) {
            return p + df2 + ncp;
        }
        if (!DoubleVector.isFinite(df2)) {
            return Double.NaN;
        }
        if (df2 < 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        if ((ux = (b = ncp * ncp / (df2 + 3.0 * ncp)) + (c2 = (df2 + 3.0 * ncp) / (df2 + 2.0 * ncp)) * Distributions.qchisq(p, ff = (df2 + 2.0 * ncp) / (c2 * c2), lower_tail, log_p)) < 0.0) {
            ux = 1.0;
        }
        double ux0 = ux;
        p = Normal.R_D_qIv(p, log_p ? 1.0 : 0.0);
        if (!lower_tail && ncp >= 80.0) {
            if (p < 1.0E-10) {
                // empty if block
            }
            p = 1.0 - p;
            lower_tail = true;
        }
        if (lower_tail) {
            if (p > 1.0 - SignRank.DBL_EPSILON) {
                return Double.POSITIVE_INFINITY;
            }
            pp = Math.min(1.0 - SignRank.DBL_EPSILON, p * 1.00000000001);
            while (ux < Double.MAX_VALUE && ChiSquare.pnchisq_raw(ux, df2, ncp, 1.0E-11, 1.0E-10, 10000, true) < pp) {
                ux *= 2.0;
            }
            pp = p * 0.99999999999;
            for (lx = Math.min(ux0, Double.MAX_VALUE); lx > Double.MIN_VALUE && ChiSquare.pnchisq_raw(lx, df2, ncp, 1.0E-11, 1.0E-10, 10000, true) > pp; lx *= 0.5) {
            }
        } else {
            if (p > 1.0 - SignRank.DBL_EPSILON) {
                return 0.0;
            }
            pp = Math.min(1.0 - SignRank.DBL_EPSILON, p * 1.00000000001);
            while (ux < Double.MAX_VALUE && ChiSquare.pnchisq_raw(ux, df2, ncp, 1.0E-11, 1.0E-10, 10000, false) > pp) {
                ux *= 2.0;
            }
            pp = p * 0.99999999999;
            for (lx = Math.min(ux0, Double.MAX_VALUE); lx > Double.MIN_VALUE && ChiSquare.pnchisq_raw(lx, df2, ncp, 1.0E-11, 1.0E-10, 10000, false) < pp; lx *= 0.5) {
            }
        }
        if (lower_tail) {
            double nx;
            do {
                if (ChiSquare.pnchisq_raw(nx = 0.5 * (lx + ux), df2, ncp, 1.0E-13, racc, 100000, true) > p) {
                    ux = nx;
                    continue;
                }
                lx = nx;
            } while ((ux - lx) / nx > 1.0E-13);
        } else {
            double nx;
            do {
                if (ChiSquare.pnchisq_raw(nx = 0.5 * (lx + ux), df2, ncp, 1.0E-13, racc, 100000, false) < p) {
                    ux = nx;
                    continue;
                }
                lx = nx;
            } while ((ux - lx) / nx > 1.0E-13);
        }
        return 0.5 * (ux + lx);
    }

    public static double dnchisq(double x, double df2, double ncp, boolean give_log) {
        double q;
        double mid;
        double eps = 5.0E-15;
        double dfmid = 0.0;
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(df2) || DoubleVector.isNaN(ncp)) {
            return x + df2 + ncp;
        }
        if (ncp < 0.0 || df2 <= 0.0) {
            return Double.NaN;
        }
        if (!DoubleVector.isFinite(df2) || !DoubleVector.isFinite(ncp)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return SignRank.R_D__0(true, give_log);
        }
        if (x == 0.0 && df2 < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (ncp == 0.0) {
            return Distributions.dchisq(x, df2, give_log);
        }
        if (x == Double.POSITIVE_INFINITY) {
            return SignRank.R_D__0(true, give_log);
        }
        double ncp2 = 0.5 * ncp;
        double imax = Math.ceil((-(2.0 + df2) + Math.sqrt((2.0 - df2) * (2.0 - df2) + 4.0 * ncp * x)) / 4.0);
        if (imax < 0.0) {
            imax = 0.0;
        }
        if (DoubleVector.isFinite(imax)) {
            dfmid = df2 + 2.0 * imax;
            mid = Poisson.dpois_raw(imax, ncp2, false) * Distributions.dchisq(x, dfmid, false);
        } else {
            mid = 0.0;
        }
        if (mid == 0.0) {
            if (give_log || ncp > 1000.0) {
                double nl = df2 + ncp;
                double ic = nl / (nl + ncp);
                return Distributions.dchisq(x * ic, nl * ic, give_log);
            }
            return SignRank.R_D__0(true, give_log);
        }
        double sum2 = mid;
        double term = mid;
        df2 = dfmid;
        double i = imax;
        double x2 = x * ncp2;
        do {
            q = x2 / (i += 1.0) / df2;
            df2 += 2.0;
        } while (q >= 1.0 || term * q > (1.0 - q) * 5.0E-15 || term > 1.0E-10 * (sum2 += (term *= q)));
        term = mid;
        df2 = dfmid;
        i = imax;
        while (i >= 0.0) {
            q = i * (df2 -= 2.0) / x2;
            i -= 1.0;
            sum2 += (term *= q);
            if (!(q < 1.0) || !(term * q <= (1.0 - q) * 5.0E-15)) continue;
            break;
        }
        return SignRank.R_D_val(sum2, true, give_log);
    }
}

