/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.invoke.annotations.Current;
import org.renjin.primitives.MathExt;
import org.renjin.stats.internals.distributions.Exponantial;
import org.renjin.stats.internals.distributions.Normal;

public class Gamma {
    static final double sqrt32 = 5.656854;
    static final double exp_m1 = 0.36787944117144233;
    static final double q1 = 0.04166669;
    static final double q2 = 0.02083148;
    static final double q3 = 0.00801191;
    static final double q4 = 0.00144121;
    static final double q5 = -7.388E-5;
    static final double q6 = 2.4511E-4;
    static final double q7 = 2.424E-4;
    static final double a1 = 0.3333333;
    static final double a2 = -0.250003;
    static final double a3 = 0.2000062;
    static final double a4 = -0.1662921;
    static final double a5 = 0.1423657;
    static final double a6 = -0.1367177;
    static final double a7 = 0.1233795;
    static double aa = 0.0;
    static double aaa = 0.0;
    static double s;
    static double s2;
    static double d;
    static double q0;
    static double b;
    static double si;
    static double c;

    public static double rgamma(@Current Session context, double a, double scale) {
        double q;
        double v;
        if (a < 0.0 || scale <= 0.0) {
            if (scale == 0.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (a < 1.0) {
            double x;
            if (a == 0.0) {
                return 0.0;
            }
            double e = 1.0 + 0.36787944117144233 * a;
            while (true) {
                double p;
                if ((p = e * context.rng.unif_rand()) >= 1.0) {
                    x = -Math.log((e - p) / a);
                    if (!(Exponantial.exp_rand(context) >= (1.0 - a) * Math.log(x))) continue;
                    break;
                }
                x = Math.exp(Math.log(p) / a);
                if (Exponantial.exp_rand(context) >= x) break;
            }
            return scale * x;
        }
        if (a != aa) {
            aa = a;
            s2 = a - 0.5;
            s = Math.sqrt(s2);
            d = 5.656854 - s * 12.0;
        }
        double t2 = Normal.norm_rand(context);
        double x = s + 0.5 * t2;
        double ret_val = x * x;
        if (t2 >= 0.0) {
            return scale * ret_val;
        }
        double u = context.rng.unif_rand();
        if (d * u <= t2 * t2 * t2) {
            return scale * ret_val;
        }
        if (a != aaa) {
            aaa = a;
            double r = 1.0 / a;
            q0 = ((((((2.424E-4 * r + 2.4511E-4) * r + -7.388E-5) * r + 0.00144121) * r + 0.00801191) * r + 0.02083148) * r + 0.04166669) * r;
            if (a <= 3.686) {
                b = 0.463 + s + 0.178 * s2;
                si = 1.235;
                c = 0.195 / s - 0.079 + 0.16 * s;
            } else if (a <= 13.022) {
                b = 1.654 + 0.0076 * s2;
                si = 1.68 / s + 0.275;
                c = 0.062 / s + 0.024;
            } else {
                b = 1.77;
                si = 0.75;
                c = 0.1515 / s;
            }
        }
        if (x > 0.0) {
            v = t2 / (s + s);
            q = Math.abs(v) <= 0.25 ? q0 + 0.5 * t2 * t2 * ((((((0.1233795 * v + -0.1367177) * v + 0.1423657) * v + -0.1662921) * v + 0.2000062) * v + -0.250003) * v + 0.3333333) * v : q0 - s * t2 + 0.25 * t2 * t2 + (s2 + s2) * Math.log(1.0 + v);
            if (Math.log(1.0 - u) <= q) {
                return scale * ret_val;
            }
        }
        while (true) {
            double e = Exponantial.exp_rand(context);
            u = context.rng.unif_rand();
            t2 = (u = u + u - 1.0) < 0.0 ? b - si * e : b + si * e;
            if (!(t2 >= -0.71874483771719) || !((q = Math.abs(v = t2 / (s + s)) <= 0.25 ? q0 + 0.5 * t2 * t2 * ((((((0.1233795 * v + -0.1367177) * v + 0.1423657) * v + -0.1662921) * v + 0.2000062) * v + -0.250003) * v + 0.3333333) * v : q0 - s * t2 + 0.25 * t2 * t2 + (s2 + s2) * Math.log(1.0 + v)) > 0.0)) continue;
            double w = MathExt.expm1(q);
            if (c * Math.abs(u) <= w * Math.exp(e - 0.5 * t2 * t2)) break;
        }
        x = s + 0.5 * t2;
        return scale * x * x;
    }
}

