/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.distributions.Binom;

public class Multinomial {
    public static void rmultinom(Session context, int n, double[] prob, int K, int[] rN) {
        double pp;
        int k;
        double p_tot = 0.0;
        if (K < 1) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (K == Integer.MIN_VALUE || K < 1) {
            return;
        }
        if (n == Integer.MIN_VALUE || n < 0) {
            return;
        }
        for (k = 0; k < K; ++k) {
            pp = prob[k];
            if (!DoubleVector.isFinite(pp) || pp < 0.0 || pp > 1.0) {
                return;
            }
            p_tot += pp;
            rN[k] = 0;
        }
        if (Math.abs(p_tot - 1.0) > 1.0E-7 && n == 0) {
            return;
        }
        if (K == 1 && p_tot == 0.0) {
            return;
        }
        for (k = 0; k < K - 1; ++k) {
            if (prob[k] != 0.0) {
                pp = prob[k] / p_tot;
                rN[k] = pp < 1.0 ? (int)Binom.rbinom(context, n, pp) : n;
                n -= rN[k];
            } else {
                rN[k] = 0;
            }
            if (n <= 0) {
                return;
            }
            p_tot -= prob[k];
        }
        rN[K - 1] = n;
    }
}

