/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.stats.internals.distributions.N01type;

public class Normal {
    static final double[] a = new double[]{0.0, 0.03917609, 0.07841241, 0.1177699, 0.1573107, 0.1970991, 0.2372021, 0.2776904, 0.3186394, 0.3601299, 0.4022501, 0.4450965, 0.4887764, 0.5334097, 0.5791322, 0.626099, 0.6744898, 0.7245144, 0.7764218, 0.8305109, 0.8871466, 0.9467818, 1.00999, 1.077516, 1.150349, 1.229859, 1.318011, 1.417797, 1.534121, 1.67594, 1.862732, 2.153875};
    static final double[] d = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.2636843, 0.2425085, 0.2255674, 0.2116342, 0.1999243, 0.1899108, 0.1812252, 0.1736014, 0.1668419, 0.1607967, 0.1553497, 0.1504094, 0.1459026, 0.14177, 0.1379632, 0.1344418, 0.1311722, 0.128126, 0.1252791, 0.1226109, 0.1201036, 0.1177417, 0.1155119, 0.1134023, 0.1114027, 0.1095039};
    static final double[] t = new double[]{7.673828E-4, 0.00230687, 0.003860618, 0.005438454, 0.007050699, 0.008708396, 0.01042357, 0.01220953, 0.01408125, 0.01605579, 0.0181529, 0.02039573, 0.02281177, 0.02543407, 0.02830296, 0.03146822, 0.03499233, 0.03895483, 0.04345878, 0.04864035, 0.05468334, 0.06184222, 0.07047983, 0.08113195, 0.09462444, 0.1123001, 0.136498, 0.1716886, 0.2276241, 0.330498, 0.5847031};
    static final double[] h = new double[]{0.03920617, 0.03932705, 0.03950999, 0.03975703, 0.04007093, 0.04045533, 0.04091481, 0.04145507, 0.04208311, 0.04280748, 0.04363863, 0.04458932, 0.04567523, 0.04691571, 0.04833487, 0.04996298, 0.05183859, 0.05401138, 0.05654656, 0.0595313, 0.06308489, 0.06737503, 0.07264544, 0.07926471, 0.08781922, 0.09930398, 0.1155599, 0.1404344, 0.1836142, 0.2790016, 0.7010474};
    static final double A = 2.216035867166471;
    static double C1 = 0.398942280401433;
    static double C2 = 0.180025191068563;
    static N01type N01_kind = N01type.INVERSION;

    static double g(double x) {
        return C1 * Math.exp(-x * x / 2.0) - C2 * (2.216035867166471 - x);
    }

    public static double rnorm(Session context, double mu, double sigma) {
        if (Double.NaN == mu || sigma < 0.0) {
            return Double.NaN;
        }
        if (sigma == 0.0) {
            return mu;
        }
        return mu + sigma * Normal.norm_rand(context);
    }

    public static double norm_rand(Session context) {
        switch (N01_kind) {
            case AHRENS_DIETER: {
                double w;
                double aa;
                double u2;
                double u1 = context.rng.unif_rand();
                double s = 0.0;
                if (u1 > 0.5) {
                    s = 1.0;
                }
                u1 = u1 + u1 - s;
                int i = (int)(u1 *= 32.0);
                if (i == 32) {
                    i = 31;
                }
                if (i != 0) {
                    u2 = u1 - (double)i;
                    aa = a[i - 1];
                    while (u2 <= t[i - 1]) {
                        u1 = context.rng.unif_rand();
                        w = u1 * (a[i] - aa);
                        double tt = (w * 0.5 + aa) * w;
                        while (true) {
                            if (u2 > tt) {
                                double y = aa + w;
                                return s == 1.0 ? -y : y;
                            }
                            u1 = context.rng.unif_rand();
                            if (u2 < u1) break;
                            tt = u1;
                            u2 = context.rng.unif_rand();
                        }
                        u2 = context.rng.unif_rand();
                    }
                } else {
                    i = 6;
                    double aa2 = a[31];
                    while (!((u1 += u1) >= 1.0)) {
                        aa2 += d[i - 1];
                        ++i;
                    }
                    u1 -= 1.0;
                    while (true) {
                        double w2 = u1 * d[i - 1];
                        double tt = (w2 * 0.5 + aa2) * w2;
                        while (true) {
                            double u22;
                            if ((u22 = context.rng.unif_rand()) > tt) {
                                double y = aa2 + w2;
                                return s == 1.0 ? -y : y;
                            }
                            u1 = context.rng.unif_rand();
                            if (u22 < u1) break;
                            tt = u1;
                        }
                        u1 = context.rng.unif_rand();
                    }
                }
                w = (u2 - t[i - 1]) * h[i - 1];
                double y = aa + w;
                return s == 1.0 ? -y : y;
            }
            case BUGGY_KINDERMAN_RAMAGE: {
                double tt5;
                double u35;
                double u26;
                double u1 = context.rng.unif_rand();
                if (u1 < 0.884070402298758) {
                    double u22 = context.rng.unif_rand();
                    return 2.216035867166471 * (1.1311316354418 * u1 + u22 - 1.0);
                }
                if (u1 >= 0.973310954173898) {
                    double u32;
                    double tt2;
                    double u23;
                    while (!((u23 = context.rng.unif_rand()) * u23 < 4.910814964568252 / (tt2 = 4.910814964568252 - 2.0 * Math.log(u32 = context.rng.unif_rand())))) {
                    }
                    return u1 < 0.986655477086949 ? Math.sqrt(tt2) : -Math.sqrt(tt2);
                }
                if (u1 >= 0.958720824790463) {
                    double tt3;
                    double u33;
                    double u24;
                    do {
                        u24 = context.rng.unif_rand();
                        u33 = context.rng.unif_rand();
                        tt3 = 2.216035867166471 - 0.63083480192196 * Math.min(u24, u33);
                        if (!(Math.max(u24, u33) <= 0.755591531667601)) continue;
                        return u24 < u33 ? tt3 : -tt3;
                    } while (!(0.034240503750111 * Math.abs(u24 - u33) <= Normal.g(tt3)));
                    return u24 < u33 ? tt3 : -tt3;
                }
                if (u1 >= 0.911312780288703) {
                    double tt4;
                    double u34;
                    double u25;
                    do {
                        u25 = context.rng.unif_rand();
                        u34 = context.rng.unif_rand();
                        tt4 = 0.479727404222441 + 1.10547366102207 * Math.min(u25, u34);
                        if (!(Math.max(u25, u34) <= 0.87283497667179)) continue;
                        return u25 < u34 ? tt4 : -tt4;
                    } while (!(0.049264496373128 * Math.abs(u25 - u34) <= Normal.g(tt4)));
                    return u25 < u34 ? tt4 : -tt4;
                }
                do {
                    u26 = context.rng.unif_rand();
                    u35 = context.rng.unif_rand();
                    tt5 = 0.479727404222441 - 0.59550713801594 * Math.min(u26, u35);
                } while (!(Math.max(u26, u35) <= 0.805577924423817));
                return u26 < u35 ? tt5 : -tt5;
            }
            case BOX_MULLER: {
                throw new UnsupportedOperationException(N01_kind.toString() + " not implemented yet");
            }
            case USER_NORM: {
                throw new UnsupportedOperationException(N01_kind.toString() + " not implemented yet");
            }
            case INVERSION: {
                int BIG = 0x8000000;
                double u1 = context.rng.unif_rand();
                u1 = (double)((int)((double)BIG * u1)) + context.rng.unif_rand();
                return Normal.qnorm5(u1 / (double)BIG, 0.0, 1.0, 1, 0);
            }
            case KINDERMAN_RAMAGE: {
                double u3;
                double u2;
                double tt;
                double u1 = context.rng.unif_rand();
                if (u1 < 0.884070402298758) {
                    double u26 = context.rng.unif_rand();
                    return 2.216035867166471 * (1.13113163544418 * u1 + u26 - 1.0);
                }
                if (u1 >= 0.973310954173898) {
                    double u35;
                    double tt5;
                    double u27;
                    while (!((u27 = context.rng.unif_rand()) * u27 < 4.910814964568252 / (tt5 = 4.910814964568252 - 2.0 * Math.log(u35 = context.rng.unif_rand())))) {
                    }
                    return u1 < 0.986655477086949 ? Math.sqrt(tt5) : -Math.sqrt(tt5);
                }
                if (u1 >= 0.958720824790463) {
                    double tt6;
                    double u36;
                    double u28;
                    do {
                        u28 = context.rng.unif_rand();
                        u36 = context.rng.unif_rand();
                        tt6 = 2.216035867166471 - 0.63083480192196 * Math.min(u28, u36);
                        if (!(Math.max(u28, u36) <= 0.755591531667601)) continue;
                        return u28 < u36 ? tt6 : -tt6;
                    } while (!(0.034240503750111 * Math.abs(u28 - u36) <= Normal.g(tt6)));
                    return u28 < u36 ? tt6 : -tt6;
                }
                if (u1 >= 0.911312780288703) {
                    double tt7;
                    double u37;
                    double u29;
                    do {
                        u29 = context.rng.unif_rand();
                        u37 = context.rng.unif_rand();
                        tt7 = 0.479727404222441 + 1.10547366102207 * Math.min(u29, u37);
                        if (!(Math.max(u29, u37) <= 0.87283497667179)) continue;
                        return u29 < u37 ? tt7 : -tt7;
                    } while (!(0.049264496373128 * Math.abs(u29 - u37) <= Normal.g(tt7)));
                    return u29 < u37 ? tt7 : -tt7;
                }
                while (true) {
                    if ((tt = 0.479727404222441 - 0.59550713801594 * Math.min(u2 = context.rng.unif_rand(), u3 = context.rng.unif_rand())) < 0.0) continue;
                    if (Math.max(u2, u3) <= 0.805577924423817) {
                        return u2 < u3 ? tt : -tt;
                    }
                    if (0.053377549506886 * Math.abs(u2 - u3) <= Normal.g(tt)) break;
                }
                return u2 < u3 ? tt : -tt;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)N01_kind));
    }

    static double R_D_val(double x, double log_p) {
        if (log_p != 0.0) {
            return Math.log(x);
        }
        return x;
    }

    static double R_DT_qIv(double p, double log_p, double lower_tail) {
        return Normal.R_D_Lval(Normal.R_D_qIv(p, log_p), lower_tail);
    }

    static double R_D_Lval(double p, double lower_tail) {
        if (lower_tail != 0.0) {
            return p;
        }
        return 0.5 - p + 0.5;
    }

    static double R_D_qIv(double p, double log_p) {
        if (log_p != 0.0) {
            return Math.exp(p);
        }
        return p;
    }

    static double R_DT_CIv(double p, double log_p, double lower_tail) {
        return Normal.R_D_Cval(Normal.R_D_qIv(p, log_p), lower_tail);
    }

    static double R_D_Cval(double p, double lower_tail) {
        if (lower_tail != 0.0) {
            return 0.5 - p + 0.5;
        }
        return p;
    }

    static double qnorm5(double p, double mu, double sigma, int lower_tail, int log_p) {
        double val;
        if (p == Double.NaN || mu == Double.NaN || sigma == Double.NaN) {
            return p + mu + sigma;
        }
        if (sigma < 0.0) {
            return Double.NaN;
        }
        if (sigma == 0.0) {
            return mu;
        }
        double p_ = Normal.R_DT_qIv(p, log_p, lower_tail);
        double q = p_ - 0.5;
        if (Math.abs(q) <= 0.425) {
            double r = 0.180625 - q * q;
            val = q * (((((((r * 2509.0809287301227 + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((r * 5226.495278852854 + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
        } else {
            double r = q > 0.0 ? Normal.R_DT_CIv(p, log_p, lower_tail) : p_;
            r = log_p != 0 && (lower_tail != 0 && q <= 0.0 || lower_tail == 0 && q > 0.0) ? Math.sqrt(-p) : Math.sqrt(-Math.log(r));
            val = r <= 5.0 ? ((((((((r += -1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((r * 1.0507500716444169E-9 + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : ((((((((r += -5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((r * 2.0442631033899397E-15 + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }
}

