/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.plugin;

import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imglib2.type.Type;
import net.imglib2.util.Cast;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.scijava.Cancelable;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.log.Logger;
import org.scijava.plugin.Parameter;
import sc.fiji.labkit.ui.segmentation.SegmentationTool;
import sc.fiji.labkit.ui.utils.progress.StatusServiceProgressWriter;

abstract class AbstractProcessFilesInDirectoryPlugin
implements Command,
Cancelable {
    @Parameter
    private DatasetIOService io;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private Logger logger;
    @Parameter(style="directory")
    private File input_directory;
    @Parameter
    private String file_filter = "*.tif";
    @Parameter(style="directory")
    private File output_directory;
    @Parameter
    private String output_file_suffix = this.defaultOutputFileSuffix();
    @Parameter(style="open")
    private File segmenter_file;
    @Parameter
    private Boolean use_gpu = false;

    AbstractProcessFilesInDirectoryPlugin() {
    }

    public void run() {
        SegmentationTool segmenter = new SegmentationTool();
        segmenter.setUseGpu(this.use_gpu);
        segmenter.openModel(this.segmenter_file.getAbsolutePath());
        segmenter.setProgressWriter(new StatusServiceProgressWriter(this.statusService));
        WildcardFileFilter wildcardFileFilter = new WildcardFileFilter(this.file_filter);
        Object[] files = this.input_directory.listFiles((FileFilter)wildcardFileFilter);
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            try {
                this.processFile(segmenter, (File[])files, i);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    private <T extends Type<T>> void processFile(SegmentationTool segmenter, File[] files, int i) throws IOException {
        File inputFile = files[i];
        String inputFileName = inputFile.getName();
        String outputFileName = FilenameUtils.getBaseName((String)inputFileName) + this.output_file_suffix;
        File outputFile = new File(this.output_directory, outputFileName);
        if (outputFile.exists()) {
            this.logger.warn((Object)("Labkit: Skipping " + inputFile + " because output file exists already: " + outputFile));
            return;
        }
        ImgPlus inputImage = this.io.open(inputFile.getAbsolutePath()).getImgPlus();
        this.statusService.showStatus("Labkit " + this.getDescription() + " " + (i + 1) + "/" + files.length + ": " + inputFileName);
        ImgPlus restult = (ImgPlus)Cast.unchecked(this.processImage(segmenter, inputImage));
        Dataset dataset = this.datasetService.create(restult);
        this.io.save(dataset, outputFile.getAbsolutePath());
    }

    protected abstract ImgPlus<?> processImage(SegmentationTool var1, ImgPlus<?> var2);

    protected abstract String getDescription();

    protected abstract String defaultOutputFileSuffix();

    public boolean isCanceled() {
        return false;
    }

    public void cancel(String reason) {
    }

    public String getCancelReason() {
        return null;
    }
}

