/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.util.Set;
import net.imglib2.cache.CacheLoader;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Fraction;

public class EmptyCellCacheLoader<A extends ArrayDataAccess<A>>
implements CacheLoader<Long, Cell<A>> {
    private final CellGrid grid;
    private final Fraction entitiesPerPixel;
    private final A creator;

    public EmptyCellCacheLoader(CellGrid grid, Fraction entitiesPerPixel, A creator) {
        this.grid = grid;
        this.entitiesPerPixel = entitiesPerPixel;
        this.creator = creator;
    }

    @Override
    public Cell<A> get(Long key) throws Exception {
        long index = key;
        long[] cellMin = new long[this.grid.numDimensions()];
        CellGrid.CellDimensionsAndSteps dimsAndSteps = this.grid.getCellDimensions(index, cellMin);
        long numEntities = this.entitiesPerPixel.mulCeil((long)dimsAndSteps.numPixels());
        return new Cell(dimsAndSteps, cellMin, this.creator.createArray((int)numEntities));
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>> EmptyCellCacheLoader<A> get(CellGrid grid, T type, Set<AccessFlags> flags) {
        return EmptyCellCacheLoader.get(grid, type.getEntitiesPerPixel(), type.getNativeTypeFactory().getPrimitiveType(), flags);
    }

    public static <A extends ArrayDataAccess<A>> EmptyCellCacheLoader<A> get(CellGrid grid, Fraction entitiesPerPixel, PrimitiveType primitiveType, Set<AccessFlags> flags) {
        ArrayDataAccess creator = ArrayDataAccessFactory.get((PrimitiveType)primitiveType, flags);
        return creator == null ? null : new EmptyCellCacheLoader<ArrayDataAccess>(grid, entitiesPerPixel, creator);
    }
}

