/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.gui.beans.ShadowBorder;

public class Note
extends JPanel {
    private static final long serialVersionUID = -7272355421198069040L;
    protected String m_noteText = "New note";
    protected JLabel m_label = new JLabel();
    protected int m_fontSizeAdjust = -1;

    public Note() {
        this.setLayout(new BorderLayout());
        this.setBorder(new ShadowBorder(2, Color.GRAY));
        this.m_label.setText(this.convertToHTML(this.m_noteText));
        this.m_label.setOpaque(true);
        this.m_label.setBackground(Color.YELLOW);
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        holder.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        holder.setOpaque(true);
        holder.setBackground(Color.YELLOW);
        holder.add((Component)this.m_label, "Center");
        this.add((Component)holder, "Center");
    }

    public void setHighlighted(boolean highlighted) {
        if (highlighted) {
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.BLUE));
        } else {
            this.setBorder(new ShadowBorder(2, Color.GRAY));
        }
        this.revalidate();
    }

    private String convertToHTML(String text) {
        String htmlString = this.m_noteText.replace("\n", "<br>");
        htmlString = "<html><font size=" + this.m_fontSizeAdjust + ">" + htmlString + "</font></html>";
        return htmlString;
    }

    public void setNoteText(String noteText) {
        this.m_noteText = noteText;
        this.m_label.setText(this.convertToHTML(this.m_noteText));
    }

    public String getNoteText() {
        return this.m_noteText;
    }

    public void setFontSizeAdjust(int adjust) {
        this.m_fontSizeAdjust = adjust;
    }

    public int getFontSizeAdjust() {
        return this.m_fontSizeAdjust;
    }

    public void decreaseFontSize() {
        --this.m_fontSizeAdjust;
    }

    public void increaseFontSize() {
        ++this.m_fontSizeAdjust;
    }
}

