/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.fft.FFTFunctions;
import net.imglib2.algorithm.fft.FourierTransform;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;

@Deprecated
public class InverseFourierTransform<T extends RealType<T>, S extends ComplexType<S>>
implements MultiThreaded,
OutputAlgorithm<Img<T>>,
Benchmark {
    final RandomAccessibleInterval<S> fftImage;
    final int numDimensions;
    final ImgFactory<T> imgFactory;
    Img<T> image;
    T type;
    FourierTransform.Rearrangement rearrangement;
    String errorMessage = "";
    int numThreads;
    long processingTime;
    boolean scale;
    boolean cropBack;
    int[] originalSize;
    int[] originalOffset;
    float additionalNormalization;

    public InverseFourierTransform(RandomAccessibleInterval<S> fftImage, ImgFactory<T> imgFactory, T type, FourierTransform.Rearrangement rearrangement, boolean scale, boolean cropBack, int[] originalSize, int[] originalOffset) {
        this.fftImage = fftImage;
        this.imgFactory = imgFactory;
        this.type = type;
        this.numDimensions = fftImage.numDimensions();
        this.rearrangement = rearrangement;
        this.scale = scale;
        this.cropBack = cropBack;
        this.additionalNormalization = 1.0f;
        if (originalSize != null) {
            this.originalSize = (int[])originalSize.clone();
        }
        if (originalOffset != null) {
            this.originalOffset = (int[])originalOffset.clone();
        }
        this.setNumThreads();
    }

    public InverseFourierTransform(RandomAccessibleInterval<S> fftImage, ImgFactory<T> imgFactory, FourierTransform<T, ?> forwardTransform) {
        this(fftImage, imgFactory, forwardTransform.getImageType(), forwardTransform.getRearrangement(), true, true, forwardTransform.getFFTInputSize(), forwardTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(RandomAccessibleInterval<S> fftImage, ImgFactory<T> imgFactory, FourierTransform<?, ?> forwardTransform, T type) {
        this(fftImage, imgFactory, type, forwardTransform.getRearrangement(), true, true, forwardTransform.getFFTInputSize(), forwardTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(RandomAccessibleInterval<S> fftImage, ImgFactory<T> imgFactory, T type) {
        this(fftImage, imgFactory, type, FourierTransform.Rearrangement.REARRANGE_QUADRANTS, true, false, null, null);
    }

    public InverseFourierTransform(Img<S> fftImage, FourierTransform<T, ?> forwardTransform) throws IncompatibleTypeException {
        this((RandomAccessibleInterval<S>)fftImage, (ImgFactory<T>)fftImage.factory().imgFactory(forwardTransform.getImageType()), forwardTransform.getImageType(), forwardTransform.getRearrangement(), true, true, forwardTransform.getFFTInputSize(), forwardTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(Img<S> fftImage, FourierTransform<?, ?> forwardTransform, T type) throws IncompatibleTypeException {
        this((RandomAccessibleInterval<S>)fftImage, (ImgFactory<T>)fftImage.factory().imgFactory(type), type, forwardTransform.getRearrangement(), true, true, forwardTransform.getFFTInputSize(), forwardTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(Img<S> fftImage, T type) throws IncompatibleTypeException {
        this((RandomAccessibleInterval<S>)fftImage, (ImgFactory<T>)fftImage.factory().imgFactory(type), type, FourierTransform.Rearrangement.REARRANGE_QUADRANTS, true, false, null, null);
    }

    public void setRearrangement(FourierTransform.Rearrangement rearrangement) {
        this.rearrangement = rearrangement;
    }

    public void setDoScaling(boolean scale) {
        this.scale = scale;
    }

    public void setCropBackToOriginalSize(boolean cropBack) {
        this.cropBack = cropBack;
    }

    public void setOriginalSize(int[] originalSize) {
        this.originalSize = originalSize;
    }

    public void setOriginalOffset(int[] originalOffset) {
        this.originalOffset = originalOffset;
    }

    public void setAdditionalNormalization(float additionalNormalization) {
        this.additionalNormalization = additionalNormalization;
    }

    public FourierTransform.Rearrangement getRearrangement() {
        return this.rearrangement;
    }

    public boolean getDoScaling() {
        return this.scale;
    }

    public boolean getCropBackToOriginalSize() {
        return this.cropBack;
    }

    public int[] getOriginalSize() {
        return (int[])this.originalSize.clone();
    }

    public int[] getOriginalOffset() {
        return (int[])this.originalOffset.clone();
    }

    public float getAdditionalNormalization() {
        return this.additionalNormalization;
    }

    public boolean process() {
        long startTime = System.currentTimeMillis();
        RandomAccessibleInterval<S> complex = this.fftImage;
        if (this.rearrangement == FourierTransform.Rearrangement.REARRANGE_QUADRANTS) {
            FFTFunctions.rearrangeFFTQuadrants(complex, false, this.getNumThreads());
        }
        this.image = FFTFunctions.computeInverseFFT(complex, this.imgFactory, this.type, this.getNumThreads(), this.scale, this.cropBack, this.originalSize, this.originalOffset, this.additionalNormalization);
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public Img<T> getResult() {
        return this.image;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.fftImage == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

