/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.TypedAxis;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.ImgView;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;

public class ImgPlusViews {
    private static final List<AxisType> imagePlusAxisOrder = Arrays.asList(Axes.X, Axes.Y, Axes.CHANNEL, Axes.Z, Axes.TIME);

    public static <T extends Type<T>> ImgPlus<T> hyperSlice(ImgPlus<T> image, int d, long position) {
        IntUnaryOperator axesMapping = i -> i < d ? i : i + 1;
        return ImgPlusViews.newImgPlus(image, Views.hyperSlice((RandomAccessibleInterval)image.getImg(), (int)d, (long)position), axesMapping);
    }

    public static <T extends Type<T>> ImgPlus<T> permute(ImgPlus<T> image, int fromAxis, int toAxis) {
        if (fromAxis == toAxis) {
            return image;
        }
        IntUnaryOperator axesMapping = i -> {
            if (i == fromAxis) {
                return toAxis;
            }
            if (i == toAxis) {
                return fromAxis;
            }
            return i;
        };
        return ImgPlusViews.newImgPlus(image, Views.permute((RandomAccessibleInterval)image.getImg(), (int)fromAxis, (int)toAxis), axesMapping);
    }

    public static <T extends Type<T>> ImgPlus<T> moveAxis(ImgPlus<T> image, int fromAxis, int toAxis) {
        if (fromAxis == toAxis) {
            return image;
        }
        int direction = toAxis > fromAxis ? 1 : -1;
        ImgPlus<T> res = image;
        for (int i = fromAxis; i != toAxis; i += direction) {
            res = ImgPlusViews.permute(res, i, i + direction);
        }
        return res;
    }

    public static boolean canFuseColor(ImgPlus<? extends RealType<?>> image) {
        int d = image.dimensionIndex(Axes.CHANNEL);
        return d >= 0 && image.dimension(d) == 3L;
    }

    public static ImgPlus<ARGBType> fuseColor(ImgPlus<? extends RealType<?>> image) {
        int d = image.dimensionIndex(Axes.CHANNEL);
        RandomAccessibleInterval<ARGBType> colors = ImgPlusViews.fuseColor(image.getImg(), d);
        IntUnaryOperator axisMapping = i -> i < d ? i : i + 1;
        return ImgPlusViews.newImgPlus(image, colors, axisMapping);
    }

    private static RandomAccessibleInterval<ARGBType> fuseColor(Img<? extends RealType<?>> image, int d) {
        if (d < 0 || image.dimension(d) != 3L) {
            throw new IllegalArgumentException();
        }
        return Converters.convert((RandomAccessibleInterval)Views.collapse(ImgPlusViews.moveAxis(image, d, image.numDimensions() - 1)), ImgPlusViews::convertToColor, (Type)new ARGBType());
    }

    public static <T> ImgPlus<T> fixAxes(ImgPlus<T> in) {
        List<AxisType> newAxisTypes = ImgPlusViews.fixAxes(ImgPlusViews.getAxes(in));
        CalibratedAxis[] newAxes = (CalibratedAxis[])IntStream.range(0, in.numDimensions()).mapToObj(i -> {
            CalibratedAxis newAxis = ((CalibratedAxis)in.axis(i)).copy();
            newAxis.setType((AxisType)newAxisTypes.get(i));
            return newAxis;
        }).toArray(CalibratedAxis[]::new);
        return new ImgPlus(in.getImg(), in.getName(), newAxes);
    }

    private static <T extends Type<T>> ImgPlus<T> newImgPlus(ImgPlus<?> image, RandomAccessibleInterval<T> newContent, IntUnaryOperator axesMapping) {
        Type type = (Type)Util.getTypeFromInterval(newContent);
        Img newImg = ImgView.wrap(newContent, (ImgFactory)image.factory().imgFactory((Object)type));
        ImgPlus result = new ImgPlus(newImg, image.getName());
        for (int i = 0; i < result.numDimensions(); ++i) {
            result.setAxis((Axis)((CalibratedAxis)image.axis(axesMapping.applyAsInt(i))).copy(), i);
        }
        return result;
    }

    private static <T> RandomAccessibleInterval<T> moveAxis(RandomAccessibleInterval<T> image, int fromAxis, int toAxis) {
        if (fromAxis == toAxis) {
            return image;
        }
        int direction = toAxis > fromAxis ? 1 : -1;
        IntervalView res = image;
        for (int i = fromAxis; i != toAxis; i += direction) {
            res = Views.permute(res, (int)i, (int)(i + direction));
        }
        return res;
    }

    private static void convertToColor(Composite<? extends RealType<?>> in, ARGBType out) {
        out.set(ARGBType.rgba((int)ImgPlusViews.toInt((RealType)in.get(0L)), (int)ImgPlusViews.toInt((RealType)in.get(1L)), (int)ImgPlusViews.toInt((RealType)in.get(2L)), (int)255));
    }

    private static int toInt(RealType<?> realType) {
        return (int)realType.getRealFloat();
    }

    private static List<AxisType> fixAxes(List<AxisType> in) {
        ArrayList<AxisType> unusedAxis = new ArrayList<AxisType>(imagePlusAxisOrder);
        unusedAxis.removeAll(in);
        Predicate isDuplicate = ImgPlusViews.createIsDuplicatePredicate();
        Predicate<AxisType> replaceIf = axis -> isDuplicate.test(axis) || !imagePlusAxisOrder.contains(axis);
        Iterator iterator = unusedAxis.iterator();
        Supplier<AxisType> replacements = () -> iterator.hasNext() ? (AxisType)iterator.next() : Axes.unknown();
        return ImgPlusViews.replaceMatches(in, replaceIf, replacements);
    }

    static List<AxisType> getAxes(ImgPlus<?> in) {
        return IntStream.range(0, in.numDimensions()).mapToObj(arg_0 -> in.axis(arg_0)).map(TypedAxis::type).collect(Collectors.toList());
    }

    static <T> Predicate<T> createIsDuplicatePredicate() {
        HashSet before = new HashSet();
        return element -> {
            boolean isDuplicate = before.contains(element);
            if (!isDuplicate) {
                before.add(element);
            }
            return isDuplicate;
        };
    }

    static <T> List<T> replaceMatches(List<T> in, Predicate<T> predicate, Supplier<T> replacements) {
        return in.stream().map(value -> predicate.test(value) ? replacements.get() : value).collect(Collectors.toList());
    }
}

