/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraphView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class mxCellMarker
extends JComponent {
    private static final long serialVersionUID = 614473367053597572L;
    public static boolean KEEP_ON_TOP = false;
    public static Stroke DEFAULT_STROKE = new BasicStroke(3.0f);
    protected mxEventSource eventSource = new mxEventSource(this);
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected double hotspot;
    protected boolean hotspotEnabled = false;
    protected boolean swimlaneContentEnabled = false;
    protected Color validColor;
    protected Color invalidColor;
    protected transient Color currentColor;
    protected transient mxCellState validState;
    protected transient mxCellState markedState;

    public mxCellMarker(mxGraphComponent graphComponent) {
        this(graphComponent, mxSwingConstants.DEFAULT_VALID_COLOR);
    }

    public mxCellMarker(mxGraphComponent graphComponent, Color validColor) {
        this(graphComponent, validColor, mxSwingConstants.DEFAULT_INVALID_COLOR);
    }

    public mxCellMarker(mxGraphComponent graphComponent, Color validColor, Color invalidColor) {
        this(graphComponent, validColor, invalidColor, mxConstants.DEFAULT_HOTSPOT);
    }

    public mxCellMarker(mxGraphComponent graphComponent, Color validColor, Color invalidColor, double hotspot) {
        this.graphComponent = graphComponent;
        this.validColor = validColor;
        this.invalidColor = invalidColor;
        this.hotspot = hotspot;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setHotspot(double hotspot) {
        this.hotspot = hotspot;
    }

    public double getHotspot() {
        return this.hotspot;
    }

    public void setHotspotEnabled(boolean enabled) {
        this.hotspotEnabled = enabled;
    }

    public boolean isHotspotEnabled() {
        return this.hotspotEnabled;
    }

    public void setSwimlaneContentEnabled(boolean swimlaneContentEnabled) {
        this.swimlaneContentEnabled = swimlaneContentEnabled;
    }

    public boolean isSwimlaneContentEnabled() {
        return this.swimlaneContentEnabled;
    }

    public void setValidColor(Color value) {
        this.validColor = value;
    }

    public Color getValidColor() {
        return this.validColor;
    }

    public void setInvalidColor(Color value) {
        this.invalidColor = value;
    }

    public Color getInvalidColor() {
        return this.invalidColor;
    }

    public boolean hasValidState() {
        return this.validState != null;
    }

    public mxCellState getValidState() {
        return this.validState;
    }

    public void setCurrentColor(Color value) {
        this.currentColor = value;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public void setMarkedState(mxCellState value) {
        this.markedState = value;
    }

    public mxCellState getMarkedState() {
        return this.markedState;
    }

    public void reset() {
        this.validState = null;
        if (this.markedState != null) {
            this.markedState = null;
            this.unmark();
        }
    }

    public mxCellState process(MouseEvent e) {
        mxCellState state = null;
        if (this.isEnabled()) {
            state = this.getState(e);
            boolean valid = state != null ? this.isValidState(state) : false;
            Color color = this.getMarkerColor(e, state, valid);
            this.highlight(state, color, valid);
        }
        return state;
    }

    public void highlight(mxCellState state, Color color) {
        this.highlight(state, color, true);
    }

    public void highlight(mxCellState state, Color color, boolean valid) {
        this.validState = valid ? state : null;
        if (state != this.markedState || color != this.currentColor) {
            this.currentColor = color;
            if (state != null && this.currentColor != null) {
                this.markedState = state;
                this.mark();
            } else if (this.markedState != null) {
                this.markedState = null;
                this.unmark();
            }
        }
    }

    public void mark() {
        if (this.markedState != null) {
            Rectangle bounds = this.markedState.getRectangle();
            bounds.grow(3, 3);
            ++bounds.width;
            ++bounds.height;
            this.setBounds(bounds);
            if (this.getParent() == null) {
                this.setVisible(true);
                if (KEEP_ON_TOP) {
                    this.graphComponent.getGraphControl().add((Component)this, 0);
                } else {
                    this.graphComponent.getGraphControl().add(this);
                }
            }
            this.repaint();
            this.eventSource.fireEvent(new mxEventObject(mxEvent.MARK, "state", this.markedState));
        }
    }

    public void unmark() {
        if (this.getParent() != null) {
            this.setVisible(false);
            this.getParent().remove(this);
            this.eventSource.fireEvent(new mxEventObject(mxEvent.MARK));
        }
    }

    protected boolean isValidState(mxCellState state) {
        return true;
    }

    protected Color getMarkerColor(MouseEvent e, mxCellState state, boolean isValid) {
        return isValid ? this.validColor : this.invalidColor;
    }

    protected mxCellState getState(MouseEvent e) {
        Object cell = this.getCell(e);
        mxGraphView view = this.graphComponent.getGraph().getView();
        mxCellState state = this.getStateToMark(view.getState(cell));
        return state != null && this.intersects(state, e) ? state : null;
    }

    protected Object getCell(MouseEvent e) {
        return this.graphComponent.getCellAt(e.getX(), e.getY(), this.swimlaneContentEnabled);
    }

    protected mxCellState getStateToMark(mxCellState state) {
        return state;
    }

    protected boolean intersects(mxCellState state, MouseEvent e) {
        if (this.isHotspotEnabled()) {
            return mxUtils.intersectsHotspot(state, e.getX(), e.getY(), this.hotspot, mxConstants.MIN_HOTSPOT_SIZE, mxConstants.MAX_HOTSPOT_SIZE);
        }
        return true;
    }

    public void addListener(String eventName, mxEventSource.mxIEventListener listener) {
        this.eventSource.addListener(eventName, listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener) {
        this.eventSource.removeListener(listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener, String eventName) {
        this.eventSource.removeListener(listener, eventName);
    }

    @Override
    public void paint(Graphics g) {
        if (this.markedState != null && this.currentColor != null) {
            ((Graphics2D)g).setStroke(DEFAULT_STROKE);
            g.setColor(this.currentColor);
            if (this.markedState.getAbsolutePointCount() > 0) {
                Point last = this.markedState.getAbsolutePoint(0).getPoint();
                for (int i = 1; i < this.markedState.getAbsolutePointCount(); ++i) {
                    Point current = this.markedState.getAbsolutePoint(i).getPoint();
                    g.drawLine(last.x - this.getX(), last.y - this.getY(), current.x - this.getX(), current.y - this.getY());
                    last = current;
                }
            } else {
                g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            }
        }
    }
}

