/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.Primitive;
import org.jogamp.vecmath.Matrix4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;

public class Cone
extends Primitive {
    public static final int DEFAULT_PARALLELS = 12;

    public Cone(Point3f from, Point3f to, float r) {
        this(from, to, r, 12);
    }

    public Cone(Point3f from, Point3f to, float r, int parallels) {
        super(Cone.makeVertices(from, to, r, parallels), Cone.makeFaces(parallels));
    }

    private static Point3f[] makeVertices(Point3f from, Point3f to, float r, int parallels) {
        Point3f[] p = new Point3f[parallels + 2];
        p[0] = new Point3f(from);
        p[1] = new Point3f(to);
        for (int i = 0; i < parallels; ++i) {
            double a = (double)(i - 6) * (Math.PI * 2) / 12.0;
            double c = (double)r * Math.cos(a);
            double s = (double)r * Math.sin(a);
            p[i + 2] = new Point3f((float)c, (float)s, 0.0f);
        }
        Matrix4f ry = new Matrix4f();
        float ay = (float)Math.atan2(to.x - from.x, to.z - from.z);
        ry.rotY(ay);
        Matrix4f rx = new Matrix4f();
        float ax = -((float)Math.asin((to.y - from.y) / from.distance(to)));
        rx.rotX(ax);
        rx.mul(ry, rx);
        for (int i = 2; i < p.length; ++i) {
            Point3f pi = p[i];
            rx.transform(pi);
            pi.add((Tuple3f)from);
        }
        return p;
    }

    private static int[] makeFaces(int parallels) {
        int idx = 0;
        int[] faces = new int[6 * parallels];
        for (int i = 0; i < parallels; ++i) {
            faces[idx++] = 2 + i;
            faces[idx++] = 2 + (i + 1) % parallels;
            faces[idx++] = 0;
            faces[idx++] = 2 + i;
            faces[idx++] = 1;
            faces[idx++] = 2 + (i + 1) % parallels;
        }
        return faces;
    }
}

