/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.Box;
import customnode.Cone;
import customnode.Sphere;
import customnode.Tube;
import customnode.u3d.U3DExporter;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import ij.util.Tools;
import ij3d.ColorTable;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.gui.PrimitiveDialogs;
import isosurface.MeshExporter;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import math3d.TransformIO;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import orthoslice.OrthoGroup;
import voltex.VoltexGroup;

public class ImageJ3DViewer
implements PlugIn {
    private static final List<Point3f> pts = new ArrayList<Point3f>();

    public static void main(String[] args) {
        if (IJ.getInstance() == null) {
            new ImageJ();
        }
        IJ.runPlugIn((String)"ij3d.ImageJ3DViewer", (String)"");
    }

    public void run(String arg) {
        ImagePlus image = WindowManager.getCurrentImage();
        try {
            Image3DUniverse univ = new Image3DUniverse();
            univ.show();
            GUI.center((Window)univ.getWindow());
            if (arg != null && !arg.equals("")) {
                ImageJ3DViewer.importContent(arg);
            } else if (image != null && !IJ.isMacro()) {
                univ.getExecuter().addContent(image, null);
            }
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            StackTraceElement[] st = e.getStackTrace();
            buf.append("An unexpected exception occurred. \nPlease mail me the following lines if you \nneed help.\nbene.schmid@gmail.com\n   \n");
            buf.append(e.getClass().getName() + ":" + e.getMessage() + "\n");
            for (int i = 0; i < st.length; ++i) {
                buf.append("    at " + st[i].getClassName() + "." + st[i].getMethodName() + "(" + st[i].getFileName() + ":" + st[i].getLineNumber() + ")\n");
            }
            new TextWindow("Error", buf.toString(), 500, 400);
        }
    }

    private static Image3DUniverse getUniv() {
        if (Image3DUniverse.universes.size() > 0) {
            return Image3DUniverse.universes.get(0);
        }
        return null;
    }

    public static void resetView() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            univ.resetView();
        }
    }

    public static void startAnimate() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            univ.startAnimation();
        }
    }

    public static void stopAnimate() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            univ.pauseAnimation();
        }
    }

    public static void record360() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ == null) {
            return;
        }
        ImagePlus movie = univ.record360();
        if (movie != null) {
            movie.show();
        }
    }

    public static void startFreehandRecording() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            univ.startFreehandRecording();
        }
    }

    public static void stopFreehandRecording() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ == null) {
            return;
        }
        ImagePlus movie = univ.stopFreehandRecording();
        if (movie != null) {
            movie.show();
        }
    }

    public static void close() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            univ.close();
        }
    }

    public static void select(String name) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            univ.select(univ.getContent(name));
        }
    }

    public static void showContent(String name, String b) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            boolean bShow = b.equals("true");
            univ.getContent(name).setVisible(bShow);
            if (!bShow) {
                univ.clearSelection();
            }
        }
    }

    public static void add(String image, String c, String name, String th, String r, String g, String b, String resamplingF, String type) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        ImagePlus grey = WindowManager.getImage((String)image);
        Color3f color = ColorTable.getColor(c);
        int factor = ImageJ3DViewer.getInt(resamplingF);
        int thresh = ImageJ3DViewer.getInt(th);
        boolean[] channels = new boolean[]{ImageJ3DViewer.getBoolean(r), ImageJ3DViewer.getBoolean(g), ImageJ3DViewer.getBoolean(b)};
        int ty = ImageJ3DViewer.getInt(type);
        univ.addContent(grey, color, name, thresh, channels, factor, ty);
    }

    public static void addVolume(String image, String c, String name, String r, String g, String b, String resamplingF) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        ImagePlus grey = WindowManager.getImage((String)image);
        Color3f color = ColorTable.getColor(c);
        int factor = ImageJ3DViewer.getInt(resamplingF);
        boolean[] channels = new boolean[]{ImageJ3DViewer.getBoolean(r), ImageJ3DViewer.getBoolean(g), ImageJ3DViewer.getBoolean(b)};
        univ.addVoltex(grey, color, name, 0, channels, factor);
    }

    public static void addOrthoslice(String image, String c, String name, String r, String g, String b, String resamplingF) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        ImagePlus grey = WindowManager.getImage((String)image);
        Color3f color = ColorTable.getColor(c);
        int factor = ImageJ3DViewer.getInt(resamplingF);
        boolean[] channels = new boolean[]{ImageJ3DViewer.getBoolean(r), ImageJ3DViewer.getBoolean(g), ImageJ3DViewer.getBoolean(b)};
        univ.addOrthoslice(grey, color, name, 0, channels, factor);
    }

    public static void addSphere(String name, String center, String radius) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            Point3f c = PrimitiveDialogs.parsePoint(center);
            float r = Float.parseFloat(radius);
            Sphere s = new Sphere(c, r);
            univ.addCustomMesh(s, name);
        }
    }

    public static void addBox(String name, String lowerCorner, String upperCorner) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            Point3f lc = PrimitiveDialogs.parsePoint(lowerCorner);
            Point3f uc = PrimitiveDialogs.parsePoint(upperCorner);
            univ.addCustomMesh(new Box(lc, uc), name);
        }
    }

    public static void addCone(String name, String from, String to, String radius) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            Point3f p1 = PrimitiveDialogs.parsePoint(from);
            Point3f p2 = PrimitiveDialogs.parsePoint(to);
            float r = Float.parseFloat(radius);
            univ.addCustomMesh(new Cone(p1, p2, r), name);
        }
    }

    public static void addTubePoint(String point) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            pts.add(PrimitiveDialogs.parsePoint(point));
        }
    }

    public static void finishTube(String name, String radius, String point) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            float r = Float.parseFloat(radius);
            pts.add(PrimitiveDialogs.parsePoint(point));
            univ.addCustomMesh(new Tube(pts, r), name);
            pts.clear();
        }
    }

    public static void delete() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            univ.removeContent(univ.getSelected().getName());
        }
    }

    public static void snapshot(String w, String h) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ == null) {
            return;
        }
        int iw = Integer.parseInt(w);
        int ih = Integer.parseInt(h);
        univ.takeSnapshot(iw, ih).show();
    }

    public static void setSlices(String x, String y, String z) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null && univ.getSelected().getType() == 1) {
            OrthoGroup vg = (OrthoGroup)univ.getSelected().getContent();
            vg.setSlice(0, ImageJ3DViewer.getInt(x));
            vg.setSlice(1, ImageJ3DViewer.getInt(y));
            vg.setSlice(2, ImageJ3DViewer.getInt(z));
        }
    }

    public static void fillSelection() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null && univ.getSelected().getType() == 0) {
            VoltexGroup vg = (VoltexGroup)univ.getSelected().getContent();
            ImageCanvas3D canvas = (ImageCanvas3D)univ.getCanvas();
            vg.fillRoi(canvas, canvas.getRoi(), (byte)0);
        }
    }

    public static void lock() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().setLocked(true);
        }
    }

    public static void unlock() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().setLocked(false);
        }
    }

    public static void setChannels(String red, String green, String blue) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        boolean r = Boolean.valueOf(red);
        boolean g = Boolean.valueOf(green);
        boolean b = Boolean.valueOf(blue);
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().setChannels(new boolean[]{r, g, b});
        }
    }

    public static void setColor(String red, String green, String blue) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ == null || univ.getSelected() == null) {
            return;
        }
        Content sel = univ.getSelected();
        try {
            float r = (float)ImageJ3DViewer.getInt(red) / 256.0f;
            float g = (float)ImageJ3DViewer.getInt(green) / 256.0f;
            float b = (float)ImageJ3DViewer.getInt(blue) / 256.0f;
            if (univ != null && univ.getSelected() != null) {
                sel.setColor(new Color3f(r, g, b));
            }
        }
        catch (NumberFormatException e) {
            sel.setColor(null);
        }
    }

    public static void setTransparency(String t) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        float tr = Float.parseFloat(t);
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().setTransparency(tr);
        }
    }

    public static void setCoordinateSystem(String s) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().showCoordinateSystem(ImageJ3DViewer.getBoolean(s));
        }
    }

    public static void setThreshold(String s) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().setThreshold(ImageJ3DViewer.getInt(s));
        }
    }

    public static void applyTransform(String transform) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            String[] s = Tools.split((String)transform);
            float[] m = new float[s.length];
            for (int i = 0; i < s.length; ++i) {
                m[i] = Float.parseFloat(s[i]);
            }
            univ.getSelected().applyTransform(new Transform3D(m));
            univ.fireTransformationUpdated();
        }
    }

    public static void resetTransform() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().setTransform(new Transform3D());
            univ.fireTransformationUpdated();
        }
    }

    public static void saveTransform(String transform, String path) {
        String[] s = Tools.split((String)transform);
        float[] m = new float[s.length];
        for (int i = 0; i < s.length; ++i) {
            m[i] = Float.parseFloat(s[i]);
        }
        new TransformIO().saveAffineTransform(m);
    }

    public static void setTransform(String transform) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            String[] s = Tools.split((String)transform);
            float[] m = new float[s.length];
            for (int i = 0; i < s.length; ++i) {
                m[i] = Float.parseFloat(s[i]);
            }
            univ.getSelected().setTransform(new Transform3D(m));
            univ.fireTransformationUpdated();
        }
    }

    public static void importContent(String path) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null) {
            univ.addContentLater(path);
        }
    }

    public static void exportTransformed() {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            univ.getSelected().exportTransformed().show();
        }
    }

    public static void exportContent(String format, String path) {
        Image3DUniverse univ = ImageJ3DViewer.getUniv();
        if (univ != null && univ.getSelected() != null) {
            if ((format = format.toLowerCase()).equals("dxf")) {
                MeshExporter.saveAsDXF(univ.getContents(), new File(path));
            } else if (format.equals("wavefront")) {
                MeshExporter.saveAsWaveFront(univ.getContents(), new File(path));
            } else if (format.startsWith("stl")) {
                if (format.indexOf("ascii") > 0) {
                    MeshExporter.saveAsSTL(univ.getContents(), new File(path), 0);
                } else {
                    MeshExporter.saveAsSTL(univ.getContents(), new File(path), 1);
                }
            } else if (format.equals("u3d")) {
                try {
                    U3DExporter.export(univ, path);
                }
                catch (IOException e) {
                    IJ.handleException((Throwable)e);
                }
            }
        }
    }

    private static int getInt(String s) {
        return Integer.parseInt(s);
    }

    private static boolean getBoolean(String s) {
        return new Boolean(s);
    }
}

