/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

class Vector3 {
    double x;
    double y;
    double z;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3 normalize(Vector3 r) {
        double vlen;
        if (r == null) {
            r = new Vector3();
        }
        if ((vlen = this.length()) != 0.0) {
            return r.set(this.x / vlen, this.y / vlen, this.z / vlen);
        }
        return null;
    }

    public Vector3 scale(double s, Vector3 r) {
        if (r == null) {
            r = new Vector3();
        }
        return r.set(s * this.x, s * this.y, s * this.z);
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public void setFrom(Vector3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public Vector3 crossWith(Vector3 other, Vector3 result) {
        if (result == null) {
            result = new Vector3();
        }
        double x2 = other.x;
        double y2 = other.y;
        double z2 = other.z;
        result.set(this.y * z2 - this.z * y2, this.z * x2 - this.x * z2, this.x * y2 - this.y * x2);
        return result;
    }

    public double dotWith(Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public boolean isZero(double epsilon) {
        if (Math.abs(this.x) > epsilon) {
            return false;
        }
        if (Math.abs(this.y) > epsilon) {
            return false;
        }
        return !(Math.abs(this.z) > epsilon);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }
}

