/*
 * Decompiled with CFR 0.152.
 */
package ij3d.contextmenu;

import ij3d.Content;
import ij3d.ContentConstants;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ContextMenu
implements ActionListener,
ItemListener,
ContentConstants {
    private final JPopupMenu popup = new JPopupMenu();
    private final Image3DUniverse univ;
    private final Executer executer;
    private Content content;
    private final JMenuItem slices;
    private final JMenuItem updateVol;
    private final JMenuItem fill;
    private final JMenuItem smoothMesh;
    private final JMenuItem smoothAllMeshes;
    private final JMenuItem smoothDialog;
    private final JMenuItem colorSurface;
    private final JMenuItem decimateMesh;
    private final JCheckBoxMenuItem shaded;
    private final JCheckBoxMenuItem saturated;

    public ContextMenu(Image3DUniverse univ) {
        this.univ = univ;
        this.executer = univ.getExecuter();
        this.slices = new JMenuItem("Adjust slices");
        this.slices.addActionListener(this);
        this.popup.add(this.slices);
        this.updateVol = new JMenuItem("Update Volume");
        this.updateVol.addActionListener(this);
        this.popup.add(this.updateVol);
        this.fill = new JMenuItem("Fill selection");
        this.fill.addActionListener(this);
        this.popup.add(this.fill);
        JMenu smooth = new JMenu("Smooth");
        this.popup.add(smooth);
        this.smoothMesh = new JMenuItem("Smooth mesh");
        this.smoothMesh.addActionListener(this);
        smooth.add(this.smoothMesh);
        this.smoothAllMeshes = new JMenuItem("Smooth all meshes");
        this.smoothAllMeshes.addActionListener(this);
        smooth.add(this.smoothAllMeshes);
        this.decimateMesh = new JMenuItem("Decimate mesh");
        this.decimateMesh.addActionListener(this);
        this.popup.add(this.decimateMesh);
        this.smoothDialog = new JMenuItem("Smooth control");
        this.smoothDialog.addActionListener(this);
        smooth.add(this.smoothDialog);
        this.shaded = new JCheckBoxMenuItem("Shade surface");
        this.shaded.setState(true);
        this.shaded.addItemListener(this);
        this.popup.add(this.shaded);
        this.saturated = new JCheckBoxMenuItem("Saturated volume rendering");
        this.saturated.setState(false);
        this.saturated.addItemListener(this);
        this.popup.add(this.saturated);
        this.colorSurface = new JMenuItem("Color surface from image");
        this.colorSurface.addActionListener(this);
        this.popup.add(this.colorSurface);
    }

    public void showPopup(MouseEvent e) {
        this.content = this.univ.getPicker().getPickedContent(e.getX(), e.getY());
        if (this.content == null) {
            return;
        }
        this.univ.select(this.content);
        this.shaded.setState(this.content.isShaded());
        this.saturated.setState(this.content.isSaturatedVolumeRendering());
        if (this.popup.isPopupTrigger(e)) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.shaded) {
            this.executer.setShaded(this.content, this.shaded.getState());
        } else if (src == this.saturated) {
            this.executer.setSaturatedVolumeRendering(this.content, this.saturated.getState());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.updateVol) {
            this.executer.updateVolume(this.content);
        } else if (src == this.slices) {
            this.executer.changeSlices(this.content);
        } else if (src == this.fill) {
            this.executer.fill(this.content);
        } else if (src == this.smoothMesh) {
            this.executer.smoothMesh(this.content);
        } else if (src == this.smoothAllMeshes) {
            this.executer.smoothAllMeshes();
        } else if (src == this.smoothDialog) {
            this.executer.smoothControl();
        } else if (src == this.decimateMesh) {
            this.executer.decimateMesh();
        } else if (src == this.colorSurface) {
            this.executer.applySurfaceColors(this.content);
        }
    }
}

