/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class LSS16_Reader
extends ImagePlus
implements PlugIn {
    protected int nextNybble = -1;

    public void run(String arg) {
        File file = null;
        if (arg != null && arg.length() > 0) {
            file = new File(arg);
        } else {
            OpenDialog od = new OpenDialog("Choose .lss file", null);
            String directory = od.getDirectory();
            if (null == directory) {
                return;
            }
            file = new File(directory + "/" + od.getFileName());
        }
        try {
            FileInputStream in = new FileInputStream(file);
            int signature = LSS16_Reader.readIntLE(in);
            if (signature != 336851773) {
                IJ.error((String)"Wrong signature!");
                return;
            }
            int w = LSS16_Reader.readShortLE(in);
            int h = LSS16_Reader.readShortLE(in);
            byte[] reds = new byte[16];
            byte[] greens = new byte[16];
            byte[] blues = new byte[16];
            for (int i = 0; i < 16; ++i) {
                reds[i] = (byte)(in.read() * 255 / 63);
                greens[i] = (byte)(in.read() * 255 / 63);
                blues[i] = (byte)(in.read() * 255 / 63);
            }
            IndexColorModel cmap = new IndexColorModel(8, 16, reds, greens, blues);
            byte[] pixels = new byte[w * h];
            int k = 0;
            for (int j = 0; j < h; ++j) {
                byte lastColor = 0;
                this.nextNybble = -1;
                int i = 0;
                while (i < w) {
                    byte nybble = this.readNybble(in);
                    if (nybble != lastColor) {
                        pixels[k++] = nybble;
                        lastColor = nybble;
                        ++i;
                        continue;
                    }
                    for (int count = this.readCount(in); count > 0 && i < w; ++i, --count) {
                        pixels[k++] = nybble;
                    }
                }
            }
            String name = file.getName();
            ByteProcessor proc = new ByteProcessor(w, h, pixels, (ColorModel)cmap);
            this.setProcessor(name, (ImageProcessor)proc);
        }
        catch (IOException e) {
            IJ.error((String)("Could not read '" + file.getAbsolutePath() + "'"));
        }
    }

    public static int readIntLE(FileInputStream in) throws IOException {
        byte[] buffer = new byte[4];
        in.read(buffer);
        return (buffer[3] & 0xFF) << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }

    public static int readShortLE(FileInputStream in) throws IOException {
        byte[] buffer = new byte[2];
        in.read(buffer);
        return (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }

    protected byte readNybble(FileInputStream in) throws IOException {
        int result = this.nextNybble;
        if (result < 0) {
            int next = in.read();
            result = next & 0xF;
            this.nextNybble = (next & 0xF0) >> 4;
        } else {
            this.nextNybble = -1;
        }
        return (byte)result;
    }

    protected int readCount(FileInputStream in) throws IOException {
        int count = this.readNybble(in) & 0xFF;
        if (count > 0) {
            return count;
        }
        return (this.readNybble(in) & 0xF) + ((this.readNybble(in) & 0xF) << 4) + 16;
    }
}

