/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Hhea
extends Table {
    private int version;
    private short ascender;
    private short descender;
    private short lineGap;
    private short advanceWidthMax;
    private short minLeftSideBearing;
    private short minRightSideBearing;
    private short xMaxExtent;
    private short caretSlopeRise;
    private short caretSlopeRun;
    private short caretOffset;
    private short metricDataFormat;
    private int numberOfHMetrics;

    public Hhea(FontFile2 fontFile2) {
        LogWriter.writeMethod("{readHheaTable}", 0);
        int n = fontFile2.selectTable(5);
        if (n != 0) {
            this.version = fontFile2.getNextUint32();
            this.ascender = fontFile2.getFWord();
            this.descender = fontFile2.getFWord();
            this.lineGap = fontFile2.getFWord();
            this.advanceWidthMax = fontFile2.readUFWord();
            this.minLeftSideBearing = fontFile2.getFWord();
            this.minRightSideBearing = fontFile2.getFWord();
            this.xMaxExtent = fontFile2.getFWord();
            this.caretSlopeRise = fontFile2.getNextInt16();
            this.caretSlopeRun = fontFile2.getNextInt16();
            this.caretOffset = fontFile2.getFWord();
            for (int i = 0; i < 4; ++i) {
                fontFile2.getNextUint16();
            }
            this.metricDataFormat = fontFile2.getNextInt16();
            this.numberOfHMetrics = fontFile2.getNextUint16();
        }
    }

    public int getNumberOfHMetrics() {
        return this.numberOfHMetrics;
    }
}

